<?php
/**
 * Plugin Name: Lusso Theme CPT
 * Plugin URI: http://alethemes.com
 * Description: A plugin that will init all necessary for Lusso Theme Post Types.
 * Version: 1.0
 * Author: CRIK0VA / ALETHEMES.COM
 * Author URI: http://alethemes.com
 * License: GPL v2
 */

/**
 * Add Needed Post Types
 */
function ale_init_post_types() {
    if (function_exists('aletheme_get_post_types')) {
        foreach (aletheme_get_post_types() as $type => $options) {
            ale_add_post_type($type, $options['config'], $options['singular'], $options['multiple']);
        }
    }
}
add_action('init', 'ale_init_post_types');

/**
 * Add Needed Taxonomies
 */
function ale_init_taxonomies() {
    if (function_exists('aletheme_get_taxonomies')) {
        foreach (aletheme_get_taxonomies() as $type => $options) {
            ale_add_taxonomy($type, $options['for'], $options['config'], $options['singular'], $options['multiple']);
        }
    }
}
add_action('init', 'ale_init_taxonomies');


/**
 * Register Post Type Wrapper
 * @param string $name
 * @param array $config
 * @param string $singular
 * @param string $multiple
 */
function ale_add_post_type($name, $config, $singular = 'Entry', $multiple = 'Entries') {
    if (!isset($config['labels'])) {
        $config['labels'] = array(
            'name' => $multiple,
            'singular_name' => $singular,
            'not_found'=> 'No ' . $multiple . ' Found',
            'not_found_in_trash'=> 'No ' . $multiple . ' found in Trash',
            'edit_item' => 'Edit ', $singular,
            'search_items' => 'Search ' . $multiple,
            'view_item' => 'View ', $singular,
            'new_item' => 'New ' . $singular,
            'add_new' => 'Add New',
            'add_new_item' => 'Add New ' . $singular,
        );
    }

    register_post_type($name, $config);
}

/**
 * Register taxonomy wrapper
 * @param string $name
 * @param mixed $object_type
 * @param array $config
 * @param string $singular
 * @param string $multiple
 */
function ale_add_taxonomy($name, $object_type, $config, $singular = 'Entry', $multiple = 'Entries') {

    if (!isset($config['labels'])) {
        $config['labels'] = array(
            'name' => $multiple,
            'singular_name' => $singular,
            'search_items' =>  'Search ' . $multiple,
            'all_items' => 'All ' . $multiple,
            'parent_item' => 'Parent ' . $singular,
            'parent_item_colon' => 'Parent ' . $singular . ':',
            'edit_item' => 'Edit ' . $singular,
            'update_item' => 'Update ' . $singular,
            'add_new_item' => 'Add New ' . $singular,
            'new_item_name' => 'New ' . $singular . ' Name',
            'menu_name' => $singular,
        );
    }

    register_taxonomy($name, $object_type, $config);
}

/**
 * Sets up a custom post type to attach image to.  This allows us to have
 * individual galleries for different uploaders.
 */

if ( ! function_exists( 'optionsframework_mlu_init' ) ) {
    function optionsframework_mlu_init () {
        register_post_type( 'optionsframework', array(
            'labels' => array(
                'name' => __( 'Theme Options Media', 'options_framework_theme' ),
            ),
            'public' => true,
            'show_ui' => false,
            'capability_type' => 'post',
            'hierarchical' => false,
            'rewrite' => false,
            'supports' => array( 'title', 'editor' ),
            'query_var' => false,
            'can_export' => true,
            'show_in_nav_menus' => false,
            'public' => false
        ) );
    }
}

/**
 * Register Sliders post type to make it queriable
 */
if(class_exists('Aletheme_Sliders')){
    function aletheme_sliders_register_post_type() {
        ale_add_post_type(Aletheme_Sliders::POST_TYPE, array(
            'public' => false,
        ), 'Aletheme Slider', 'Aletheme Sliders');
    }
    add_action( 'init', 'aletheme_sliders_register_post_type' );
}

/**
 * Add post types that are used in the theme
 *
 * @return array
 */
function aletheme_get_post_types() {
    return array(
        'gallery' => array(
            'config' => array(
                'public' => true,
                'menu_position' => 35,
                'has_archive'   => true,
                'supports'=> array(
                    'title',
                    'editor',
                    'thumbnail',
                    'comments'
                ),
                'show_in_nav_menus'=> true,
            ),
            'singular' => 'Gallery',
            'multiple' => 'Galleries',
            'columns'    => array(
                'first_image',
            )
        ),
        'special-offers' => array(
            'config' => array(
                'public' => true,
                'menu_position' => 36,
                'has_archive'   => true,
                'supports'=> array(
                    'title',
                    'editor',
                    'thumbnail',
                    'comments',
                ),
                'show_in_nav_menus'=> false,
            ),
            'singular' => 'Special Offer',
            'multiple' => 'Special Offers',
            'columns'    => array(
                'first_image',
            )
        ),
        'our-team' => array(
            'config' => array(
                'public' => true,
                'menu_position' => 37,
                'has_archive'   => true,
                'supports'=> array(
                    'title',
                    'editor',
                    'thumbnail',
                    'comments',
                ),
                'show_in_nav_menus'=> false,
            ),
            'singular' => 'Our team',
            'multiple' => 'Our teams',
            'columns'    => array(
                'first_image',
            )
        ),
        'listing' => array(
            'config' => array(
                'public' => true,
                'menu_position' => 38,
                'has_archive'   => true,
                'supports'=> array(
                    'title',
                    'editor',
                    'thumbnail',
                    'comments',
                ),
                'show_in_nav_menus'=> false,
            ),
            'singular' => 'Listing',
            'multiple' => 'Listing',
            'columns'    => array(
                'first_image',
            )
        ),
    );
}

/**
 * Add taxonomies that are used in theme
 *
 * @return array
 */
function aletheme_get_taxonomies() {
    return array(

        'gallery-category'    => array(
            'for'        => array('gallery'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'term_order'),
                'hierarchical' => true,
            ),
            'singular'    => 'Gallery Category',
            'multiple'    => 'Gallery Categories',
        ),

        'brand-listing'    => array(
            'for'        => array('listing'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Brand',
            'multiple'    => 'Brands',
        ),
        'year-listing'    => array(
            'for'        => array('listing'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Year',
            'multiple'    => 'Year',
        ),
        'fuel-listing'    => array(
            'for'        => array('listing'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Fuel Type',
            'multiple'    => 'Fuel Type',
        ),
        'transmission-listing'    => array(
            'for'        => array('listing'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Transmission',
            'multiple'    => 'Transmission',
        ),

        'status-listing'    => array(
            'for'        => array('listing'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Status',
            'multiple'    => 'Statuses',
        ),

        'brand-offers'    => array(
            'for'        => array('special-offers'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Brand',
            'multiple'    => 'Brands',
        ),
        'body-offers'    => array(
            'for'        => array('special-offers'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Body',
            'multiple'    => 'Body',
        ),
        'year-offers'    => array(
            'for'        => array('special-offers'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Year',
            'multiple'    => 'Year',
        ),
        'vehicle_type'    => array(
            'for'        => array('special-offers'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Vehicle Type',
            'multiple'    => 'Vehicle Type',
        ),
        'fuel_type'    => array(
            'for'        => array('special-offers'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Fuel Type',
            'multiple'    => 'Fuel Type',
        ),
        'transmission_car'    => array(
            'for'        => array('special-offers'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Transmission',
            'multiple'    => 'Transmission',
        ),

        'team-category'    => array(
            'for'        => array('our-team'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'name'),
                'hierarchical' => true,
            ),
            'singular'    => 'Category team',
            'multiple'    => 'Category teams',
        ),


    );
}
