<?php
/**
 * Template Name: Template Service
 */

get_header(); ?>
	<div class="wrapper white-dark-bg cf page-template-service">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e('Service', 'aletheme'); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>

		<?php if(ale_get_meta('display_service_text')!='off') { ?>
			<div class="text-block">
				<article class="wrapper-inside story">
					<h2><?php echo ale_get_meta_attr('title_top'); ?></h2>
					<?php if (have_posts()) : while (have_posts()) : the_post();
						the_content();
					endwhile; endif; ?>
				</article>
			</div>
		<?php } ?>

		<?php if(ale_get_meta('display_service_information')!='off') { ?>
			<div class="information">
				<div class="wrapper-inside cf">
					<article class="red-bg white-col left">
						<i class="fa fa-gear"></i>
						<h2>
							<?php if(ale_get_meta("title_circle1_service")) {
								echo esc_attr(ale_get_meta("title_circle1_service"));
							} ?>
						</h2>

						<p>
							<?php if(ale_get_meta("text_circle1_service")) {
								echo esc_attr(ale_get_meta("text_circle1_service"));
							} ?>
						</p>
					</article>

					<article class="red-bg white-col left big">
						<i class="fa fa-bell"></i>
						<h2>
							<?php if(ale_get_meta("title_circle2_service")) {
								echo esc_attr(ale_get_meta("title_circle2_service"));
							} ?>
						</h2>

						<p>
							<?php if(ale_get_meta("text_circle2_service")) {
								echo esc_attr(ale_get_meta("text_circle2_service"));
							} ?>
						</p>
					</article>

					<article class="red-bg white-col left">
						<i class="fa fa-bullseye"></i>
						<h2>
							<?php if(ale_get_meta("title_circle3_service")) {
								echo esc_attr(ale_get_meta("title_circle3_service"));
							} ?>
						</h2>

						<p>
							<?php if(ale_get_meta("text_circle3_service")) {
								echo esc_attr(ale_get_meta("text_circle3_service"));
							} ?>
						</p>
					</article>
				</div>
			</div>
		<?php } ?>


		<?php if(ale_get_meta('display_service_details')!='off') { ?>
			<section class="stats">
				<?php if(ale_get_meta("image_service")) { ?>
					<img src="<?php echo esc_url(ale_get_meta("image_service")); ?>" alt/>
				<?php } else {
					echo '<img src="http://placehold.it/1700x444&text=No+image" alt>';
				} ?>

				<div class="inside-box cf">
					<h2>
						<?php if(ale_get_meta("stats_service")) {
							echo esc_attr(ale_get_meta("stats_service"));
						} ?>
					</h2>

					<div class="item left">
						<i class="fa fa-car"></i>
						<span><?php echo esc_attr(ale_get_meta("service_cars_number")); ?></span>
						<span class="text"><?php echo esc_attr(ale_get_meta("service_cars_text")); ?></span>
					</div>

					<div class="item left">
						<i class="fa fa-users"></i>
						<span><?php echo esc_attr(ale_get_meta("service_customer_number")); ?></span>
						<span class="text"><?php echo esc_attr(ale_get_meta("service_customer_text")); ?></span>
					</div>

					<div class="item left">
						<i class="fa fa-heart"></i>
						<span><?php echo esc_attr(ale_get_meta("service_likes_number")); ?></span>
						<span class="text"><?php echo esc_attr(ale_get_meta("service_likes_text")); ?></span>
					</div>
				</div>
			</section>
		<?php } ?>

		<?php if(ale_get_meta('display_service_detail')!='off') { ?>
			<section class="wrapper-inside details">
				<h2>
					<?php if(ale_get_meta("title_service")) {
						echo esc_attr(ale_get_meta("title_service"));
					} ?>
				</h2>

				<div class="cf">
					<article class="left">
						<i class="fa fa-paper-plane-o red-col"></i>
						<?php if(ale_get_meta("title1_service")) { ?>
							<h3><?php echo esc_attr(ale_get_meta("title1_service")); ?></h3>
						<?php }
						if(ale_get_meta("description1_service")) { ?>
							<p class="content_service">
								<?php echo esc_attr(ale_get_meta("description1_service")); ?>
							</p>
						<?php } ?>
					</article>

					<article class="left">
						<i class="fa fa-search red-col"></i>
						<?php if(ale_get_meta("title2_service")) { ?>
							<h3><?php echo esc_attr(ale_get_meta("title2_service")); ?></h3>
						<?php }
						if(ale_get_meta("description2_service")) { ?>
							<p class="content_service">
								<?php echo esc_attr(ale_get_meta("description2_service")); ?>
							</p>
						<?php } ?>
					</article>

					<article class="left">
						<i class="fa fa-globe red-col"></i>
						<?php if(ale_get_meta("title3_service")) { ?>
							<h3><?php echo esc_attr(ale_get_meta("title3_service")); ?></h3>
						<?php }
						if(ale_get_meta("description3_service")) { ?>
							<p>
								<?php echo esc_attr(ale_get_meta("description3_service")); ?>
							</p>
						<?php } ?>
					</article>

					<article class="left">
						<i class="fa fa-map-marker red-col"></i>
						<?php if(ale_get_meta("title4_service")) { ?>
							<h3><?php echo esc_attr(ale_get_meta("title4_service")); ?></h3>
						<?php }
						if(ale_get_meta("description4_service")) { ?>
							<p>
								<?php echo esc_attr(ale_get_meta("description4_service")); ?>
							</p>
						<?php } ?>
					</article>

					<article class="left">
						<i class="fa fa-trash-o red-col"></i>
						<?php if(ale_get_meta("title5_service")) { ?>
							<h3><?php echo esc_attr(ale_get_meta("title5_service")); ?></h3>

						<?php }
						if (ale_get_meta("description5_service")) { ?>
							<p>
								<?php echo esc_attr(ale_get_meta("description5_service")); ?>
							</p>
						<?php } ?>
					</article>

					<article class="left">
						<i class="fa fa-camera red-col"></i>
						<?php if(ale_get_meta("title6_service")) { ?>
							<h3><?php echo esc_attr(ale_get_meta("title6_service")); ?></h3>
						<?php }
						if (ale_get_meta("description6_service")) { ?>
							<p class="content_service">
								<?php echo esc_attr(ale_get_meta("description6_service")); ?>
							</p>
						<?php } ?>
					</article>
				</div>
			</section>
		<?php } ?>

		<?php if(ale_get_meta('display_service_partners')!='off') { ?>
			<div class="wrapper home-partners white-dark-bg">
				<?php if(ale_get_option('partner1')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner1')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner1')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner2')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner2')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner2')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner3')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner3')); ?>">
						 <img src="<?php echo esc_url(ale_get_option('partner3')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner4')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner4')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner4')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner5')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner5')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner5')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner6')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner6')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner6')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner7')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner7')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner7')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner8')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner8')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner8')); ?>" alt>
					</a>
				<?php } ?>
			</div>
		<?php } ?>
	</div>
<?php get_footer(); ?>