<?php

/**
 * Template Name: Template Gallery 2
 */
get_header(); ?>
<div class="wrapper white-dark-bg cf">
	<div class="page-header">
		<div class="wrapper-inside cf">
			<span class="page-name left"><?php _e('Gallery', 'aletheme'); ?></span>

			<?php echo get_breadcrumbs(); ?>
		</div>
	</div>

	  <div class="wrapper-inside page-template-gallery-2">
		 <div class="isotope cf">
			<?php
			$i=0;
			if ( get_query_var('paged') ) $paged = get_query_var('paged');
			if ( get_query_var('page') ) $paged = get_query_var('page');
			$number = intval(ale_get_option('gallery_num_2'));
			$query_gallery = new WP_Query(
				array(
					'post_type' => 'gallery',
					'paged'=>$paged,
					'posts_per_page' => $number
				)
			);
			if( $query_gallery->have_posts() ): while( $query_gallery->have_posts() ) : $query_gallery->the_post();
				$i++;
				if($i == 1 || $i == 4 || $i == 5){
					$gallery_style = ' big';
				} else{
					$gallery_style = '';
				} ?>
				<article <?php post_class('item left' . $gallery_style); ?>>
					<?php if ($i == 1){
						if(get_the_post_thumbnail($post->ID,'gallery-big1')) {
						echo get_the_post_thumbnail($post->ID,'gallery-big1');
						} else {
						echo "<img src='http://placehold.it/606x554&amp;text=No+image' alt>";
						}
					} elseif ($i == 4 || $i == 5){
						if(get_the_post_thumbnail($post->ID,'gallery-big3')) {
							echo get_the_post_thumbnail($post->ID,'gallery-big3');
						} else {
							echo "<img src='http://placehold.it/606x277&amp;text=No+image' alt>";
						}
					} else {
						if(get_the_post_thumbnail($post->ID,'gallery-big2')) {
							echo get_the_post_thumbnail($post->ID,'gallery-big2');
						} else {
							echo "<img src='http://placehold.it/351x277&amp;text=No+image' alt>";
						}
					}?>

					<a href="<?php the_permalink(); ?>" class="overlay"></a>
					<div class="text">
						<h2>
							<a href="<?php the_permalink(); ?>" class="white-col red-col-hover"><?php the_title(); ?></a>
						</h2>

						<div class="string">
							<?php echo ale_trim_excerpt(8); ?>
						</div>
					</div>
				</article>
			<?php endwhile; endif; wp_reset_postdata(); ?>
		 </div>

		 <?php echo  ale_custom_page_links($query_gallery); ?>
	  </div>
</div>

<?php get_footer(); ?>
