
<?php
/**
 * Template Name: Template Contact
 */
// send contact
if (isset($_POST['contact'])) {
	$error = ale_send_contact($_POST['contact']);
}
get_header(); ?>
	<div class="wrapper white-dark-bg cf page-template-contact">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e('Contact', 'aletheme'); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>

		<div class="wrapper-inside">
			<?php if(ale_get_meta('display_contact_text')!='off') { ?>
				<div class="text-block">
					<h2 >
						<?php if(ale_get_meta("title_contact")){
							echo esc_attr(ale_get_meta("title_contact"));
						} ?>
					</h2>

					<div class="story">
						<?php if (have_posts()) : while (have_posts()) : the_post();
							the_content();
						endwhile; endif; ?>
					</div>
				</div>
			<?php } ?>

			<?php if(ale_get_meta('display_contact_form')!='off') { ?>
				<div class="cf">
					<div class="contact-form left">
						<?php if (isset($_GET['success'])) : ?>
							<p class="success"><?php _e('Thank you for your message!', 'aletheme')?></p>
						<?php endif; ?>
						<?php if (isset($error) && isset($error['msg'])) : ?>
							<p class="error"><?php echo esc_attr($error['msg']); ?></p>
						<?php endif; ?>
						<form method="post">
								<input class="left" name="contact[name]" type="text" placeholder="Name" value="<?php echo isset($_POST['contact']['name']) ? $_POST['contact']['name'] : ''?>" required="required" id="contact-form-name" />
								<input class="left" name="contact[email]" type="email" placeholder="E-mail" value="<?php echo isset($_POST['contact']['email']) ? $_POST['contact']['email'] : ''?>" required="required" id="contact-form-email" />
								<textarea name="contact[message]" id="contact-form-message" required="required"><?php echo isset($_POST['contact']['message']) ? $_POST['contact']['message'] : ''?></textarea>
								<div class="submit grey-submit-light-bg red-bg-hover clear">
									<i class="fa fa-check f_reserv"></i>
									<input type="submit" value="<?php _e('Send message', 'aletheme'); ?>"/>
								</div>
							<?php wp_nonce_field() ?>
						</form>
					</div>

					<div class="contact-data left">
						<p class="phone">
							<i class="fa fa-phone red-col"></i>
							<?php if(ale_get_meta("telephone_contact")) {
								$fields=esc_attr(ale_get_meta("telephone_contact"));
								$text=str_split($fields);
								$i=0;
								foreach($text as $item) {
									$i=$i+1;
									if($i<=6) {
										echo esc_attr($item);
									}
									else {
										echo "<span class='span_contacts'>".esc_attr($item)."</span>";
									}
								}
							} ?>
						</p>

						<p class="email">
							<i class="fa fa-at red-col"></i>
							<?php if(ale_get_meta("email_contact")) {
								echo esc_attr(ale_get_meta("email_contact"));
							}?>
						</p>

						<p class="address">
							<i class="fa fa-map-marker red-col"></i>
							<?php if(ale_get_meta("address_contact")) {
								$fields = esc_attr(ale_get_meta("address_contact"));
								$text = explode(' ',$fields);
								$count = 0;
								foreach($text as $address) {
									$count++;
									if($count == 1){
										echo '<span>' . esc_attr($address).'</span> ';
									} else {
										echo esc_attr($address).' ';
									}
								}
							} ?>
						</p>
					</div>
				</div>
			<?php } ?>
		</div>

		<?php if(ale_get_meta('display_contact_maps')!='off') { ?>
			<div class="map">
				<?php $adre = esc_attr(ale_get_meta("address_contact")); echo do_shortcode('[ale_map address="'.$adre.'" width="100%" height="400px"]'); ?>
				<div class="shadow"></div>
			</div>
		<?php } ?>
	</div>
<?php get_footer(); ?>