<?php
/**
 * Template Name: Template Blog 2
 */
get_header(); ?>
	<div class="wrapper white-dark-bg cf">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e("Blog","aletheme"); ?></span>

				<div class="breadcrumbs right">
					<i class="fa fa-home red-col"></i>
						<span typeof="v:Breadcrumb">
							<a rel="v:url" property="v:title" href="<?php echo home_url(); ?>"><?php _e('Home', 'aletheme'); ?></a>
						</span>&nbsp; › &nbsp;
					<span class="current"><?php _e('Blog', 'aletheme'); ?></span>
				</div>
			</div>
		</div>

		<div class="wrapper-inside typical-page page-template-blog-2">
			<div class="category-list">
				<?php $args = array(
					'show_option_all'    => '',
					'orderby'            => 'name',
					'order'              => 'ASC',
					'style'              => 'list',
					'show_count'         => 0,
					'hide_empty'         => 1,
					'use_desc_for_title' => 1,
					'child_of'           => 0,
					'feed'               => '',
					'feed_type'          => '',
					'feed_image'         => '',
					'exclude'            => '',
					'exclude_tree'       => '',
					'include'            => '',
					'hierarchical'       => 0,
					'title_li'           => '',
					'show_option_none'   => __( 'No categories','aletheme' ),
					'number'             => null,
					'echo'               => 1,
					'depth'              => 0,
					'current_category'   => 0,
					'pad_counts'         => 0,
					'taxonomy'           => 'category',
					'walker'             => null
				); ?>
				<ul class="cf">
					<?php wp_list_categories('title_li='); ?>
				</ul>
			</div>

			<div class="content_box left">
				<?php
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count = intval(ale_get_option('blog_1'));
				$query_blog = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'post',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				if ($query_blog->have_posts()) : while ($query_blog->have_posts()) : $query_blog->the_post(); ?>
					<article <?php post_class('item cf'); ?>>
						<div class="image left">
							<a href="<?php the_permalink(); ?>">
								<?php if( get_the_post_thumbnail($post->ID,'post-blog_2')) {
									echo get_the_post_thumbnail($post->ID,'post-blog_2');
								} else {
									echo '<img class="non_image" src="http://placehold.it/280x242&amp;text=No+image" alt/>';
								} ?>
							</a>
						</div>

						<div class="text left">
							<div class="details">
								<span class="author-name"><?php $author = get_the_author(); echo esc_attr($author); ?></span> /
								<span class="date"><?php the_time('j F Y'); ?></span>
							</div>

							<h2><a href="<?php the_permalink(); ?>" class="black-col red-col-hover"><?php echo get_the_title(); ?></a></h2>

							<div class="string clear">
								<?php echo ale_trim_excerpt(22); ?>
							</div>
						</div>
						<a href="<?php the_permalink(); ?>" class="link"><i class="fa fa-angle-right"></i></a>
					</article>
				<?php endwhile; endif; wp_reset_postdata(); ?>

				<?php echo ale_custom_page_links($query_blog); ?>
			</div>

			<?php get_sidebar(); ?>
		</div>
	</div>
<?php get_footer(); ?>
