<?php
/**
 * Template Name: Template About
 */
get_header(); ?>

	<div class="wrapper white-dark-bg cf page-template-about">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e('About', 'aletheme'); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>

		<?php if(ale_get_meta('display_about_text')!='off') { ?>
			<div class="text-block">
				<div class="wrapper-inside story">
					<?php if (have_posts()) : while (have_posts()) : the_post();
						the_content();
					endwhile; endif; ?>
				</div>
			</div>
		<?php } ?>

		<?php if(ale_get_meta('display_about_information')!='off') { ?>
			<div class="information">
				<div class="wrapper-inside cf">
					<article class="red-bg white-col left">
						<i class="fa fa-gear"></i>
						<h2>
							<?php if(ale_get_meta("title_circle1_about")) {
								echo esc_attr(ale_get_meta("title_circle1_about"));
							} ?>
						</h2>

						<p>
							<?php if(ale_get_meta("text_circle1_about")) {
								echo esc_attr(ale_get_meta("text_circle1_about"));
							} ?>
						</p>
					</article>

					<article class="red-bg white-col left big">
						<i class="fa fa-bell"></i>
						<h2>
							<?php if(ale_get_meta("title_circle2_about")) {
								echo esc_attr(ale_get_meta("title_circle2_about"));
							} ?>
						</h2>

						<p>
							<?php if(ale_get_meta("text_circle2_about")) {
								echo esc_attr(ale_get_meta("text_circle2_about"));
							} ?>
						</p>
					</article>

					<article class="red-bg white-col left">
						<i class="fa fa-bullseye"></i>
						<h2>
							<?php if(ale_get_meta("title_circle3_about")) {
								echo esc_attr(ale_get_meta("title_circle3_about"));
							} ?>
						</h2>

						<p>
							<?php if(ale_get_meta("text_circle3_about")) {
								echo esc_attr(ale_get_meta("text_circle3_about"));
							} ?>
						</p>
					</article>
				</div>
			</div>
		<?php } ?>

		<?php if(ale_get_meta('display_about_video')!='off') { ?>
			<section class="wrapper-inside video">
				<h2>
					<?php if(ale_get_meta("title_center_about")) {
						echo esc_attr(ale_get_meta("title_center_about"));
					} ?>
				</h2>

				<h3>
					<?php if(ale_get_meta("title_passages_about"))  {
					echo esc_attr(ale_get_meta("title_passages_about"));
					} ?>
				</h3>

				<p>
					<?php echo ale_get_meta_attr('text_about'); ?>
				</p>

				<div class="image">
					<?php if(ale_get_meta("about_image")) { ?>
						<img src="<?php echo esc_url(ale_get_meta("about_image")); ?>" alt>
					<?php } else {
						echo "<img src='http://placehold.it/716x352&amp;text=No+image' alt>";
					} ?>
					<div class="overlay">
						<i class="fa fa-play red-bg white-col"></i>
					</div>
				</div>

				<div class="pop-up">
					<div class="exit">
						<i class="fa fa-times"></i>
					</div>

					<div class="content-wrapper">
						<div class="item">
							<?php if(ale_get_meta("about_video")) {
								echo wp_oembed_get(ale_get_meta('about_video'),array('width'=>'700px','height'=>'500px'));
							}
							else {
								echo "<img src='http://placehold.it/716x351&amp;text=No%20video' alt>";
							} ?>
						</div>
					</div>
				</div>
			</section>
		<?php } ?>

		<?php if(ale_get_meta('display_about_partners')!='off'){ ?>
			<div class="wrapper home-partners white-dark-bg">
				<?php if(ale_get_option('partner1')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner1')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner1')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner2')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner2')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner2')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner3')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner3')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner3')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner4')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner4')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner4')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner5')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner5')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner5')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner6')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner6')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner6')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner7')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner7')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner7')); ?>" alt>
					</a>
				<?php } ?>

				<?php if(ale_get_option('partner8')){ ?>
					<a href="<?php echo esc_url(ale_get_option('link_partner8')); ?>">
						<img src="<?php echo esc_url(ale_get_option('partner8')); ?>" alt>
					</a>
				<?php } ?>
			</div>
		<?php } ?>
	</div>
<?php get_footer(); ?>