<?php
add_action('wp_head','ajaxurl');
function ajaxurl() {
	?>
	<script type="text/javascript">
		var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
	</script>
<?php
}
get_header(); ?>
	<div class="wrapper cf white-dark-bg">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e("Listing","aletheme"); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>


		<div class="wrapper-inside single-listing-page">
			<div class="image-box left">
				<div class="slider">
					<ul class="slides">
						<?php $args = array(
							'post_type' => 'attachment',
							'post_status' => null,
							'post_parent' => $post->ID
						);
						$attachments = get_posts( $args );
						if ( $attachments ) {
							foreach ( $attachments as $attachment ) { ?>
								<li>
									<?php echo wp_get_attachment_image( $attachment->ID, 'listing-image' ); ?>
								</li>
							<?php }
						} else { ?>
							<li>
								<?php echo "<img src='http://placehold.it/500x380&text=No%20image' alt>"; ?>
							</li>
						<?php } ?>
					</ul>
				</div>

				<div class="slider-nav" >
					<ul class="slides">
						<?php $args = array(
							'post_type' => 'attachment',
							'post_status' => null,
							'post_parent' => $post->ID
						);
						$attachments = get_posts( $args );
						if ( $attachments ) {
							foreach ( $attachments as $attachment ) { ?>
								<li>
									<?php echo wp_get_attachment_image( $attachment->ID, 'listing-gallery' ); ?>
								</li>
							<?php }
						} ?>
					</ul>
				</div>
			</div>

			<div class="details left">
				<h2>
					<?php $current_category = wp_get_post_terms($post->ID, 'brand-listing', array("fields" => "all"));
					if($current_category){
						foreach($current_category as $curcat){
							echo '<span>' . $curcat->name . '</span> ';
						}
					}
					the_title(); ?>
				</h2>

				<div class="price">
					<?php echo _e('Price: ','aletheme'); ?>
					<span class="red-col">
						<?php if(ale_get_meta("pret_car")) {
						   echo ale_get_option('curency') . esc_attr(ale_get_meta("pret_car"));
						} ?>
					</span>
				</div>

				<div class="car-details">
					<ul class="cf">
						<?php
						$newdata=array();
						$all_properties=ale_get_meta("main");
						$count=count($all_properties);
						$i=0;
						if($all_properties) {
							foreach($all_properties as $properties) {
								$i++;
								if($i<=8) {
									?>
									<li class="left">
										<?php
										echo esc_attr($properties['title']).':'; ?>
										<span><?php echo esc_attr($properties['value']); ?></span>
								   </li>
								<?php
								}
								else {
									$newdata[]= array(
										'title' => $properties['title'],
										'value' => $properties['value']
									);
								}
							}
						}
						?>
					</ul>
				</div>

				<div class="share">
					<h3 class="red-col">
						<?php echo _e('Social Shares:','aletheme'); ?>
					</h3>

					<ul>
						<li class="twiter" ><a href="<?php echo ale_get_share('twi'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-twitter"></i></a></li>
						<li class="goglp"><a href="<?php echo ale_get_share('fb'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-google-plus"></i></a></li>
						<li class="facebook"><a href="<?php echo ale_get_share('fb'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-facebook"></i></a></li>
						<li class="pinterest"><a href="<?php echo ale_get_share('pin'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-pinterest-p"></i></a></li>
					</ul>
				</div>
			</div>

			<section class="additional-info clear">
				<h3><?php echo _e('Additional Info','aletheme');?></h3>
				<div class="string">
					<?php if (have_posts()) : while (have_posts()) : the_post();
						the_content();
					endwhile; endif; ?>
				</div>
			</section>

			<div class="information">
				<div class="tabs">
					<ul class="cf">
						<?php if(ale_get_meta('interior_m')){ ?>
							<li class="left">
								<a href="#tabs-1"><?php echo _e('Interior','aletheme'); ?></a>
							</li>
						<?php } ?>

						<?php if(ale_get_meta('engines')){ ?>
							<li class="left">
								<a href="#tabs-2"><?php echo _e('Engine','aletheme'); ?></a>
							</li>
						<?php } ?>

						<?php if(ale_get_meta('equipment_m')){ ?>
							<li class="left">
								<a href="#tabs-3"><?php echo _e('Equipment','aletheme'); ?></a>
							</li>
						<?php } ?>
					</ul>

					<?php if(ale_get_meta('interior_m')): ?>
						<div id="tabs-1" class="item clear">
							<ul class="cf">
								<?php $details = ale_get_meta("interior_m");
								if($details) {
									foreach($details as $detail) { ?>
										<li class="left">
											<?php echo esc_attr($detail['title']); ?>
											<span><?php echo esc_attr($detail['value']); ?></span>
										</li>
									<?php }
								} ?>
							</ul>
						</div>
					<?php endif; ?>

					<?php if(ale_get_meta('engines')): ?>
						<div id="tabs-2" class="item clear">
							<ul class="cf">
								<?php $details = ale_get_meta("engines");
								if($details) {
									foreach($details as $detail) { ?>
										<li class="left">
											<?php echo esc_attr($detail['title']); ?>
											<span><?php echo esc_attr($detail['value']); ?></span>
										</li>
								<?php }
								} ?>
							</ul>
						</div>
					<?php endif; ?>

					<?php if(ale_get_meta('equipment_m')): ?>
						<div id="tabs-3" class="item clear">
							<ul class="cf">
								<?php $details = ale_get_meta("equipment_m");
								if($details) {
									foreach($details as $detail) { ?>
										<li class="left">
											<?php echo esc_attr($detail['title']); ?>
											<span><?php echo esc_attr($detail['value']); ?></span>
										</li>
									<?php }
								} ?>
							</ul>
						</div>
					<?php endif; ?>
				</div>
			</div>

			<?php
			$current_category = wp_get_post_terms($post->ID, 'brand-listing', array("fields" => "all"));
			foreach($current_category as $curcat){
				$cat_name = $curcat->name.' ';
			}
			?>
			<?php wp_reset_postdata();
			if(!$cat_name){
				$cat_name = '';
			}
			$args = array(
				'posts_per_page' => 4,
				'post_type' => 'listing',
				'tax_query' => array(
					array(
						'taxonomy' => 'brand-listing',
						'field' => 'slug',
						'terms' => $cat_name
					)
				)
			);
			$query_listing = new WP_Query($args);
			if( $query_listing->have_posts() ): ?>
				<section class="similar-cars">
					<h2><?php echo _e('Similar car','aletheme'); ?></h2>

					<div class="isotope cf">
						<?php while( $query_listing->have_posts() ) : $query_listing->the_post(); ?>
							<article <?php post_class('item left'); ?>>
								<?php if(get_the_post_thumbnail($post->ID,'listing-min')) {
									echo get_the_post_thumbnail($post->ID,'listing-min');
								} else {
									echo '<img class="non_image" src="http://placehold.it/245x255" alt>';
								} ?>

								<div class="text cf">
									<h2>
										<?php $current_category = wp_get_post_terms($post->ID, 'brand-listing', array("fields" => "all"));
										if($current_category){
											foreach($current_category as $curcat){
												echo '<span>' . $curcat->name . '</span> ';
											}
										}
										the_title(); ?>
									</h2>

									<div class="details">
										<?php $current_category = wp_get_post_terms($post->ID, 'fuel-listing', array("fields" => "all"));
										if($current_category){
											echo '<p class="cf"><span class="caption left">' . __('Fuel','aletheme') . '</span>';
											foreach($current_category as $curcat){
												echo '<span class="right">' . $curcat->name . '</span>';
											}
											echo '</p>';
										}?>

										<?php $current_category = wp_get_post_terms($post->ID, 'year-listing', array("fields" => "all"));
										if($current_category){
											echo '<p class="cf"><span class="caption left">' . __('Year','aletheme') . '</span>';
											foreach($current_category as $curcat){
												echo '<span class="right">' . $curcat->name . '</span>';
											}
											echo '</p>';
										}?>

										<?php $current_category = wp_get_post_terms($post->ID, 'transmission-listing', array("fields" => "all"));
										if($current_category){
											echo '<p class="cf"><span class="caption left">' . __('Transmission','aletheme') . '</span>';
											foreach($current_category as $curcat){
												echo '<span class="right">' . $curcat->name . '</span>';
											}
											echo '</p>';
										}?>

										<?php if(ale_get_meta("location_car")){ ?>
											<p class="cf"><span class="caption left"><?php echo _e('Location','aletheme'); ?></span><span class="right"><?php echo esc_attr(ale_get_meta("location_car")); ?></span></p>
										<?php } ?>
									</div>

									<div class="information">
										<?php if(ale_get_meta('brakes_car')){ ?>
											<i class="fa fa-dot-circle-o grey-col"></i>
										<?php } ?>

										<?php if(ale_get_meta('transmission_icon_car')){ ?>
											<i class="fa fa-gavel grey-col"></i>
										<?php } ?>

										<?php if(ale_get_meta('oil_car')){ ?>
											<i class="fa fa-flask grey-col"></i>
										<?php } ?>

										<?php if(ale_get_meta('repair_car')){ ?>
											<i class="fa fa-wrench grey-col"></i>
										<?php } ?>
									</div>
								</div>

								<a href="<?php echo  the_permalink(); ?>"></a>
							</article>
						<?php endwhile; ?>
					</div>
				</section>
			<?php endif; wp_reset_postdata(); ?>

			<div class="wrapper-inside white-dark-bg comments-block">
				<?php comments_template(); ?>
			</div>
		</div>
	</div>
<?php
get_footer();
?>