<?php get_header(); ?>
	<div class="wrapper cf white-dark-bg">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e("Author","aletheme"); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>

		<div class="single-post-page">
			<?php $args = array(
				'post_type' => 'attachment',
				'numberposts' => -1,
				'post_status' => null,
				'order'    => 'ASC',
				'orderby'   => 'menu_order ID',
				'meta_query'  => array(
					array(
						'key'  => '_ale_hide_from_gallery',
						'value'  => 0,
						'type'  => 'DECIMAL',
					),
				),
				'post_parent' => $post->ID
			);
			$attachments = get_posts( $args );
			if ( $attachments ) { ?>
				<div class="post-slider">
					<ul class="slides">
						<?php foreach ( $attachments as $attachment ) { ?>
							<li>
								<?php if(wp_get_attachment_image( $attachment->ID, 'post-big' )){
									echo wp_get_attachment_image( $attachment->ID, 'post-big' );
								} ?>
							</li>
						<?php } ?>
					</ul>
				</div>
			<?php } else{ ?>
				<div class="post-image">
					<?php if(get_the_post_thumbnail($post->ID,'post-big')) {
						echo get_the_post_thumbnail($post->ID,'post-big');
					} else {
						echo '<img src="http://placehold.it/1920x510&amp;text=No+image" alt>';
					} ?>
				</div>
			<?php } ?>

			<div class="wrapper-inside white-dark-bg">
				<article>
					<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
						<h2><?php the_title(); ?></h2>
						<span class="author red-col"><?php the_author(); ?></span>
						<span class="date"><?php the_time('F j, Y'); ?></span>

						<div class="story">
							<?php the_content(); ?>
						</div>

						<?php if(ale_get_meta("blog_video_link")) { ?>
							<div class="image">
								<?php if(ale_get_meta("post_image")) { ?>
									<img src="<?php echo esc_url(ale_get_meta("post_image")); ?>" alt>
								<?php } else {
									echo "<img src='http://placehold.it/960x370&amp;text=No+image' alt>";
								} ?>
								<div class="overlay">
									<i class="fa fa-play red-bg white-col"></i>
								</div>
							</div>

							<div class="pop-up">
								<div class="exit">
									<i class="fa fa-times"></i>
								</div>

								<div class="content-wrapper">
									<div class="item">
										<?php echo wp_oembed_get(ale_get_meta_url('blog_video_link'),array('width'=>'100%','height'=>'500px')); ?>
									</div>
								</div>
							</div>
						<?php } ?>
					<?php endwhile; endif; ?>
				</article>
			</div>


			<section class="wrapper-inside white-dark-bg comments-block">
				<h2><?php _e('Comments', 'aletheme'); ?><i class="fa fa-comment comm"></i></h2>
				<?php comments_template(); ?>
			</section>
		</div>
	</div>
<?php get_footer(); ?>