<?php
get_header();
?>
<div class="wrapper white-dark-bg">
	<div class="page-header">
		<div class="wrapper-inside cf">
			<span class="page-name left"><?php _e('Our team', 'aletheme'); ?></span>

			<?php echo get_breadcrumbs(); ?>
		</div>
	</div>

	<div class="wrapper-inside our-team-archive-page">
		<?php
		$args = array(
			'type'                     => 'our-team',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'name',
			'order'                    => 'ASC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'team-category',
			'pad_counts'               => false
			);

		$categories = get_categories( $args );
		foreach($categories as $cat): ?>
			<section>
				<h2><?php echo esc_attr($cat->name); ?></h2>

				<div class="isotope-gutter">
					<div class="gutter"></div>
					<?php $args = array(
						'post_type' => 'our-team',
						'posts_per_page' => -1,
						'tax_query' => array(
							array(
								'taxonomy' => 'team-category',
								'field' => 'slug',
								'terms' => $cat->slug
							)
						)
					);
					$query = new WP_Query($args);$slug = $cat->slug; ?>
					<?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
						<article class="item">
							<a href="<?php the_permalink(); ?>" class="image">
								<?php if(get_the_post_thumbnail($post->ID,'our-team-management')) {
									echo get_the_post_thumbnail($post->ID,'our-team-management');
								}
								else {
									echo "<img class='non_image' src='http://placehold.it/308x253&amp;text=No+image' alt>";
								} ?>
							</a>

							<div class="text">
								<h3><a href="<?php the_permalink(); ?>" class="black-col red-col-hover"><?php the_title(); ?></a></h3>
								<span class="team-post"><?php echo esc_attr(ale_get_meta("workstation")); ?></span>
								<div class="string">
									<?php echo ale_trim_excerpt(18); ?>
								</div>

								<?php if(ale_get_meta("number-team")) { ?>
									<p class="phone">
										<i class="fa fa-phone-square"></i>
										<?php echo esc_attr( ale_get_meta("number-team")); ?>
									</p>
								<?php } ?>

								<?php if(ale_get_meta("email-team")) { ?>
									<p class="email">
										<i class="fa fa-envelope"></i>
										<?php echo esc_attr(ale_get_meta("email-team")); ?>
									</p>
								<?php } ?>

								<div class="social">
									<ul class="share">
										<li class="twiter" ><a href="<?php echo ale_get_share('twi'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-twitter"></i></a></li>
										<li class="goglp"><a href="<?php echo ale_get_share('fb'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-google-plus"></i></a></li>
										<li class="facebook"><a href="<?php echo ale_get_share('fb'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-facebook"></i></a></li>
										<li class="pinterest"><a href="<?php echo ale_get_share('pin'); ?>" class="grey-bg red-bg-hover" rel="external"><i class="fa fa-pinterest-p"></i></a></li>
									</ul>
								</div>
							</div>
						</article>
					<?php endwhile;  endif; wp_reset_postdata();?>
				</div>
			</section>
		<?php endforeach; ?>

		<section>
			<h2><?php echo _e('Find a car','aletheme'); ?></h2>

			<div class="form-car cf">
				<form method="POST" action="<?php echo home_url(); ?>/special-offers">
					<select class="dropdown" name="min_year">
						<option selected disabled><?php echo _e('Min Year','aletheme'); ?></option>
						<?php
						$years=get_terms("year-offers");
						foreach($years as $year) {
							?>
							<option value="<?php echo esc_attr($year->name); ?>"><?php echo esc_attr($year->name); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="max_year">
						<option selected disabled><?php echo _e('Max Year','aletheme'); ?></option>
						<?php
						$years=get_terms("year-offers");
						foreach($years as $year) {
							?>
							<option value="<?php echo esc_attr($year->name); ?>"><?php echo esc_attr($year->name); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="body-style">
						<option selected disabled><?php echo _e('Body Style','aletheme'); ?></option>
						<?php
						$bodys=get_terms("body-offers");
						foreach($bodys as $body) {
							?>
							<option value="<?php echo esc_attr($body->term_id); ?>"><?php echo esc_attr($body->name); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="brand">
						<option selected disabled><?php echo _e('Choose Brand','aletheme'); ?></option>
						<?php
						$brands=get_terms("brand-offers");
						foreach($brands as $brand) {
							?>
							<option value="<?php echo esc_attr($brand->term_id); ?>"><?php echo esc_attr($brand->name); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="min_mileage">
						<option selected disabled><?php echo _e('Min Mileage','aletheme'); ?></option>
						<?php

						for($j=1;$j<=20;$j++) {
							$suma=$j*10000;
							?>
							<option value="<?php echo esc_attr($suma); ?>"><?php echo esc_attr($suma); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="max_mileage">
						<option selected disabled><?php echo _e('Max Mileage','aletheme'); ?></option>
						<?php
						for($j=1;$j<=20;$j++) {
							$suma=$j*10000;
							?>
							<option value="<?php echo esc_attr($suma); ?>"><?php echo esc_attr($suma); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="min_price">
						<option selected disabled><?php echo _e('Min Price','aletheme');  ?></option>
						<?php
						for($j=1;$j<=12;$j++) {
							$suma=$j*5000;
							?>
							<option value="<?php echo esc_attr($suma); ?>"><?php echo esc_attr($suma); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="max_price">
						<option selected disabled><?php echo _e('Max Price','aletheme'); ?></option>
						<?php
						for($j=1;$j<=12;$j++) {
							$suma=$j*5000;
							?>
							<option value="<?php echo esc_attr($suma); ?>"><?php echo esc_attr($suma); ?></option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" name="transmission">
						<option selected disabled><?php echo _e('Transmission','aletheme'); ?></option>
						<?php
						$transmissions=get_terms("transmission_car");
						foreach($transmissions as $transmission) {
							?>
							<option value="<?php echo esc_attr($transmission->term_id); ?>"><?php echo esc_attr($transmission->name); ?></option>
						<?php
						}
						?>
					</select>

					<div class="submit right grey-submit-light-bg red-bg-hover">
						<input class="clearfix" id="find-car" type="submit" name="submit" value="<?php echo _e('Find my new car','aletheme'); ?>"/>
						<i class="fa fa-check"></i>
					</div>
				</form>
			</div>
		</section>

		<section>
			<h2><?php echo _e('Popular car','aletheme'); ?></h2>

			<div class="archive-page-listing isotope">
				<?php wp_reset_postdata();
				$args_pop = array(
					'post_type' => 'listing',
					'posts_per_page' => 4,
					'orderby' => 'comment_count'
				);
				$pop_listing = new WP_Query( $args_pop );
				if ($pop_listing->have_posts()) : while ($pop_listing->have_posts()) : $pop_listing->the_post(); ?>
					<article <?php post_class('item left'); ?>>
						<?php if(get_the_post_thumbnail($post->ID,'listing-min')) {
							echo get_the_post_thumbnail($post->ID,'listing-min');
						} else {
							echo '<img class="non_image" src="http://placehold.it/245x255" alt>';
						} ?>

						<div class="text cf">
							<h2>
								<?php $current_category = wp_get_post_terms($post->ID, 'brand-listing', array("fields" => "all"));
								if($current_category){
									foreach($current_category as $curcat){
										echo '<span>' . $curcat->name . '</span> ';
									}
								}
								the_title(); ?>
							</h2>

							<div class="details">
								<?php $current_category = wp_get_post_terms($post->ID, 'fuel-listing', array("fields" => "all"));
								if($current_category){
									echo '<p class="cf"><span class="caption left">' . __('Fuel','aletheme') . '</span>';
									foreach($current_category as $curcat){
										echo '<span class="right">' . $curcat->name . '</span>';
									}
									echo '</p>';
								}?>

								<?php $current_category = wp_get_post_terms($post->ID, 'year-listing', array("fields" => "all"));
								if($current_category){
									echo '<p class="cf"><span class="caption left">' . __('Year','aletheme') . '</span>';
									foreach($current_category as $curcat){
										echo '<span class="right">' . $curcat->name . '</span>';
									}
									echo '</p>';
								}?>

								<?php $current_category = wp_get_post_terms($post->ID, 'transmission-listing', array("fields" => "all"));
								if($current_category){
									echo '<p class="cf"><span class="caption left">' . __('Transmission','aletheme') . '</span>';
									foreach($current_category as $curcat){
										echo '<span class="right">' . $curcat->name . '</span>';
									}
									echo '</p>';
								}?>

								<?php if(ale_get_meta("location_car")){ ?>
									<p class="cf"><span class="caption left"><?php echo _e('Location','aletheme'); ?></span><span class="right"><?php echo esc_attr(ale_get_meta("location_car")); ?></span></p>
								<?php } ?>
							</div>

							<div class="information<?php if($listing_count == 2){echo' left';} ?>">
								<?php if(ale_get_meta('brakes_car')){ ?>
									<i class="fa fa-dot-circle-o grey-col"></i>
								<?php } ?>

								<?php if(ale_get_meta('transmission_icon_car')){ ?>
									<i class="fa fa-gavel grey-col"></i>
								<?php } ?>

								<?php if(ale_get_meta('oil_car')){ ?>
									<i class="fa fa-flask grey-col"></i>
								<?php } ?>

								<?php if(ale_get_meta('repair_car')){ ?>
									<i class="fa fa-wrench grey-col"></i>
								<?php } ?>
							</div>
						</div>

						<a href="<?php echo  the_permalink(); ?>"></a>
					</article>
				<?php endwhile; endif; wp_reset_postdata(); ?>
			</div>
		</section>
	</div>
</div>
<?php get_footer(); ?>