<?php add_action('admin_init', 'add_meta_boxes3', 1);
function add_meta_boxes3() {
    add_meta_box( 'ale_equipment_m', 'Additional equipment Details', 'ale_equipment_m_box_display', 'listing', 'normal', 'high');
}

function ale_equipment_m_box_display() {
    global $post;

    $ale_properties_details3 = get_post_meta($post->ID, 'ale_equipment_m', true);



    wp_nonce_field( 'ale_equipment_m_box_nonce', 'ale_equipment_m_box_nonce' );
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('.metabox_submit3').click(function(e) {
                e.preventDefault();
                $('#publish').click();
            });
            $('#add-row3').on('click', function() {
                var row = $('.empty-row3.screen-reader-text').clone(true);
                row.removeClass('empty-row3 screen-reader-text');
                row.insertBefore('#repeatable-fieldset-one3 tbody>tr:last');
                return false;
            });
            $('.remove-row3').on('click', function() {
                $(this).parents('tr').remove();
                return false;
            });

            $('#repeatable-fieldset-one3 tbody').sortable({
                opacity: 0.6,
                revert: true,
                cursor: 'move',
                handle: '.sort'
            });
        });
    </script>

    <table id="repeatable-fieldset-one3" width="100%">
        <thead>
        <tr>
            <th width="2%"></th>
            <th width="30%">Title</th>
            <th width="60%">Value</th>
            <th width="2%"></th>
        </tr>
        </thead>
        <tbody>
        <?php

        if ( $ale_properties_details3) :

            foreach ( $ale_properties_details3 as $field ) {
                ?>
                <tr>
                    <td><a class="button remove-row3" href="#"><span class="dashicons dashicons-trash"></span></a></td>
                    <td><input type="text" class="widefat" name="title3[]" value="<?php if($field['title'] != '') echo esc_attr( $field['title'] ); ?>" /></td>

                    <td><input type="text" class="widefat" name="value3[]" value="<?php if ($field['value'] != '') echo esc_attr( $field['value'] );  ?>" /></td>
                    <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

                </tr>
            <?php
            }
        else :
            // show a blank one
            ?>
            <tr>
                <td><a class="button remove-row3" href="#"><span class="dashicons dashicons-trash"></span></a></td>
                <td><input type="text" class="widefat" name="title3[]" /></td>


                <td><input type="text" class="widefat" name="value3[]" value="" /></td>
                <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

            </tr>

        <?php endif; ?>

        <!-- empty hidden one for jQuery -->
        <tr class="empty-row3 screen-reader-text">
            <td><a class="button remove-row3" href="#"><span class="dashicons dashicons-trash"></span></a></td>
            <td><input type="text" class="widefat" name="title3[]" /></td>


            <td><input type="text" class="widefat" name="value3[]" value="" /></td>
            <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

        </tr>
        </tbody>
    </table>



    <p><a id="add-row3" class="button" href="#"><span class="dashicons dashicons-plus" style="line-height: 28px; font-size:14px;"></span> Add another</a>
        <input type="submit" class="metabox_submit3" value="Save" />
    </p>

<?php
}

add_action('save_post', 'ale_equipment_m_box_save');
function ale_equipment_m_box_save($post_id) {
    if ( ! isset( $_POST['ale_equipment_m_box_nonce'] ) ||
        ! wp_verify_nonce( $_POST['ale_equipment_m_box_nonce'], 'ale_equipment_m_box_nonce' ) )

        return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;

    if (!current_user_can('edit_post', $post_id))
        return;

    $old = get_post_meta($post_id, 'ale_equipment_m', true);
    $new = array();


    $titles = $_POST['title3'];
    $values = $_POST['value3'];

    $count = count( $titles );

    for ( $i = 0; $i < $count; $i++ ) {
        if ( $titles[$i] != '' ) :
            $new[$i]['title'] = stripslashes( strip_tags( $titles[$i] ) );
            $new[$i]['value'] = stripslashes( $values[$i] );
        endif;
    }

    if ( !empty( $new ) && $new != $old )
        update_post_meta( $post_id, 'ale_equipment_m', $new );
    elseif ( empty($new) && $old )
        delete_post_meta( $post_id, 'ale_equipment_m', $old );
}

