<?php add_action('admin_init', 'add_meta_boxes', 1);
function add_meta_boxes() {
    add_meta_box( 'ale_main', 'Main car Details', 'ale_main_box_display', 'listing', 'normal', 'high');
}

function ale_main_box_display() {
    global $post;
    $ale_properties_details = get_post_meta($post->ID, 'ale_main', true);

    wp_nonce_field( 'ale_main_box_nonce', 'ale_main_box_nonce' );
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('.metabox_submit').click(function(e) {
                e.preventDefault();
                $('#publish').click();
            });
            $('#add-row').on('click', function() {
                var row = $('.empty-row.screen-reader-text').clone(true);
                row.removeClass('empty-row screen-reader-text');
                row.insertBefore('#repeatable-fieldset-one tbody>tr:last');
                return false;
            });
            $('.remove-row').on('click', function() {
                $(this).parents('tr').remove();
                return false;
            });

            $('#repeatable-fieldset-one tbody').sortable({
                opacity: 0.6,
                revert: true,
                cursor: 'move',
                handle: '.sort'
            });
        });
    </script>

    <table id="repeatable-fieldset-one" width="100%">
        <thead>
        <tr>
            <th width="2%"></th>
            <th width="30%">Title</th>
            <th width="60%">Value</th>
            <th width="2%"></th>
        </tr>
        </thead>
        <tbody>
        <?php
        if ( $ale_properties_details ) :

            foreach ( $ale_properties_details as $field ) {
                ?>
                <tr>
                    <td><a class="button remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
                    <td><input type="text" class="widefat" name="title[]" value="<?php if($field['title'] != '') echo esc_attr( $field['title'] ); ?>" /></td>

                    <td><input type="text" class="widefat" name="value[]" value="<?php if ($field['value'] != '') echo esc_attr( $field['value'] );  ?>" /></td>
                    <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

                </tr>
            <?php
            }
        else :
            // show a blank one
            ?>
            <tr>
                <td><a class="button remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
                <td><input type="text" class="widefat" name="title[]" /></td>


                <td><input type="text" class="widefat" name="value[]" value="" /></td>
                <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

            </tr>
        <?php endif; ?>

        <!-- empty hidden one for jQuery -->
        <tr class="empty-row screen-reader-text">
            <td><a class="button remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
            <td><input type="text" class="widefat" name="title[]" /></td>


            <td><input type="text" class="widefat" name="value[]" value="" /></td>
            <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

        </tr>
        </tbody>
    </table>

    <p><a id="add-row" class="button" href="#"><span class="dashicons dashicons-plus" style="line-height: 28px; font-size:14px;"></span> Add another</a>
        <input type="submit" class="metabox_submit" value="Save" />
    </p>

<?php
}

add_action('save_post', 'ale_main_box_save');
function ale_main_box_save($post_id) {
    if ( ! isset( $_POST['ale_main_box_nonce'] ) ||
        ! wp_verify_nonce( $_POST['ale_main_box_nonce'], 'ale_main_box_nonce' ) )
        return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;

    if (!current_user_can('edit_post', $post_id))
        return;

    $old = get_post_meta($post_id, 'ale_main', true);
    $new = array();


    $titles = $_POST['title'];
    $values = $_POST['value'];

    $count = count( $titles );

    for ( $i = 0; $i < $count; $i++ ) {
        if ( $titles[$i] != '' ) :
            $new[$i]['title'] = stripslashes( strip_tags( $titles[$i] ) );
            $new[$i]['value'] = stripslashes( $values[$i] );
        endif;
    }

    if ( !empty( $new ) && $new != $old )
        update_post_meta( $post_id, 'ale_main', $new );
    elseif ( empty($new) && $old )
        delete_post_meta( $post_id, 'ale_main', $old );
}


/*-----------------------------------------------------------------------------------*/
/*	Add Metabox to Display Property Payment Information
/*-----------------------------------------------------------------------------------*/
add_action( 'add_meta_boxes', 'add_payment_meta_box' );

if( !function_exists( 'add_payment_meta_box' ) ){
    function add_payment_meta_box(){
        add_meta_box( 'ale_payment-meta-box', __('PayPal Payment Information', 'aletheme'), 'ale_payment_meta_box', 'properties', 'normal', 'core' );
    }
}

if( !function_exists( 'ale_payment_meta_box' ) ){
    function ale_payment_meta_box( $post ){

        $values = get_post_custom( $post->ID );
        $not_available  = __('No Data','aletheme');

        $txn_id         = isset( $values['ale_txn_id'] ) ? esc_attr( $values['ale_txn_id'][0] ) : $not_available;
        $payment_date   = isset( $values['ale_payment_date'] ) ? esc_attr( $values['ale_payment_date'][0] ) : $not_available;
        $payer_email    = isset( $values['ale_payer_email'] ) ? esc_attr( $values['ale_payer_email'][0] ) : $not_available;
        $first_name     = isset( $values['ale_first_name'] ) ? esc_attr( $values['ale_first_name'][0] ) : $not_available;
        $last_name      = isset( $values['ale_last_name'] ) ? esc_attr( $values['ale_last_name'][0] ) : $not_available;
        $payment_status = isset( $values['ale_payment_status'] ) ? esc_attr( $values['ale_payment_status'][0] ) : $not_available;
        $payment_gross  = isset( $values['ale_payment_gross'] ) ? esc_attr( $values['ale_payment_gross'][0] ) : $not_available;
        $payment_currency  = isset( $values['ale_mc_currency'] ) ? esc_attr( $values['ale_mc_currency'][0] ) : $not_available;

        ?>
        <table style="width:100%;">
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('ID','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($txn_id); ?></td>
            </tr>
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('Date','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($payment_date); ?></td>
            </tr>
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('First Name','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($first_name); ?></td>
            </tr>
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('Last Name','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($last_name); ?></td>
            </tr>
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('Payer Email','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($payer_email); ?></td>
            </tr>
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('Status','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($payment_status); ?></td>
            </tr>
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('Amount','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($payment_gross); ?></td>
            </tr>
            <tr>
                <td style="width:25%; vertical-align: top;"><strong><?php _e('Currency','aletheme');?></strong></td>
                <td style="width:75%;"><?php echo esc_attr($payment_currency); ?></td>
            </tr>
        </table>
    <?php
    }
}