<?php
/**
 * Get current theme options
 * 
 * @return array
 */
function aletheme_get_options() {
	$comments_style = array(
		'wp'  => 'Alethemes Comments',
		'fb'  => 'Facebook Comments',
		'dq'  => 'DISQUS',
		'lf'  => 'Livefyre',
		'off' => 'Disable All Comments',
	);

	$headerfont = array_merge(ale_get_safe_webfonts(), ale_get_google_webfonts());

	$background_defaults = array(
		'color' => '#1f1f1f',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll'
	);


	$imagepath =  ALETHEME_URL . '/assets/images/';

	$options = array();

	$options[] = array("name" => "Theme",
						"type" => "heading");

	$options[] = array( "name" => "Site Logo",
						"desc" => "Upload or put the site logo link (Default logo size: 133-52px)",
						"id" => "ale_site_logo",
						"std" => "",
						"type" => "upload");

	$options[] =array('name' => 'Footer logo',
						'desc' => ' Upload or put the footer logo link (Default logo size: 110-55px)',
						'id' => 'ale_footer_logo',
						'std' => "",
						'type' => 'upload');

	$options[] = array( 'name' => "Manage Background",
						'desc' => "Select the background color, or upload a custom background image.",
						'id' => 'ale_background',
						'std' => $background_defaults,
						'type' => 'background');

	$options[] = array( "name" => "Background Size Cover",
						"desc" => "Check if you want to select cover background size",
						"id" => "ale_backcover",
						"std" => "1",
						"type" => "checkbox");

	$options[] = array( 'name' => 'Show color selector?',
						'desc' => 'Select the Enable to show color selector',
						'id'   => 'ale_display_color_selector',
						'std'  => 'Enable',
						'type'    => 'select',
						'options' => array(
							'Enable' => 'Enable',
							'Disable' => 'Disable',
						), );

	$options[] = array( 'name' => "Manage Secondary color",
						'desc' => "Select the Secondary color. Default is the #e03434 color",
						'id' => 'ale_secondarycolor',
						'std' => '#e03434',
						'type' => 'color');

	$options[] = array( "name" => "Uplaod a favicon icon",
						"desc" => "Upload or put the link of your favicon icon",
						"id" => "ale_favicon",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Comments Style",
						"desc" => "Choose your comments style. If you want to use DISQUS comments please install and activate this plugin from <a href=\"" . admin_url('plugin-install.php?tab=search&type=term&s=Disqus+Comment+System&plugin-search-input=Search+Plugins') . "\">Wordpress Repository</a>.  If you want to use Livefyre Realtime Comments comments please install and activate this plugin from <a href=\"" . admin_url('plugin-install.php?tab=search&type=term&s=Livefyre+Realtime+Comments&plugin-search-input=Search+Plugins') . "\">Wordpress Repository</a>.",
						"id" => "ale_comments_style",
						"std" => "wp",
						"type" => "select",
						"options" => $comments_style);

	$options[] = array( "name" => "AJAX Comments",
						"desc" => "Use AJAX on comments posting (works only with Alethemes Comments selected).",
						"id" => "ale_ajax_comments",
						"std" => "1",
						"type" => "checkbox");

	$options[] = array( "name" => "Social Sharing",
						"desc" => "Enable social sharing for posts.",
						"id" => "ale_social_sharing",
						"std" => "1",
						"type" => "checkbox");

	$options[] = array( "name" => "Copyrights",
						"desc" => "Your copyright message.",
						"id" => "ale_copyrights",
						"std" => "",
						"type" => "editor");

	$options[] = array( "name" => "Typography",
						"type" => "heading");

	$options[] = array( "name" => "Select the body style from Google Library",
						"desc" => "The default Font is - Arial",
						"id" => "ale_font-a",
						"std" => "Arial",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the Header style 1 from Google Library",
						"desc" => "The default Font is - Montserrat",
						"id" => "ale_font-m",
						"std" => "Montserrat",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the body Font (Extended) from Google Library",
						"desc" => "The default Font (extended) is - 400",
						"id" => "ale_bodyfont-m1",
						"std" => "400",
						"type" => "text");

	$options[] = array( "name" => "Select the Header style 2 from Google Library",
						"desc" => "The default Font is - Raleway",
						"id" => "ale_font-r",
						"std" => "Raleway",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the body Font (Extended) from Google Library",
						"desc" => "The default Font (extended) is - 300,400,600,900",
						"id" => "ale_bodyfont-r1",
						"std" => "300,400,600,900",
						"type" => "text");

	$options[] = array( "name" => "Select the Header style 3 from Google Library",
						"desc" => "The default Font is - Open Sans",
						"id" => "ale_font-o",
						"std" => "Open+Sans",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the body Font (Extended) from Google Library",
						"desc" => "The default Font (extended) is - 400,900",
						"id" => "ale_bodyfont-o1",
						"std" => "400,900",
						"type" => "text");

	$options[] = array( 'name' => "H1 Style",
						'desc' => "Change the h1 style",
						'id' => 'ale_style-h1',
						'std' => array('size' => '22px','face' => 'Arial','style' => 'normal','color' => '#000000'),
						'type' => 'typography');

	$options[] = array( 'name' => "H2 Style",
						'desc' => "Change the h2 style",
						'id' => 'ale_style-h2',
						'std' => array('size' => '20px','face' => 'Arial','style' => 'normal','color' => '#000000'),
						'type' => 'typography');

	$options[] = array( 'name' => "H3 Style",
						'desc' => "Change the h3 style",
						'id' => 'ale_style-h3',
						'std' => array('size' => '18px','face' => 'Arial','style' => 'normal','color' => '#000000'),
						'type' => 'typography');

	$options[] = array( 'name' => "H4 Style",
						'desc' => "Change the h4 style",
						'id' => 'ale_style-h4',
						'std' => array('size' => '16px','face' => 'Arial','style' => 'normal','color' => '#000000'),
						'type' => 'typography');

	$options[] = array( 'name' => "H5 Style",
						'desc' => "Change the h5 style",
						'id' => 'ale_style-h5',
						'std' => array('size' => '14px','face' => 'Arial','style' => 'normal','color' => '#000000'),
						'type' => 'typography');

	$options[] = array( 'name' => "H6 Style",
						'desc' => "Change the h6 style",
						'id' => 'ale_style-h6',
						'std' => array('size' => '12px','face' => 'Arial','style' => 'normal','color' => '#000000'),
						'type' => 'typography');

	$options[] = array( 'name' => "Body Style",
						'desc' => "Change the body font style",
						'id' => 'ale_stylebody',
						'std' => array('size' => '12px','face' => 'Arial','style' => 'normal','color' => '#000000'),
						'type' => 'typography');

	$options[] = array( "name" => "Social",
						"type" => "heading");

	$options[] = array( "name" => "Twitter",
						"desc" => "Your twitter profile URL.",
						"id" => "ale_twi",
						"std" => "",
						"type" => "text");
	$options[] = array( "name" => "Facebook",
						"desc" => "Your facebook profile URL.",
						"id" => "ale_fb",
						"std" => "",
						"type" => "text");
	$options[] = array( "name" => "Pinterest",
						"desc" => "Your pinteres profile URL.",
						"id" => "ale_pint",
						"std" => "",
						"type" => "text");
	$options[] = array( "name" => "Flickr",
						"desc" => "Your flickr profile URL.",
						"id" => "ale_flickr",
						"std" => "",
						"type" => "text");

	$options[] = array( "name" => "Show RSS",
						"desc" => "Check if you want to show the RSS icon on your site",
						"id" => "ale_rssicon",
						"std" => "1",
						"type" => "checkbox");

	$options[] = array( "name" => "Facebook Application ID",
						"desc" => "If you have Application ID you can connect the blog to your Facebook Profile and monitor statistics there.",
						"id" => "ale_fb_id",
						"std" => "",
						"type" => "text");

	$options[] = array( "name" => "Enable Open Graph",
						"desc" => "The <a href=\"http://www.ogp.me/\">Open Graph</a> protocol enables any web page to become a rich object in a social graph.",
						"id" => "ale_og_enabled",
						"std" => "",
						"type" => "checkbox");

	$options[] = array( "name" => "Twitter",
						"type" => "heading");

	$options[] = array( "name" => "Username",
						"desc" => "Your twitter username",
						"id" => "ale_twiname",
						"std" => "",
						"type" => "text");

	$options[] = array( "name" => "Advanced Settings",
						"type" => "heading");


	$options[] = array( "name" => "Footer Code",
						"desc" => "If you have anything else to add in the footer - please add it here.",
						"id" => "ale_footer_info",
						"std" => "",
						"type" => "textarea");

	$options[] = array( "name" => "Custom CSS Styles",
						"desc" => "You can add here your styles. ex. .boxclass { padding:10px; }",
						"id" => "ale_customcsscode",
						"std" => "",
						"type" => "textarea");

	$options[] = array( "name" => "Footer menu title",
						"desc" => "Insert the footer menu title",
						"id" => "ale_footermenutitle",
						"std" => "Select a category",
						"type" => "text");

	$options[] = array('name' => 'Partners',
						'type' => 'heading');

	$options[] = array('name' => 'Partner 1 link ',
						'desc' => 'Insert the link of partner 1',
						'id' => 'ale_link_partner1',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 1 image ',
						'desc' => 'Insert the image of partner 1. Size 140x80px',
						'id' => 'ale_partner1',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Partner 2 link ',
						'desc' => 'Insert the link of partner 2',
						'id' => 'ale_link_partner2',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 2 image ',
						'desc' => 'Insert the image of partner 2. Size 140x80px',
						'id' => 'ale_partner2',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Partner 3 link ',
						'desc' => 'Insert the link of partner 3',
						'id' => 'ale_link_partner3',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 3 image ',
						'desc' => 'Insert the image of partner 3. Size 140x80px',
						'id' => 'ale_partner3',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Partner 4 link ',
						'desc' => 'Insert the link of partner 4',
						'id' => 'ale_link_partner4',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 4 image ',
						'desc' => 'Insert the image of partner 4. Size 140x80px',
						'id' => 'ale_partner4',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Partner 5 link ',
						'desc' => 'Insert the link of partner 5',
						'id' => 'ale_link_partner5',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 5 image ',
						'desc' => 'Insert the image of partner 5. Size 140x80px',
						'id' => 'ale_partner5',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Partner 6 link ',
						'desc' => 'Insert the link of partner 6',
						'id' => 'ale_link_partner6',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 6 image ',
						'desc' => 'Insert the image of partner 6. Size 140x80px',
						'id' => 'ale_partner6',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Partner 7 link ',
						'desc' => 'Insert the link of partner 7',
						'id' => 'ale_link_partner7',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 7 image ',
						'desc' => 'Insert the image of partner 7. Size 140x80px',
						'id' => 'ale_partner7',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Partner 8 link ',
						'desc' => 'Insert the link of partner 8',
						'id' => 'ale_link_partner8',
						'std' => "",
						'type' => 'text');

	$options[] = array('name' => 'Partner 8 image ',
						'desc' => 'Insert the image of partner 8. Size 140x80px',
						'id' => 'ale_partner8',
						'std' => "",
						'type' => 'upload');

	$options[] = array('name' => 'Gallery',
						'type' => 'heading');

	$options[] = array('name' => 'Gallery title',
						'desc' => 'Insert the title of gallery',
						'id' => 'ale_gallery_title',
						'std' => "There are many variations of passages",
						'type' => 'text');

	$options[] = array('name' => 'Gallery text',
						'desc' => 'Insert the text of gallery',
						'id' => 'ale_gallery_text',
						'std' => "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making it look like readable English. Many desktop publishing ",
						'type' => 'textarea');

	$options[] = array('name' => 'Footer',
						'type' => 'heading');

	$options[] = array('name' => 'Phone number',
						'desc' => 'Insert the phone number',
						'id' => 'ale_number_contacts',
						'std' => "800 234-67-89",
						'type' => 'text');

	$options[] = array('name' => 'Address',
						'desc' => 'Insert the address of contacts',
						'id' => 'ale_address_contacts',
						'std' => "Germany, Keln, 1428 Second St",
						'type' => 'text');

	$options[] = array('name' => 'Email',
						'desc' => 'Insert the email',
						'id' => 'ale_email_contacts',
						'std' => "info@website.com",
						'type' => 'text');

	$options[] = array('name' => 'Curency',
						'type' => 'heading');

	$options[] = array('name' => 'Insert the curency',
						'desc' => 'Insert the curency',
						'id' => 'ale_curency',
						'std' => "$",
						'type' => 'text');

	$options[] = array('name' => 'Archives',
						'type' => 'heading');

	$options[] = array('name' => 'Blog template 1',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_blog_1',
						'std' => "3",
						'type' => 'text');

	$options[] = array('name' => 'Blog template 2',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_blog_2',
						'std' => "5",
						'type' => 'text');

	$options[] = array('name' => 'Listing',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_listing_num',
						'std' => "11",
						'type' => 'text');

	$options[] = array('name' => 'Listing on reservation page',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_reservation_listing_num',
						'std' => "18",
						'type' => 'text');

	$options[] = array('name' => 'Special offers',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_special_affers_num',
						'std' => "5",
						'type' => 'text');

	$options[] = array('name' => 'Gallery',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_gallery_num',
						'std' => "12",
						'type' => 'text');

	$options[] = array('name' => 'Gallery template 1',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_gallery_num_1',
						'std' => "6",
						'type' => 'text');

	$options[] = array('name' => 'Gallery template 2',
						'desc' => 'Insert the number of posts',
						'id' => 'ale_gallery_num_2',
						'std' => "7",
						'type' => 'text');

	return $options;
}

/**
 * Add custom scripts to Options Page
 */
function aletheme_options_custom_scripts() {
 ?>

<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery('#ale_commentongallery').click(function() {
		jQuery('#section-ale_gallerycomments_style').fadeToggle(400);
	});
	if (jQuery('#ale_commentongallery:checked').val() !== undefined) {
		jQuery('#section-ale_gallerycomments_style').show();
	}
});
</script>

<?php
}

/**
 * Add Metaboxes
 * @param array $meta_boxes
 * @return array 
 */
function aletheme_metaboxes($meta_boxes) {

	$meta_boxes = array();

	$prefix = "ale_";


	$meta_boxes[] = array(
		'id'         => 'contact_page_metabox',
		'title'      => 'Contact Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-contact.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Contact page',
				'desc' => '',
				'id'   => $prefix . 'display_contact',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Content Box?',
				'desc' => 'Select enable to show the content box',
				'id'   => $prefix . 'display_contact_text',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Contact Form Box?',
				'desc' => 'Select enable to show the Contact Form box',
				'id'   => $prefix . 'display_contact_form',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Google Maps Box?',
				'desc' => 'Select enable to show the Google Maps box',
				'id'   => $prefix . 'display_contact_maps',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Title paragraph',
				'desc' => 'Insert the title',
				'std' => 'There are many variations of passages',
				'id'   => $prefix . 'title_contact',
				'type' => 'text',
			),
			array(
				'name' => 'Number of telephone',
				'desc' => 'Insert the number of telephone',
				'std' => ' 8 800 435-37-90',
				'id'   => $prefix. 'telephone_contact',
				'type' => 'text',
			),
			array(
				'name' => 'Email',
				'desc' => 'Insert the email',
				'std' => 'info@website.com',
				'id'   => $prefix. 'email_contact',
				'type' => 'text',
			),
			array(
				'name' => 'Address',
				'desc' => 'Insert the address',
				'std' => 'France Marseille, Main street 53',
				'id'   => $prefix. 'address_contact',
				'type' => 'text',
			),

		)
	);

	$meta_boxes[] = array(
		'id'         => 'home_metabox',
		'title'      => 'Home page option',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('page-home.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Home page',
				'desc' => '',
				'id'   => $prefix . 'display_home',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Slider Box?',
				'desc' => 'Select enable to show the Slider box',
				'id'   => $prefix . 'display_home_slider',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Filter Box?',
				'desc' => 'Select enable to show the Filter box',
				'id'   => $prefix . 'display_filter',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Listing Box?',
				'desc' => 'Select enable to show the Listing box',
				'id'   => $prefix . 'display_listing',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Image Description Box?',
				'desc' => 'Select enable to show the Image Description box',
				'id'   => $prefix . 'display_image',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Single Blog Post with descriptions',
				'desc' => 'Select enable to show the box',
				'id'   => $prefix . 'display_singleblog',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Blog and Brands Posts?',
				'desc' => 'Select enable to show the Blog Posts',
				'id'   => $prefix . 'display_blog',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Email Form?',
				'desc' => 'Select enable to show the Email Form',
				'id'   => $prefix . 'display_email',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Text Box?',
				'desc' => 'Select enable to show the Text Box',
				'id'   => $prefix . 'display_text',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Partners Box?',
				'desc' => 'Select enable to show the Partners Box',
				'id'   => $prefix . 'display_partners',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Slider',
				'id'   => $prefix . 'home_slider',
				'type' => 'title',
			),
			array(
				'name' => 'Number of slides',
				'desc' => 'Insert the number of slider items',
				'std' => '4',
				'id'   => $prefix . 'home_slider_num',
				'type' => 'text',
			),
			array(
				'name' => 'Listing',
				'id'   => $prefix . 'home_listing',
				'type' => 'title',
			),
			array(
				'name' => 'Number of posts',
				'desc' => 'Insert the number of listing posts',
				'std' => '7',
				'id'   => $prefix . 'home_listing_num',
				'type' => 'text',
			),
			array(
				'name' => 'Description',
				'id'   => $prefix . 'home_desc',
				'type' => 'title',
			),
			array(
				'name' => 'Brand',
				'desc' => 'Insert the title of the brand',
				'std' => 'Range rover',
				'id'   => $prefix . 'title_car',
				'type' => 'text',
			),
			array(
				'name' => 'Model',
				'desc' => 'Insert the car model',
				'std' => 'Sport',
				'id'   => $prefix . 'tip_car',
				'type' => 'text',
			),
			array(
				'name' => 'Year',
				'desc' => 'Insert the year of the car',
				'std' => '2014',
				'id'   => $prefix . 'year_car',
				'type' => 'text',
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 1920x900px',
				'id'   => $prefix . 'image_car',
				'type' => 'file',
			),
			array(
				'name' => 'Body type',
				'desc' => 'Insert the body type',
				'std' => 'City Car',
				'id'   => $prefix . 'home_model',
				'type' => 'text',
			),
			array(
				'name' => 'Engine Power',
				'desc' => 'Insert the engine power',
				'std' => '3200 ( 150 KW / 700 BHP )',
				'id'   => $prefix . 'home_power',
				'type' => 'text',
			),
			array(
				'name' => 'Transmission',
				'desc' => 'Insert the transmission of the car',
				'std' => 'Manual',
				'id'   => $prefix . 'home_transmission',
				'type' => 'text',
			),
			array(
				'name' => 'CO2 Emissions',
				'desc' => 'Insert the CO2 Emissions',
				'std' => 'EURO 5',
				'id'   => $prefix . 'home_emissions',
				'type' => 'text',
			),
			array(
				'name' => 'Price car',
				'desc' => 'Insert the price',
				'std' => '26,500',
				'id'   => $prefix . 'home_price',
				'type' => 'text',
			),
			array(
				'name' => 'Blog',
				'id'   => $prefix . 'home_blog',
				'type' => 'title',
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'std' => 'Blog',
				'id'   => $prefix . 'home_blog_title',
				'type' => 'text',
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'std' => 'Read our most interesting news here',
				'id'   => $prefix . 'home_blog_desc',
				'type' => 'text',
			),
			array(
				'name' => 'Number',
				'desc' => 'Insert the number of posts',
				'std' => '4',
				'id'   => $prefix . 'home_blog_num',
				'type' => 'text',
			),
			array(
				'name' => 'Brands',
				'id'   => $prefix . 'home_brands',
				'type' => 'title',
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'std' => 'Brands',
				'id'   => $prefix . 'home_brands_title',
				'type' => 'text',
			),
			array(
				'name' => 'Personal',
				'id'   => $prefix . 'home_personal',
				'type' => 'title',
			),
			array(
				'name' => 'Name',
				'desc' => 'Insert the name',
				'std' => 'Adam Berger',
				'id'   => $prefix . 'home_personal_name',
				'type' => 'text',
			),
			array(
				'name' => 'Phone',
				'desc' => 'Insert the phone number',
				'std' => '8 800 357 80 45',
				'id'   => $prefix . 'home_personal_phone',
				'type' => 'text',
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'std' => 'It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages and more ',
				'id'   => $prefix . 'home_personal_text',
				'type' => 'text',
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image',
				'id'   => $prefix . 'home_personal_image',
				'type' => 'file',
			),
			array(
				'name' => 'Link',
				'desc' => 'Insert the Url',
				'std' => 'http://aletheme.com/',
				'id'   => $prefix . 'home_personal_link',
				'type' => 'text',
			),
			array(
				'name' => 'Text',
				'id'   => $prefix . 'home_text',
				'type' => 'title',
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'std' => 'There are many variations of passages',
				'id'   => $prefix . 'home_text_text',
				'type' => 'text',
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'reservation_metabox',
		'title'      => 'Reservation page option',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-reservations.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Title',
				'desc' => 'Insert the title of the paragraph',
				'id'   => $prefix . 'title_p_reservation',
				'std' => 'There are many variations of passages',
				'type' => 'text',
			),
			array(
				'name' => 'Paragraph of the bottom',
				'desc' => 'Insert the text of the paragraph',
				'id'   => $prefix . 'text_reservation_bottom',
				'std' => "It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has",
				'type' => 'textarea',
			),

		)
	);

	$meta_boxes[] = array(
		'id'         => 'about_page_metabox',
		'title'      => 'About page option',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-about.php'), ), // Specific post templates to display this metabox
		'fields' => array(

			array(
				'name' => 'Display or hide Boxes on About page',
				'desc' => '',
				'id'   => $prefix . 'display_about',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Text Box?',
				'desc' => 'Select enable to show the top text box',
				'id'   => $prefix . 'display_about_text',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Information Box?',
				'desc' => 'Select enable to show the Information box',
				'id'   => $prefix . 'display_about_information',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Video Box?',
				'desc' => 'Select enable to show the video box',
				'id'   => $prefix . 'display_about_video',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Partners Box?',
				'desc' => 'Select enable to show the partners box',
				'id'   => $prefix . 'display_about_partners',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Information',
				'desc' => '',
				'id'   => $prefix . 'about_video',
				'type' => 'title',
			),
			array(
				'name' => 'Title circle1',
				'desc' => 'Insert the title of circle1',
				'std' => 'What is Lorem Ipsum',
				'id'   => $prefix . 'title_circle1_about',
				'type' => 'text',
			),
			array(
				'name' => 'Text circle1',
				'desc' => 'Insert the text of circle1',
				'std' => "Lorem Ipsum is simply dummy text of the
					printing and typesetting industry. Lorem
					Ipsum has been the industry's standart",
				'id'   => $prefix . 'text_circle1_about',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title circle2',
				'desc' => 'Insert the title of circle2',
				'std' => 'What is Lorem Ipsum',
				'id'   => $prefix . 'title_circle2_about',
				'type' => 'text',
			),
			array(
				'name' => 'Text circle2',
				'desc' => 'Insert the text of circle2',
				'std' => "Lorem Ipsum is simply dummy text of the
					printing and typesetting industry. Lorem Ipsum
					has been the industry's standard dummy text
					ever since the 1500s, when an unknown printer
					took a gallery of type and scrambled informalter-",
				'id'   => $prefix . 'text_circle2_about',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title circle3',
				'desc' => 'Insert the title of circle3',
				'std' => "What is Lorem Ipsum",
				'id'   => $prefix . 'title_circle3_about',
				'type' => 'text',
			),
			array(
				'name' => 'Text circle3',
				'desc' => 'Insert the text of circle3',
				'std' => "Lorem Ipsum is simply dummy text of the
					printing and typesetting industry. Lorem
					Ipsum has been the industry's standart",
				'id'   => $prefix . 'text_circle3_about',
				'type' => 'textarea',
			),
			array(
				'name' => 'Video',
				'desc' => '',
				'id'   => $prefix . 'about_video',
				'type' => 'title',
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title of center page',
				'std' => 'Lorem Ipsum is dummy text printing and typesetting industry',
				'id'   => $prefix . 'title_center_about',
				'type' => 'text',
			),
			array(
				'name' => 'Title No.2',
				'desc' => 'Insert the title of passages',
				'std' => 'There are many variations of passages ',
				'id'   => $prefix . 'title_passages_about',
				'type' => 'text',
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'std' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using \'Content here, content here\', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).',
				'id'   => $prefix . 'text_about',
				'type' => 'textarea',
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 716x351px',
				'id'   => $prefix . 'about_image',
				'type' => 'file',
			),

			array(
				'name' => 'Press Video link',
				'desc' => 'Insert the video or let it empty if you want to use an image.',
				'id'   => $prefix . 'about_video',
				'std'  => 'https://www.youtube.com/watch?v=reb-aOJrGOY',
				'type' => 'text',
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'service_metabox',
		'title'      => 'Service page option',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-service.php'), ), // Specific post templates to display this metabox
		'fields' => array(

			array(
				'name' => 'Display or hide Boxes on Service page',
				'desc' => '',
				'id'   => $prefix . 'display_service',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The top text Box?',
				'desc' => 'Select enable to show the top text box',
				'id'   => $prefix . 'display_service_text',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Information Box?',
				'desc' => 'Select enable to show the information box',
				'id'   => $prefix . 'display_service_information',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Statistics Box?',
				'desc' => 'Select enable to show the statistics box',
				'id'   => $prefix . 'display_service_details',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Service Box?',
				'desc' => 'Select enable to show the service box',
				'id'   => $prefix . 'display_service_detail',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Partners Box?',
				'desc' => 'Select enable to show the partners box',
				'id'   => $prefix . 'display_service_partners',
				'std'  => 'Enable',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Text block',
				'desc' => '',
				'id'   => $prefix . 'text_box',
				'type' => 'title',
			),
			array(
				'name' => 'Title paragraph top',
				'desc' => 'Insert the title paragraph top',
				'std' => 'What can we do for you?',
				'id'   => $prefix . 'title_top',
				'type' => 'text',
			),
			array(
				'name' => 'Information',
				'desc' => '',
				'id'   => $prefix . 'information_box',
				'type' => 'title',
			),
			array(
				'name' => 'Title circle1',
				'desc' => 'Insert the title of circle1',
				'std' => "What is Lorem Ipusm",
				'id'   => $prefix . 'title_circle1_service',
				'type' => 'text',
			),
			array(
				'name' => 'Text circle1',
				'desc' => 'Insert the text of circle1',
				'std' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard ",
				'id'   => $prefix . 'text_circle1_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title circle2',
				'desc' => 'Insert the title of circle2',
				'std' => "What is Lorem Ipusm",
				'id'   => $prefix . 'title_circle2_service',
				'type' => 'text',
			),
			array(
				'name' => 'Text circle2',
				'desc' => 'Insert the text of circle2',
				'std' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s , when an unknown printer took a galley of type and scrambled iformalter-",
				'id'   => $prefix . 'text_circle2_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title circle3',
				'desc' => 'Insert the title of circle3',
				'std' => "What is Lorem Ipusm",
				'id'   => $prefix . 'title_circle3_service',
				'type' => 'text',
			),
			array(
				'name' => 'Text circle3',
				'desc' => 'Insert the text of circle3',
				'std' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard ",
				'id'   => $prefix . 'text_circle3_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Statistics',
				'desc' => '',
				'id'   => $prefix . 'statistics_box',
				'type' => 'title',
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'std' => 'Our  Stats',
				'id'   => $prefix . 'stats_service',
				'type' => 'text',
			),
			array(
				'name' => 'Cars number',
				'desc' => 'Insert the number',
				'std' => '3200',
				'id'   => $prefix . 'service_cars_number',
				'type' => 'text',
			),
			array(
				'name' => 'Cars text',
				'desc' => 'Insert the text',
				'std' => 'Cars sold',
				'id'   => $prefix . 'service_cars_text',
				'type' => 'text',
			),
			array(
				'name' => 'Customer number',
				'desc' => 'Insert the number',
				'std' => '100%',
				'id'   => $prefix . 'service_customer_number',
				'type' => 'text',
			),
			array(
				'name' => 'Customer text',
				'desc' => 'Insert the text',
				'std' => 'Customer satisfaction',
				'id'   => $prefix . 'service_customer_text',
				'type' => 'text',
			),
			array(
				'name' => 'Likes number',
				'desc' => 'Insert the number',
				'std' => '4200',
				'id'   => $prefix . 'service_likes_number',
				'type' => 'text',
			),
			array(
				'name' => 'Likes text',
				'desc' => 'Insert the text',
				'std' => 'Likes',
				'id'   => $prefix . 'service_likes_text',
				'type' => 'text',
			),
			array(
				'name' => 'Image service',
				'desc' => 'Upload an image. Size: 1700x444px',
				'id'   => $prefix . 'image_service',
				'type' => 'file',
			),
			array(
				'name' => 'Details',
				'desc' => '',
				'id'   => $prefix . 'service_details',
				'type' => 'title',
			),
			array(
				'name' => 'Title services',
				'desc' => 'Insert the title for all services',
				'std' => 'Detailed Services',
				'id'   => $prefix . 'title_service',
				'type' => 'text',
			),
			array(
				'name' => 'Title service 1',
				'desc' => 'Insert the title service 1',
				'std' => 'Lorem Ipsum',
				'id'   => $prefix . 'title1_service',
				'type' => 'text',
			),
			array(
				'name' => 'Description service 1',
				'desc' => 'Insert the description service 1',
				'std' => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form",
				'id'   => $prefix . 'description1_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title service 2',
				'desc' => 'Insert the title service 2',
				'std' => 'Lorem Ipsum',
				'id'   => $prefix . 'title2_service',
				'type' => 'text',
			),
			array(
				'name' => 'Description service 2',
				'desc' => 'Insert the description service 2',
				'std' => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form",
				'id'   => $prefix . 'description2_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title service 3',
				'desc' => 'Insert the title service 3',
				'std' => 'Lorem Ipsum',
				'id'   => $prefix . 'title3_service',
				'type' => 'text',
			),
			array(
				'name' => 'Description service 3',
				'desc' => 'Insert the description service 3',
				'std' => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form",
				'id'   => $prefix . 'description3_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title service 4',
				'desc' => 'Insert the title service 4',
				'std' => 'Lorem Ipsum',
				'id'   => $prefix . 'title4_service',
				'type' => 'text',
			),
			array(
				'name' => 'Description service 4',
				'desc' => 'Insert the description service 4',
				'std' => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form",
				'id'   => $prefix . 'description4_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title service 5',
				'desc' => 'Insert the title service 5',
				'std' => 'Lorem Ipsum',
				'id'   => $prefix . 'title5_service',
				'type' => 'text',
			),
			array(
				'name' => 'Description service 5',
				'desc' => 'Insert the description service 5',
				'std' => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form",
				'id'   => $prefix . 'description5_service',
				'type' => 'textarea',
			),
			array(
				'name' => 'Title service 6',
				'desc' => 'Insert the title service 6',
				'std' => 'Lorem Ipsum',
				'id'   => $prefix . 'title6_service',
				'type' => 'text',
			),
			array(
				'name' => 'Description service 6',
				'desc' => 'Insert the description service 6',
				'std' => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form",
				'id'   => $prefix . 'description6_service',
				'type' => 'textarea',
			),


		)
	);

	$meta_boxes[] = array(
		'id'         => 'post_page_metabox',
		'title'      => 'Post Page Options',
		'pages'      => array( 'post', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Image for video',
				'desc' => 'Upload an background image video ',
				'id'   => $prefix . 'post_image',
				'type' => 'file',
			),
			array(
				'name' => 'Video link',
				'desc' => 'Insert the video url',
				'id'   => $prefix . 'blog_video_link',
				'type' => 'text',
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'gallery_page_metabox',
		'title'      => 'Gallery Page Options',
		'pages'      => array( 'gallery', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Insert the background image video',
				'desc' => 'Insert the background image video ',
				'id'   => $prefix . 'video_gallery',
				'type' => 'file',
			),
			array(
				'name' => 'Press Video link',
				'desc' => 'Insert the video or let it empty if you want to use an image. (Embed link - ex //www.youtube.com/embed/LtulTGxJdDc)',
				'id'   => $prefix . 'video_gallery1',
				'type' => 'text',
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'post_listing_page',
		'title'      => 'Listing Page Options',
		'pages'      => array( 'listing', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Location of car',
				'desc' => 'Location',
				'id'   => $prefix . 'location_car',
				'type' => 'text',
			),
			array(
				'name' => 'Price car',
				'desc' => 'Price car',
				'id'   => $prefix . 'pret_car',
				'type' => 'text',
			),
			array(
				'name' => 'Brakes',
				'desc' => '',
				'id'   => $prefix . 'brakes_car',
				'type' => 'checkbox',
			),
			array(
				'name' => 'Car-repair',
				'desc' => '',
				'id'   => $prefix . 'repair_car',
				'type' => 'checkbox',
			),
			array(
				'name' => 'Engine-oil',
				'desc' => '',
				'id'   => $prefix . 'oil_car',
				'type' => 'checkbox',
			),
			array(
				'name' => 'Transmission car',
				'desc' => '',
				'id'   => $prefix . 'transmission_icon_car',
				'type' => 'checkbox',
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'post_special_page',
		'title'      => 'Special Offer Page Options',
		'pages'      => array( 'special-offers', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Price car',
				'desc' => 'Insert the price car',
				'id'   => $prefix . 'price_car_offers',
				'type' => 'text',
			),
			array(
				'name' => 'Kilometers',
				'desc' => 'Insert km of car',
				'id'   => $prefix . 'km_car',
				'type' => 'text',
			),
			array(
				'name' => 'Reduction of car',
				'desc' => 'Insert reduction of car. Example: 25%',
				'id'   => $prefix . 'reduction_car',
				'type' => 'text',
			),
			array(
				'name' => 'Show in slider?',
				'desc' => 'Select enable to show this post in Slider on home page',
				'id'   => $prefix . 'display_in_home_slider',
				'std'  => '',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Disable', 'value' => 'off', ),
					array( 'name' => 'Enable', 'value' => 'on', )
				),
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'post_our-team',
		'title'      => 'Post Page Options',
		'pages'      => array( 'our-team', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Workstation',
				'desc' => 'Insert the workstation',
				'id'   => $prefix . 'workstation',
				'type' => 'text',
			),
			array(
				'name' => 'Telephone',
				'desc' => 'Insert the number of contacts',
				'id'   => $prefix . 'number-team',
				'type' => 'text',
			),
			array(
				'name' => 'Email',
				'desc' => 'Insert the email',
				'id'   => $prefix . 'email-team',
				'type' => 'text',
			),

		)
	);


	return $meta_boxes;
}

/**
 * Get image sizes for images
 * 
 * @return array
 */
function aletheme_get_images_sizes() {
	return array(
		'gallery' => array(
			array(
				'name'      => 'gallery-thumba',
				'width'     => 430,
				'height'    => 267,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-mini',
				'width'     => 100,
				'height'    => 67,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-style1',
				'width'     => 334,
				'height'    => 271,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-big1',
				'width'     => 606,
				'height'    => 554,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-big2',
				'width'     => 351,
				'height'    => 277,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-big3',
				'width'     => 606,
				'height'    => 277,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-thumbmini',
				'width'     => 565,
				'height'    => 315,
				'crop'      => true,
			),
				 array(
				'name'      => 'gallery-big',
				'width'     => 1920,
				'height'    => 510,
				'crop'      => true,
			),
		),
		'post' => array(
			array(
				'name'      => 'post-blog1',
				'width'     => 683,
				'height'    => 343,
				'crop'      => true,
			),
			array(
				'name'      => 'post-blog_2',
				'width'     => 280,
				'height'    => 242,
				'crop'      => true,
			),
			array(
				'name'      => 'post-blog_p',
				'width'     => 102,
				'height'    => 70,
				'crop'      => true,
			),
			array(
				'name'      => 'post-big',
				'width'     => 1920,
				'height'    => 510,
				'crop'      => true,
			),
			array(
				'name'      => 'post-thumba',
				'width'     => 475,
				'height'    => 295,
				'crop'      => true,
			),
			array(
				'name'      => 'post-blog',
				'width'     => 153,
				'height'    => 153,
				'crop'      => true,
			),
			array(
				'name'      => 'post-blog2',
				'width'     => 470,
				'height'    => 345,
				'crop'      => true,
			),
			array(
				'name'      => 'post-blog-middle',
				'width'     => 225,
				'height'    => 262,
				'crop'      => true,
			),
			array(
				'name'      => 'post-blog3',
				'width'     => 225,
				'height'    => 345,
				'crop'      => true,
			),
			array(
				'name'      => 'post-blog5',
				'width'     => 225,
				'height'    => 262,
				'crop'      => true,
			),
			array(
				'name'      => 'post-category',
				'width'     => 150,
				'height'    => 150,
				'crop'      => true,
			),
			array(
				'name'      => 'post-archive-big',
				'width'     => 470,
				'height'    => 344,
				'crop'      => true,
			),
		),
		'listing' => array(
			array(
				'name'      => 'listing-min',
				'width'     => 245,
				'height'    => 255,
				'crop'      => true,
			),
			array(
				'name'      => 'listing-max',
				'width'     => 490,
				'height'    => 255,
				'crop'      => true,
			),
			array(
				'name'      => 'listing-gallery2',
				'width'     => 170,
				'height'    => 170,
				'crop'      => true,
			),
			array(
				'name'      => 'listing-gallery',
				'width'     => 162,
				'height'    => 128,
				'crop'      => true,
			),
			array(
				'name'      => 'listing-image',
				'width'     => 500,
				'height'    => 380,
				'crop'      => true,
			),
			array(
				'name'      => 'listing-big',
				'width'     => 1920,
				'height'    => 510,
				'crop'      => true,
			),
		),
		'special-offers' => array(
			array(
				'name'      => 'special-offers-img',
				'width'     => 285,
				'height'    => 200,
				'crop'      => true,
			),
			array(
				'name'      => 'special-offers-special',
				'width'     => 500,
				'height'    => 380,
				'crop'      => true,
			),
			array(
				'name'      => 'special-offers-images',
				'width'     => 162,
				'height'    => 128,
				'crop'      => true,
			),
			array(
				'name'      => 'special-offers-slider',
				'width'     => 800,
				'height'    => 351,
				'crop'      => true,
			),
			array(
				'name'      => 'special-offers-big',
				'width'     => 1920,
				'height'    => 510,
				'crop'      => true,
			),
		),
		'our-team' => array(
			array(
				'name'      => 'our-team-management',
				'width'     => 308,
				'height'    => 253,
				'crop'      => true,
			),
			array(
				'name'      => 'our-team-agent',
				'width'     => 308,
				'height'    => 253,
				'crop'      => true,
			),
			array(
				'name'      => 'our-team-big',
				'width'     => 1920,
				'height'    => 510,
				'crop'      => true,
			),
		),
		'product' => array(
			array(
				'name'      => 'product-thumba',
				'width'     => 227,
				'height'    => 227,
				'crop'      => true,
			),
		),
	);
}

/**
 * Add post formats that are used in theme
 * 
 * @return array
 */
function aletheme_get_post_formats() {
	return array();
}

/**
 * Get sidebars list
 * 
 * @return array
 */
function aletheme_get_sidebars() {
	$sidebars = array();
	return $sidebars;
}

/**
 * Predefine custom sliders
 * @return array
 */
function aletheme_get_sliders() {
	return array(
		'brands' => array(
			'title'	=> 'Brands. Image size: 150x125px',
		),
	);
}

/**
 * Post types where metaboxes should show
 * 
 * @return array
 */
function aletheme_get_post_types_with_gallery() {
	return array('gallery','post','page','listing','special-offers','our-team');
}

/**
 * Add custom fields for media attachments
 * @return array
 */
function aletheme_media_custom_fields() {
	return array();
}