<?php
/**
 * Template Name: Template Service
 */
get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageabout')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageabout')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>

	<div class="page-block wrapper service-box">
		<?php get_breadcrumbs(); ?>
		<h1><?php wp_title("", true); ?></h1>
	</div>

	<?php if(ale_get_meta('displayserviceinfo')!="off"): ?>
		<div class="service-info">
			<?php if(ale_get_meta('serviceinfobg')){ ?>
				<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_meta('serviceinfobg')); ?>');"></div>
			<?php } ?>
			<div class="wrapper clearfix">
				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('serviceinfoicon1')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('serviceinfotitle1')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('serviceinfotext1')); ?></p>
				</article>

				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('serviceinfoicon2')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('serviceinfotitle2')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('serviceinfotext2')); ?></p>
				</article>

				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('serviceinfoicon3')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('serviceinfotitle3')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('serviceinfotext3')); ?></p>
				</article>

				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('serviceinfoicon4')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('serviceinfotitle4')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('serviceinfotext4')); ?></p>
				</article>
			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayservicedesc')!="off"): ?>
		<section class="service-description wrapper clearfix">
			<div class="image">
				<?php if(ale_get_meta('servicedescimage')){
					echo '<img src="'.esc_url(ale_get_meta('servicedescimage')).'" alt>';
				} else{
					echo '<img src="http://placehold.it/563x282/ece6d9/8d7a65" alt>';
				} ?>
			</div>

			<div class="text">
				<h2><?php echo esc_attr(ale_get_meta('servicedesctitle')); ?></h2>
				<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				<div class="story">
					<?php the_content(); ?>
				</div>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayservicepeople')!="off"):
		wp_reset_query();
		$count = esc_attr(ale_get_meta('servicepeoplecount'));
		$query_academics = new WP_Query(
			array(
				'posts_per_page' => $count,
				'post_type' => 'academics',
				'ignore_sticky_posts' => 1,
				'post__not_in' => get_option('sticky_posts'),
				'orderby' => 'comment_count'
			)
		);
		$academics_count = 0;
		if ($query_academics->have_posts()) :?>
		<section class="service-teachers">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('servicepeopletitle')); ?></h2>
				<div class="slider">
					<ul class="slides">
						<?php while ($query_academics->have_posts()) : $query_academics->the_post(); $academics_count++;
						if($academics_count%3==1){echo '<li class="clearfix">';}?>
							<article>
								<div class="image">
									<?php if(get_the_post_thumbnail($post->ID,'academics-service')){
										echo get_the_post_thumbnail($post->ID,'academics-service');
									} else{
										echo '<img src="http://placehold.it/65x65/ece6d9/8d7a65&amp;text=No+image" alt>';
									}?>
								</div>

								<div class="text">
									<h3 class="brown-color"><?php the_title(); ?></h3>
									<span class="post brown-color"><?php echo esc_attr(ale_get_meta('academicspost')); ?></span>
								</div>

								<div class="overlay">
									<div class="vert-align">
										<?php if(ale_get_meta('academicssocialtwi')): ?>
											<a href="<?php echo esc_url(ale_get_meta('academicssocialtwi')); ?>" class="yellow-color">
												<i class="fa fa-twitter"></i>
											</a>
										<?php endif; ?>

										<?php if(ale_get_meta('academicssocialfb')): ?>
											<a href="<?php echo esc_url(ale_get_meta('academicssocialfb')); ?>" class="yellow-color">
												<i class="fa fa-facebook"></i>
											</a>
										<?php endif; ?>

										<?php if(ale_get_meta('academicssocialin')): ?>
											<a href="<?php echo esc_url(ale_get_meta('academicssocialin')); ?>" class="yellow-color">
												<i class="fa fa-linkedin"></i>
											</a>
										<?php endif; ?>
									</div>
									<a href="<?php the_permalink(); ?>"></a>
								</div>
							</article>
						<?php if($academics_count%3==0){echo '</li>';} endwhile; ?>
					</ul>
				</div>
			</div>
		</section>
		<?php endif;
	endif; wp_reset_query(); ?>

	<?php if(ale_get_meta('displayservicecourses')!="off"): ?>
		<section class="service-courses">
			<h2><?php echo esc_attr(ale_get_meta('servicecoursestitle')); ?></h2>
			<div class="items">
				<?php if(ale_get_meta('servicecoursesimage')){ ?>
					<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_meta('servicecoursesimage')); ?>');"></div>
				<?php } ?>

				<div class="wrapper clearfix">
					<?php
					wp_reset_query();
					$query_course = new WP_Query(
						array(
							'posts_per_page' => 3,
							'post_type' => 'course',
							'ignore_sticky_posts' => 1,
							'post__not_in' => get_option('sticky_posts'),
							'meta_query' => array(
								array(
									'key' => 'ale_courseservice',
									'value' => 'on'
								)
							),
						)
					);
					$course_count = 0;
					if ($query_course->have_posts()) : while ($query_course->have_posts()) : $query_course->the_post(); $course_count++; ?>
						<article>
							<span class="duration">
								<?php echo esc_attr(ale_get_meta('courseadditionalduration')); ?>
							</span>
							<h3><?php the_title(); ?></h3>
							<ul class="fields-list">
								<?php if(ale_get_meta('courseadditionalfield1')){ ?>
									<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield1')); ?></li>
								<?php } ?>

								<?php if(ale_get_meta('courseadditionalfield2')){ ?>
									<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield2')); ?></li>
								<?php } ?>

								<?php if(ale_get_meta('courseadditionalfield3')){ ?>
									<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield3')); ?></li>
								<?php } ?>

								<?php if(ale_get_meta('courseadditionalfield4')){ ?>
									<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield4')); ?></li>
								<?php } ?>
							</ul>
							<span class="price">
								<?php echo esc_attr(ale_get_meta('courseadditionalprice')); ?>
								<span>/ <?php echo esc_attr(ale_get_meta('courseadditionaldate')); ?></span>
							</span>
							<a href="<?php the_permalink(); ?>"></a>
						</article>
						<?php if($course_count==1||$course_count==2){
							echo '<hr>';
						} ?> 
					<?php endwhile; endif; wp_reset_query();?>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayservicewhatdo')): ?>
		<section class="section-what-do">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('servicewhatdotitle')); ?></h2>
				<div class="items">
					<article>
						<i class="fa fa-<?php echo esc_attr(ale_get_meta('servicewhatdoicon1')); ?> yellow-color"></i>
						<h3><?php echo esc_attr(ale_get_meta('servicewhatdotitle1')); ?></h3>
						<p><?php echo esc_attr(ale_get_meta('servicewhatdodesc1')); ?></p>
					</article>

					<article>
						<i class="fa fa-<?php echo esc_attr(ale_get_meta('servicewhatdoicon2')); ?> yellow-color"></i>
						<h3><?php echo esc_attr(ale_get_meta('servicewhatdotitle2')); ?></h3>
						<p><?php echo esc_attr(ale_get_meta('servicewhatdodesc2')); ?></p>
					</article>

					<article>
						<i class="fa fa-<?php echo esc_attr(ale_get_meta('servicewhatdoicon3')); ?> yellow-color"></i>
						<h3><?php echo esc_attr(ale_get_meta('servicewhatdotitle3')); ?></h3>
						<p><?php echo esc_attr(ale_get_meta('servicewhatdodesc3')); ?></p>
					</article>

					<article>
						<i class="fa fa-<?php echo esc_attr(ale_get_meta('servicewhatdoicon4')); ?> yellow-color"></i>
						<h3><?php echo esc_attr(ale_get_meta('servicewhatdotitle4')); ?></h3>
						<p><?php echo esc_attr(ale_get_meta('servicewhatdodesc4')); ?></p>
					</article>

					<article>
						<i class="fa fa-<?php echo esc_attr(ale_get_meta('servicewhatdoicon5')); ?> yellow-color"></i>
						<h3><?php echo esc_attr( ale_get_meta('servicewhatdotitle5')); ?></h3>
						<p><?php echo esc_attr(ale_get_meta('servicewhatdodesc5')); ?></p>
					</article>

					<article>
						<i class="fa fa-<?php echo esc_attr(ale_get_meta('servicewhatdoicon6')); ?> yellow-color"></i>
						<h3><?php echo esc_attr(ale_get_meta('servicewhatdotitle6')); ?></h3>
						<p><?php echo esc_attr(ale_get_meta('servicewhatdodesc6')); ?></p>
					</article>
				</div>
			</div>
		</section>
	<?php endif; ?>
<?php get_footer(); ?>