<?php 
/**
 * Template Name: Template Home 5
 */
 // send contact
if (isset($_POST['contact'])) {
	$error = ale_send_contact($_POST['contact']);
}
get_header(); ?>
	<?php if(ale_get_meta('displayhome5slider')!="off"): ?>
		<?php if(ale_get_meta('displayhome5slider')=='on'){ ?>
			<div class="home-5-slider">
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_meta('home5slidercount'));
				$query_library = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'library',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'meta_query' => array(
							array(
								'key' => 'ale_libraryslider',
								'value' => 'on'
							)
						),
					)
				);
				if ($query_library->have_posts()) : ?>
					<div class="slider">
						<ul class="slides">
							<?php while ($query_library->have_posts()) : $query_library->the_post(); ?>
								<li>
									<?php if(get_the_post_thumbnail($post->ID,'library-home5')){
										echo get_the_post_thumbnail($post->ID,'library-home5');
									} else{
										echo '<img src="http://placehold.it/1920x592/ece6d9/8d7a65&amp;text=No+image" alt>';
									}?>
									<div class="text">
										<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										<div class="string">
											<?php echo ale_trim_excerpt(6); ?>
										</div>
										<div class="filter">
											<form method="post" action="<?php echo home_url(); ?>/library">
												<input type="search" value="Search" placeholder="Search" id="library_title" name="library_title">
												<div class="form-button">
													<input type="submit" value="<?php _e('Search', 'aletheme'); ?>">
												</div>
											</form>
										</div>
									</div>
								</li>
							<?php endwhile; ?>
						</ul>
					</div>
				<?php endif; wp_reset_query();?>
			</div>
		<?php }elseif(ale_get_meta('displayhome5slider')=='simple'){ ?>
			<div class="homeslider flexslider">
				<ul class="slides">
					<?php $slider = ale_sliders_get_slider(ale_get_option('homeslugfull'));  ?>
					<?php if($slider):?>
						<?php foreach ($slider['slides'] as $slide) : ?>
							<li>
								<?php if ($slide['image']) : ?>
									<img src="<?php echo esc_url($slide['image']); ?>" alt="<?php echo $slide['title']; ?>" />
								<?php endif; ?>
								<div class="text wrapper">
									<?php if($slide['title']){ echo '<h2>'.esc_attr($slide['title']).'</h2>'; } ?>
									<h3><?php echo esc_attr($slide['description']); ?></h3>
									<?php if($slide['url']){ ?><a class="button-arrow" href="<?php echo esc_url($slide['url']); ?>"><?php } ?>
										<?php _e('See more','aletheme'); ?>
									<?php if($slide['url']){ ?></a><?php } ?>
								</div>
							</li>
						<?php endforeach; ?>
					<?php endif;?>
				</ul>
			</div>
		<?php } ?>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome5info')!="off"): ?>
		<section class="home-5-info">
			<div class="wrapper clearfix">
				<hr>
				<h2><?php echo esc_attr(ale_get_meta('home5infotitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('home5infodesc')); ?></p>
				<div class="items">
					<div class="col-3">
						<div class="item">
							<span class="number"><?php echo esc_attr(ale_get_meta('home5infonumber1')); ?></span>
							<span class="desc"><?php echo esc_attr(ale_get_meta('home5infotext1')); ?></span>
						</div>

						<div class="item">
							<span class="number"><?php echo esc_attr(ale_get_meta('home5infonumber2')); ?></span>
							<span class="desc"><?php echo esc_attr(ale_get_meta('home5infotext2')); ?></span>
						</div>
					</div>
					<div class="col-6">
						<?php if(ale_get_meta('home5infoimage')){
							echo '<img src="'.esc_url(ale_get_meta('home5infoimage')).'" alt>';
						} else{
							echo '<img src="http://placehold.it/440x546/ece6d9/8d7a65" alt>';
						} ?>
					</div>
					<div class="col-3">
						<div class="item">
							<span class="number"><?php echo esc_attr(ale_get_meta('home5infonumber3')); ?></span>
							<span class="desc"><?php echo esc_attr(ale_get_meta('home5infotext3')); ?></span>
						</div>

						<div class="item">
							<span class="number"><?php echo esc_attr(ale_get_meta('home5infonumber4')); ?></span>
							<span class="desc"><?php echo esc_attr(ale_get_meta('home5infotext4')); ?></span>
						</div>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome5courses')!="off"): ?>
		<section class="home-5-course">
			<div class="title-block"<?php if(ale_get_meta('home5coursesimage')){
				echo ' style="background-image: url('.esc_url(ale_get_meta('home5coursesimage')).');"';
			} ?>>
				<h2><?php echo esc_attr(ale_get_meta('home5coursestitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('home5coursesdesc')); ?></p>
			</div>

			<div class="wrapper slider">
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_meta('home5coursescount'));
				$query_courses = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'course',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_courses->have_posts()) : ?>
					<ul class="slides">
						<?php while ($query_courses->have_posts()) : $query_courses->the_post(); ?>
							<li class="clerfix">
								<div class="image">
									<?php if(get_the_post_thumbnail($post->ID,'course-home5')){
										echo get_the_post_thumbnail($post->ID,'course-home5');
									} else{
										echo '<img src="http://placehold.it/422x423/ece6d9/8d7a65&amp;text=No+image" alt>';
									}?>
									<a href="<?php the_permalink(); ?>"><i class="fa fa-play"></i></a>
								</div>

								<div class="text">
									<h3><?php the_title(); ?></h3>
									<p><?php echo esc_attr(ale_get_meta('coursedesc')); ?></p>
									<div class="string">
										<?php echo ale_trim_excerpt(40); ?>
									</div>
									<?php if(ale_get_meta('coursehoursejanuary')||ale_get_meta('coursehoursefebruary')||ale_get_meta('coursehoursemarch')||
									ale_get_meta('coursehourseapril')||ale_get_meta('coursehoursemay')||ale_get_meta('coursehoursejune')||
									ale_get_meta('coursehoursejuly')||ale_get_meta('coursehourseaugust')||ale_get_meta('coursehourseseptember')||
									ale_get_meta('coursehourseoctober')||ale_get_meta('coursehoursenovember')||ale_get_meta('coursehoursedecember')): ?>
										<div class="table">
											<?php if(ale_get_meta('coursehoursejanuary')): ?>
												<div class="column">
													<div class="row"><?php _e('Jan', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursejanuary')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehoursefebruary')): ?>
												<div class="column">
													<div class="row"><?php _e('Feb', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursefebruary')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehoursemarch')): ?>
												<div class="column">
													<div class="row"><?php _e('Mar', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursemarch')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehourseapril')): ?>
												<div class="column">
													<div class="row"><?php _e('Apr', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehourseapril')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehoursemay')): ?>
												<div class="column">
													<div class="row"><?php _e('May', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursemay')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehoursejune')): ?>
												<div class="column">
													<div class="row"><?php _e('Jun', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursejune')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehoursejuly')): ?>
												<div class="column">
													<div class="row"><?php _e('Jul', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursejuly')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehourseaugust')): ?>
												<div class="column">
													<div class="row"><?php _e('Aug', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehourseaugust')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehourseseptember')): ?>
												<div class="column">
													<div class="row"><?php _e('Sep', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehourseseptember')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehourseoctober')): ?>
												<div class="column">
													<div class="row"><?php _e('Oct', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehourseoctober')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehoursenovember')): ?>
												<div class="column">
													<div class="row"><?php _e('Nov', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursenovember')); ?></div>
												</div>
											<?php endif; ?>

											<?php if(ale_get_meta('coursehoursedecember')): ?>
												<div class="column">
													<div class="row"><?php _e('Dec', 'aletheme'); ?></div>
													<div class="row"><?php echo esc_attr(ale_get_meta('coursehoursedecember')); ?></div>
												</div>
											<?php endif; ?>
										</div>
									<?php endif; ?>
									<a href="<?php the_permalink(); ?>" class="button"><?php _e('Read more', 'aletheme'); ?></a>
								</div>
							</li>
						<?php endwhile; ?>
					</ul>
				<?php endif; wp_reset_query();?>	
			</div>

			<div class="wrapper custom clearfix">
				<div class="statistics">
					<div class="myStat one" data-border="inline" data-dimension="270" data-width="13" data-fill="#f4f0e6" data-bgcolor="#f4f0e6" data-fgcolor="#3b2409" data-percent="<?php echo esc_attr(ale_get_meta('home5coursesstatisticsprocent3')); ?>" data-fill="#fff"></div>
					<div class="myStat two" data-border="inline" data-dimension="237" data-width="13" data-fill="#f4f0e6" data-bgcolor="#f4f0e6" data-fgcolor="#f4c000" data-percent="<?php echo esc_attr(ale_get_meta('home5coursesstatisticsprocent1')); ?>" data-fill="#fff"></div>
					<div class="myStat three" data-border="inline" data-fontsize="21" data-dimension="203" data-width="13" data-fill="#f4f0e6" data-bgcolor="#f4f0e6" data-fgcolor="#94a050" data-text="<?php echo esc_attr(ale_get_meta('home5coursesstatisticsyear')); ?>" data-percent="<?php echo esc_attr(ale_get_meta('home5coursesstatisticsprocent2')); ?>" data-fill="#fff"></div>
				</div>

				<div class="statistics-text">
					<h3><?php echo esc_attr(ale_get_meta('home5coursesstatisticstitle')); ?></h3>
					<p><?php echo esc_attr(ale_get_meta('home5coursesstatisticstext')); ?></p>
					<span><i class="fa fa-circle yellow-color"></i><?php echo esc_attr(ale_get_meta('home5coursesstatisticstitle1')); ?></span>
					<span><i class="fa fa-circle green-color"></i><?php echo esc_attr(ale_get_meta('home5coursesstatisticstitle2')); ?></span>
					<span><i class="fa fa-circle brown-color"></i><?php echo esc_attr(ale_get_meta('home5coursesstatisticstitle3')); ?></span>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome5desc')!="off"): ?>
		<section class="home-5-description">
			<?php if(ale_get_meta('home5descriptionbg')){ ?>
				<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_meta('home5descriptionbg')); ?>');"></div>
			<?php } ?>
			<h2><?php echo esc_attr(ale_get_meta('home5descriptiontitle')); ?></h2>
			<p><?php echo esc_attr(ale_get_meta('home5descriptiontext')); ?></p>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome5blog')!="off"): ?>
		<section class="home-5-blog wrapper clearfix">
			<div class="col-2">
				<h2><span><?php echo esc_attr(ale_get_meta('home5blogtitle1')); ?></span><?php echo esc_attr(ale_get_meta('home5blogtitle2')); ?></h2>
				<a href="<?php $posts_page_url = get_page_uri(get_option( 'page_for_posts')); echo home_url().'/' .$posts_page_url; ?>"><?php _e('Go to blog', 'aletheme'); ?><i class="fa fa-angle-right"></i></a>
			</div>

			<div class="col-10 clearfix">
				<?php
				wp_reset_query();
				$query_blog = new WP_Query(
					array(
						'posts_per_page' => 6,
						'post_type' => 'post',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				$blog_count = 0;
				if ($query_blog->have_posts()) : while ($query_blog->have_posts()) : $query_blog->the_post(); $blog_count++; ?>
					<article>
						<?php
						if($blog_count==1){
							if(get_the_post_thumbnail($post->ID,'post-home2')){
								echo get_the_post_thumbnail($post->ID,'post-home2');
								echo '<div class="gradient"></div>';
							} else{
								echo '<img src="http://placehold.it/320x168/ece6d9/ece6d9&amp;text=No+image" alt>';
							}
						} elseif($blog_count==3||$blog_count==4||$blog_count==5){
							echo '<img src="http://placehold.it/320x168/252422/252422&amp;text=No+image" alt>';
						} else{
							echo '<img src="http://placehold.it/320x168/ece6d9/ece6d9&amp;text=No+image" alt>';
						}?>
						<div class="text">
							<h3<?php if($blog_count==2||$blog_count==6){echo ' class="brown-color"';} ?>><?php the_title(); ?></h3>
							<span><?php the_time('j F Y'); ?></span>
							<span class="comments"><?php _e('Comments', 'aletheme1'); $comments_count = wp_count_comments($post->ID);
							echo ': ' . $comments_count->total_comments; ?></span>
						</div>
						<a href="<?php the_permalink(); ?>"></a>
					</article>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome5contact')!="off"): ?>
		<section class="home-5-contact">
			<div class="form-wrapper">
				<hr>
				<h2><?php echo esc_attr(ale_get_meta('home5contacttitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('home5contactdesc')); ?></p>
				
				<form method="post" action="<?php the_permalink();?>" class="form clearfix">
					<?php if (isset($error) && isset($error['msg'])) : ?>
						<p class="error"><?php echo $error['msg']?></p>
					<?php endif; ?>
						<div class="col-6">
							<input name="contact[name]" type="text" placeholder="Your Name" value="<?php echo isset($_POST['contact']['name']) ? $_POST['contact']['name'] : ''?>" required="required" id="contact-form-name" />
							<input name="contact[email]" type="email" placeholder="E-mail" value="<?php echo isset($_POST['contact']['email']) ? $_POST['contact']['email'] : ''?>" required="required" id="contact-form-email" />
						</div>

						<div class="col-6">
							<textarea name="contact[message]"  placeholder="Message..." id="contact-form-message" required="required"><?php echo isset($_POST['contact']['message']) ? $_POST['contact']['message'] : ''?></textarea>
						</div>
						<div class="form-button">
							<input type="submit" class="submit" value="<?php _e('Send message', 'aletheme')?>"/>
						</div>
					<?php wp_nonce_field() ?>
					<?php if (isset($_GET['success'])) : ?>
						<p class="success"><?php _e('Thank you for your message!', 'aletheme')?></p>
					<?php endif; ?>
				</form>
			</div>

			<?php if (have_posts()) : while (have_posts()) : the_post();
				if(get_the_post_thumbnail($post->ID,'post-thumba')){
					echo '<div class="page-bg-image">' . get_the_post_thumbnail($post->ID,'post-full') . '</div>';
				}
			endwhile; endif; wp_reset_query();?>
		</section>
	<?php endif; ?>
<?php get_footer(); ?>