<?php 
/**
 * Template Name: Template Home 4
 */
get_header(); ?>
	<?php if(ale_get_meta('displayhome4slider')!="off"): ?>
		<?php if(ale_get_meta('displayhome4slider') == 'on'){ ?>
			<div class="home-4-slider">
				<?php
				wp_reset_query();
				$query_gallery = new WP_Query(
					array(
						'posts_per_page' => 4,
						'post_type' => 'gallery',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'meta_query' => array(
							array(
								'key' => 'ale_galleryslider',
								'value' => 'on'
							)
						),
					)
				);
				if ($query_gallery->have_posts()) : ?>
					<div class="slider">
						<ul class="slides">
							<?php while ($query_gallery->have_posts()) : $query_gallery->the_post(); ?>
								<li>
									<?php if(get_the_post_thumbnail($post->ID,'gallery-home4')){
										echo get_the_post_thumbnail($post->ID,'gallery-home4');
									} else{
										echo '<img src="http://placehold.it/1920x590/ece6d9/ece6d9&amp;text=No+image" alt>';
									}?>
									<div class="text">
										<h2><?php the_title(); ?></h2>
										<div class="string">
											<?php echo ale_trim_excerpt(16); ?>
										</div>
										<a href="<?php the_permalink(); ?>" class="button-arrow"><?php _e('See more', 'aletheme'); ?></a>
									</div>
								</li>
							<?php endwhile; ?>
						</ul>
					</div>

					<div class="carousel">
						<ul class="slides">
							<?php while ($query_gallery->have_posts()) : $query_gallery->the_post(); ?>
								<li>
									<?php if(get_the_post_thumbnail($post->ID,'gallery-home41')){
										echo get_the_post_thumbnail($post->ID,'gallery-home41');
									} else{
										echo '<img src="http://placehold.it/480x193/ece6d9/8d7a65&amp;text=No+image" alt>';
									}?>
								</li>
							<?php endwhile; ?>
						</ul>
					</div>
				<?php endif; wp_reset_query();?>
			</div>
		<?php } elseif(ale_get_meta('displayhome4slider') == 'simple'){ ?>
			<div class="homeslider flexslider">
				<ul class="slides">
					<?php $slider = ale_sliders_get_slider(ale_get_option('homeslugfull'));  ?>
					<?php if($slider):?>
						<?php foreach ($slider['slides'] as $slide) : ?>
							<li>
								<?php if ($slide['image']) : ?>
									<img src="<?php echo esc_url($slide['image']); ?>" alt="<?php echo $slide['title']; ?>" />
								<?php endif; ?>
								<div class="text wrapper">
									<?php if($slide['title']){ echo '<h2>'.esc_attr($slide['title']).'</h2>'; } ?>
									<h3><?php echo esc_attr($slide['description']); ?></h3>
									<?php if($slide['url']){ ?><a class="button-arrow" href="<?php echo esc_url($slide['url']); ?>"><?php } ?>
										<?php _e('See more','aletheme'); ?>
										<?php if($slide['url']){ ?></a><?php } ?>
								</div>
							</li>
						<?php endforeach; ?>
					<?php endif;?>
				</ul>
			</div>
		<?php }  ?>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome4about')!="off"): ?>
		<section class="home-4-about">
			<div class="wrapper clearfix">
				<div class="col-4">
					<?php if(ale_get_meta('home4aboutimage')){
						echo '<img src="' . esc_url(ale_get_meta('home4aboutimage')) . '" alt>';
					} else {
						echo '<img src="http://placehold.it/389x674/ece6d9/8d7a65" alt>';
					} ?>
				</div>
				<div class="col-8">
					<h2><?php echo esc_attr(ale_get_meta('home4abouttitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('home4aboutdesc')); ?></p>
					<?php $tabs_meta = get_post_meta($post->ID, 'ale_tabs_details', true);
					if ( $tabs_meta ) : ?>
						<div class="about-accordion">
							<?php foreach ( $tabs_meta as $field ) {?>
								<h3><i class="fa fa-caret-right yellow-color"></i><?php if ($field['title_tabs'] != '') echo esc_attr( $field['title_tabs'] );  ?></h3>
								<div class="text">
									<p><?php if($field['text_tabs'] != '') echo esc_attr( $field['text_tabs'] ); ?></p>
								</div>
							<?php } ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome4table')!="off"): ?>
		<?php $table_meta = get_post_meta($post->ID, 'ale_table_details', true);
		if ( $table_meta ) : ?>
			<section class="home-4-table brown-bg">
				<?php if(ale_get_meta('home4tablebg')){ ?>
					<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_meta('home4tablebg')); ?>');"></div>
				<?php } ?>

				<div class="wrapper">
					<h2><?php echo esc_attr(ale_get_meta('home4home4tabletitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('home4tabledesc')); ?></p>
					<div class="scroll-pane">
						<table>
							<tr>
								<td>
									<?php _e('Time', 'aletheme'); ?>
									<i class="fa fa-caret-down"></i>
								</td>

								<td>
									<?php _e('Monday', 'aletheme'); ?>
								</td>
								
								<td>
									<?php _e('Tuesday', 'aletheme'); ?>
								</td>
								
								<td>
									<?php _e('Wednesday', 'aletheme'); ?>
								</td>
								
								<td>
									<?php _e('Thursday', 'aletheme'); ?>
								</td>
								
								<td>
									<?php _e('Friday', 'aletheme'); ?>
								</td>
							</tr>
							<?php foreach ( $table_meta as $field ) {?>
								<tr>
									<td>
										<?php if ($field['time'] != '') echo esc_attr( $field['time'] );  ?>
									</td>

									<td>
										<?php if ($field['monday'] != '') echo esc_attr( $field['monday'] );  ?>
									</td>
									
									<td>
										<?php if ($field['tuesday'] != '') echo esc_attr( $field['tuesday'] );  ?>
									</td>
									
									<td>
										<?php if ($field['wednesday'] != '') echo esc_attr( $field['wednesday'] );  ?>
									</td>
									
									<td>
										<?php if ($field['thursday'] != '') echo esc_attr( $field['thursday'] );  ?>
									</td>
									
									<td>
										<?php if ($field['friday'] != '') echo esc_attr( $field['friday'] );  ?>
									</td>
								</tr>
							<?php } ?>
						</table>
					</div>
				</div>
			</section>
		<?php endif; ?>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome4news')!="off"): ?>
		<section class="home-4-news">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('home4newstitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('home4newsdesc')); ?></p>
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_meta('home4newscount'));
				$query_news = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'news',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				$news_count = 0;
				if ($query_news->have_posts()) : ?>
					<div class="slider">
						<ul class="slides">
							<?php while ($query_news->have_posts()) : $query_news->the_post(); $news_count++;
								if($news_count%3==1) echo '<li class="clearfix">';?>
									<article>
										<a href="<?php the_permalink() ?>">
											<?php if(get_the_post_thumbnail($post->ID,'news-home4')){
												echo get_the_post_thumbnail($post->ID,'news-home4');
											} else{
												echo '<img src="http://placehold.it/343x172/ece6d9/8d7a65&amp;text=No+image" alt>';
											}?>
											<span class="overlay">
												<i class="fa fa-arrow-right"></i>
											</span>
										</a>
										<span class="date">
											<?php the_time('j'); ?>
											<span><?php the_time('M Y'); ?></span>
										</span>
										<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
										<div class="string">
											<?php echo ale_trim_excerpt(20); ?>
										</div>
										<span class="comments"><?php _e('Comments', 'aletheme1'); $comments_count = wp_count_comments($post->ID);
										echo ': ' . $comments_count->total_comments; ?></span>
									</article>
								<?php if($news_count%3==0) echo '</li>';
							endwhile; ?>
						</ul>
					</div>
				<?php endif; wp_reset_query();?>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome4history')!="off"):
		$history_meta = get_post_meta($post->ID, 'ale_history_details', true);
		if ( $history_meta ) : ?>
			<section class="home-4-history">
				<div class="wrapper">
					<h2><span><?php echo esc_attr(ale_get_meta('home4historytitle')); ?></span><?php echo esc_attr(ale_get_meta('home4historytitle2')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('home4historydesc')); ?></p>
					<div class="items">
						<?php foreach ( $history_meta as $field ) {?>
							<article class="clearfix">
								<div class="text">
									<h3><?php if ($field['date'] != '') echo esc_attr( $field['date'] );  ?><span><i class="fa fa-circle"></i></span></h3>
									<h4><?php if($field['title'] != '') echo esc_attr( $field['title'] ); ?></h4>
									<p><?php if($field['text'] != '') echo esc_attr( $field['text'] ); ?></p>
								</div>
							</article>
						<?php } ?>
					</div>
				</div>
			</section>
		<?php endif;
	endif; ?>
	
	<?php if(ale_get_meta('displayhome4text')!="off"): ?>
		<section class="home-4-text">
			<div class="wrapper">
				<h3><?php echo esc_attr(ale_get_meta('home4texttitle1')) ?></h3>
				<h2><?php echo esc_attr(ale_get_meta('home4texttitle2')) ?></h2>
				<div class="story">
					<?php if (have_posts()) : while (have_posts()) : the_post();
						the_content();
					endwhile; endif; wp_reset_query();?>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome4partners')!="off"):
		if(ale_get_meta('home4partnersimage1')||ale_get_meta('home4partnersimage2')||ale_get_meta('home4partnersimage3')||ale_get_meta('home4partnersimage4')||ale_get_meta('home4partnersimage5')||ale_get_meta('home4partnersimage6')): ?>
			<div class="home-4-partners">
				<div class="wrapper">
					<?php if(ale_get_meta('home4partnersimage1')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('home4partnerslink1')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('home4partnersimage1')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('home4partnersimage2')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('home4partnerslink2')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('home4partnersimage2')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('home4partnersimage3')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('home4partnerslink3')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('home4partnersimage3')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('home4partnersimage4')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('home4partnerslink4')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('home4partnersimage4')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('home4partnersimage5')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('home4partnerslink5')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('home4partnersimage5')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('home4partnersimage6')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('home4partnerslink6')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('home4partnersimage6')); ?>" alt>
						</a>
					<?php } ?>
				</div>
			</div>
		<?php endif;
	endif; ?>
<?php get_footer(); ?>