<?php 
/**
 * Template Name: Template Home 3
 */
get_header(); ?>

	<?php if(ale_get_meta('displayhome3slider')!="off"): ?>
		<?php if(ale_get_meta('displayhome3slider')=='on'){ ?>
			<div class="home-3-events">
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_meta('home3slidercount'));
				$query_events = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'events',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_events->have_posts()) : ?>
					<ul class="slides">
						<?php while ($query_events->have_posts()) : $query_events->the_post();
							if(ale_get_meta('eventssliderimage')){ ?>
							<li>
								<img src="<?php echo esc_url(ale_get_meta('eventssliderimage')); ?>" alt="<?php the_title(); ?>">
								<div class="text clearfix">
									<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
									<div class="string">
										<?php echo ale_trim_excerpt(5); ?>
									</div>
								</div>
								<?php if(ale_get_meta('eventsdate')&&ale_get_meta('eventstime1')): ?>
									<div class="countdown-block">
										<div class="hidden-date" data-hidden="<?php echo esc_attr(ale_get_meta('eventsdate')) . ' ' . esc_attr(ale_get_meta('eventstime1')); ?>"></div>
										<div class="day-block">
											<p class="days">00</p>
											<p class="timeRefDays"><?php _e('Days', 'aletheme'); ?></p>
										</div>
										<div class="colon">:</div>
										<div class="hours-block">
											<p class="hours">00</p>
											<p class="timeRefHours"><?php _e('Hours', 'aletheme'); ?></p>
										</div>
										<div class="colon">:</div>
										<div class="minutes-block">
											<p class="minutes">00</p>
											<p class="timeRefMinutes"><?php _e('Minutes', 'aletheme'); ?></p>
										</div>
										<div class="colon">:</div>
										<div class="seconds-block">
											<p class="seconds">00</p>
											<p class="timeRefSeconds"><?php _e('Seconds', 'aletheme'); ?></p>
										</div>
									</div>
								<?php endif; ?>
							</li>
							<?php } ?>
						<?php endwhile; ?>
					</ul>
				<?php endif; wp_reset_query();?>
			</div>
		<?php } elseif(ale_get_meta('displayhome3slider')=='simple'){ ?>
			<div class="homeslider flexslider">
				<ul class="slides">
					<?php $slider = ale_sliders_get_slider(ale_get_option('homeslugfull'));  ?>
					<?php if($slider):?>
						<?php foreach ($slider['slides'] as $slide) : ?>
							<li>
								<?php if ($slide['image']) : ?>
									<img src="<?php echo esc_url($slide['image']); ?>" alt="<?php echo $slide['title']; ?>" />
								<?php endif; ?>
								<div class="text wrapper">
									<?php if($slide['title']){ echo '<h2>'.esc_attr($slide['title']).'</h2>'; } ?>
									<h3><?php echo esc_attr($slide['description']); ?></h3>
									<?php if($slide['url']){ ?><a class="button-arrow" href="<?php echo esc_url($slide['url']); ?>"><?php } ?>
										<?php _e('See more','aletheme'); ?>
										<?php if($slide['url']){ ?></a><?php } ?>
								</div>
							</li>
						<?php endforeach; ?>
					<?php endif;?>
				</ul>
			</div>
		<?php } ?>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome3info')!="off"): ?>
		<div class="wrapper home-3-info clearfix">
			<article class="item">
				<div class="text">
					<h3><?php echo esc_attr(ale_get_meta('home3infodesc1')); ?></h3>
					<h2><?php echo esc_attr(ale_get_meta('home3infotitle1')); ?></h2>
					<ul>
						<?php if(ale_get_meta('home3infoline11')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline11')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline12')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline12')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline13')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline13')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline14')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline14')); ?></li>
						<?php } ?>
					</ul>
					<p><?php echo esc_attr(ale_get_meta('home3infoprice1')); ?><span><i>/</i><?php _e('month', 'aletheme'); ?></span></p>
				</div>
				<div class="shadow"></div>
			</article>

			<hr>

			<article class="item">
				<div class="text">
					<h3><?php echo esc_attr(ale_get_meta('home3infodesc2')); ?></h3>
					<h2><?php echo esc_attr(ale_get_meta('home3infotitle2')); ?></h2>
					<ul>
						<?php if(ale_get_meta('home3infoline21')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline21')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline22')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline22')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline23')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline23')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline24')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline24')); ?></li>
						<?php } ?>
					</ul>
					<p><?php echo esc_attr(ale_get_meta('home3infoprice2')); ?><span><i>/</i><?php _e('month', 'aletheme'); ?></span></p>
				</div>
				<div class="shadow"></div>
			</article>

			<hr>

			<article>
				<div class="text">
					<h3><?php echo esc_attr(ale_get_meta('home3infodesc3')); ?></h3>
					<h2><?php echo esc_attr(ale_get_meta('home3infotitle3')); ?></h2>
					<ul>
						<?php if(ale_get_meta('home3infoline31')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline31')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline32')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline32')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline33')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline33')); ?></li>
						<?php } ?>

						<?php if(ale_get_meta('home3infoline34')){ ?>
							<li><i class="fa fa-check yellow-color"></i><?php echo esc_attr(ale_get_meta('home3infoline34')); ?></li>
						<?php } ?>
					</ul>
					<p><?php echo esc_attr(ale_get_meta('home3infoprice3')); ?><span><i>/</i><?php _e('month', 'aletheme'); ?></span></p>
				</div>
				<div class="shadow"></div>
			</article>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome3testimonials')!="off"): ?>
		<section class="home-3-testimonials">
			<?php if(ale_get_meta('home3testimonialsbg')){ ?>
				<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_meta('home3testimonialsbg')); ?>');"></div>
			<?php } ?>
			<div class="wrapper clearfix">
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_meta('home3testimonialscount'));
				$query_testimonials = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'testimonials',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_testimonials->have_posts()) : ?>
					<div class="slider col-4">
						<ul class="slides">
							<?php while ($query_testimonials->have_posts()) : $query_testimonials->the_post(); ?>
								<li>
									<div class="image">
										<?php if(get_the_post_thumbnail($post->ID,'testimonials-home3')){
											echo get_the_post_thumbnail($post->ID,'testimonials-home3');
										} else{
											echo '<img src="http://placehold.it/78x78/ece6d9/8d7a65&amp;text=No+image" alt>';
										}?>
									</div>
									<div class="text">
										<h3><?php the_title(); ?></h3>
										<?php if(ale_get_meta('testimonialscourse')){ ?>
											<span><?php _e('Course', 'aletheme'); echo ': "' . esc_attr(ale_get_meta('testimonialscourse')); ?>"</span>
										<?php } ?>
									</div>
									<hr>
									<blockquote><i class="fa fa-quote-left"></i><?php echo ale_trim_excerpt(20); ?></blockquote>
									<p><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' ago'; ?></p>
								</li>
							<?php endwhile; ?>
						</ul>
					</div>
				<?php endif; wp_reset_query();?>
				<div class="col-5">
					<h2><?php echo esc_attr(ale_get_meta('home3testimonialstitle')); ?></h2>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome3twitter')!="off"): ?>
		<div class="home-3-twitter">
			<div class="wrapper clearfix">
				<div class="twitter-block col-9"></div>
				<div class="col-3">
				<?php if(ale_get_option('twiname')): ?>
					<div class="button-box">
						<a href="https://twitter.com/<?php echo esc_attr(ale_get_option('twiname')); ?>" class="twitter-follow-button" data-show-count="false" data-size="large"><?php _e('Follow','aletheme'); ?> @<?php echo esc_attr(ale_get_option('twiname')); ?></a>
						<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
					</div>
				<?php endif; ?>
				</div>
			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome3gallery')!="off"): ?>
		<section class="home-3-gallery clearfix">
			<div class="col-5 clearfix">
				<div class="text">
					<h2><?php echo esc_attr(ale_get_meta('home3gallerytitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('home3gallerydesc')); ?></p>
					<a href="<?php echo get_post_type_archive_link('gallery');?>" class="button-grey"><?php _e('See more', 'aletheme'); ?></a>
				</div>
			</div>

			<div class="col-7 grid-system clearfix">
				<?php
				wp_reset_query();
				$gallery_count = 0;
				$query_gallery = new WP_Query(
					array(
						'posts_per_page' => 10,
						'post_type' => 'gallery',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_gallery->have_posts()) : while ($query_gallery->have_posts()) : $query_gallery->the_post(); $gallery_count++; ?>
				<div class="grid-item image<?php if($gallery_count == 1 || $gallery_count == 10){
						echo ' medium';
					} elseif ($gallery_count == 5) {
						echo ' big';
					}?>">
					<?php if($gallery_count == 1 || $gallery_count == 10){
						if(get_the_post_thumbnail($post->ID,'gallery-home31')){
							echo get_the_post_thumbnail($post->ID,'gallery-home31');
						} else{
							echo '<img src="http://placehold.it/484x242/ece6d9/8d7a65&amp;text=No+image" alt>';
						}
					} elseif($gallery_count == 5){
						if(get_the_post_thumbnail($post->ID,'gallery-home33')){
							echo get_the_post_thumbnail($post->ID,'gallery-home33');
						} else{
							echo '<img src="http://placehold.it/484x484/ece6d9/8d7a65&amp;text=No+image" alt>';
						}
					} else{
						if(get_the_post_thumbnail($post->ID,'gallery-home32')){
							echo get_the_post_thumbnail($post->ID,'gallery-home32');
						} else{
							echo '<img src="http://placehold.it/242x242/ece6d9/8d7a65&amp;text=No+image" alt>';
						}
					}?>
					<a href="<?php the_permalink(); ?>"><i class="fa fa-plus"></i></a>
				</div>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome3blog')!="off"): ?>
		<section class="home-3-blog">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('home3blogtitle')); ?> <a href="<?php $posts_page_url = get_page_uri(get_option( 'page_for_posts')); echo home_url().'/' .$posts_page_url; ?>"><?php echo esc_attr(ale_get_meta('home3bloglink')); ?><i class="fa fa-angle-right"></i></a></h2>
				<?php
				wp_reset_query();
				$query_blog = new WP_Query(
					array(
						'posts_per_page' => 3,
						'post_type' => 'post',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_blog->have_posts()) : ?>
					<div class="items clearfix">
						<?php while ($query_blog->have_posts()) : $query_blog->the_post(); ?>
							<article>
								<h3><?php the_title(); ?></h3>
								<div class="string">
									<?php echo ale_trim_excerpt(16); ?>
								</div>
								<span><?php the_time('j F  Y');?></span>
								<span><i class="fa fa-comment"></i><?php $comments_count = wp_count_comments($post->ID); echo $comments_count->total_comments; ?></span>
								<a href="<?php the_permalink(); ?>"></a>
							</article>
						<?php endwhile; ?>
					</div>
				<?php endif; wp_reset_query();?>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome3subscribe')!="off"): ?>
		<div class="home-3-subscribe">
			<?php if(shortcode_exists('sbscrbr_form')): ?>
				<div class="subscribe clearfix">
					<p><?php _e('Subscribe to our newsletters', 'aletheme'); ?>:</p>
					<?php echo strip_tags(do_shortcode('[sbscrbr_form]'), '<form><input>'); ?>
				</div>
			<?php endif; ?>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome3people')!="off"): ?>
		<section class="home-3-people">
			<div class="text clearfix">
				<div class="inner">
					<h2><?php echo esc_attr(ale_get_meta('home3peopletitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('home3peopledesc')); ?></p>
				</div>
			</div>

			<div class="slider">
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_meta('home3memberscount'));
				$query_members = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'members',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_members->have_posts()) : ?>
					<ul class="slides">
						<?php while ($query_members->have_posts()) : $query_members->the_post(); ?>
							<li>
								<?php if(get_the_post_thumbnail($post->ID,'members-home3')){
									echo get_the_post_thumbnail($post->ID,'members-home3');
								} else{
									echo '<img src="http://placehold.it/371x509/ece6d9/8d7a65&amp;text=No+image" alt>';
								}?>
								<div class="post-text">
									<h3><?php the_title(); ?></h3>
									<p><?php echo esc_attr(ale_get_meta('memberspost')); ?></p>
								</div>
								<a href="<?php the_permalink(); ?>"></a>
							</li>
						<?php endwhile; ?>
					</ul>
				<?php endif; wp_reset_query();?>
			</div>
		</section>
	<?php endif; ?>
<?php get_footer(); ?>