<?php 
/**
 * Template Name: Template Home 2
 */
get_header(); ?>

	<?php if(ale_get_meta('displayhome2slider')!="off"): ?>
		<?php if(ale_get_meta('displayhome2slider')=='on'){ ?>
			<div class="home-2-events">
					<?php
					wp_reset_query();
					$count = esc_attr(ale_get_meta('home2slidercount'));
					$query_events = new WP_Query(
						array(
							'posts_per_page' => $count,
							'post_type' => 'events',
							'ignore_sticky_posts' => 1,
							'post__not_in' => get_option('sticky_posts')
						)
					);
					if ($query_events->have_posts()) : ?>
						<ul class="slides">
							<?php while ($query_events->have_posts()) : $query_events->the_post();
								if(ale_get_meta('eventssliderimage')){ ?>
								<li>
									<img src="<?php echo esc_attr(ale_get_meta('eventssliderimage')); ?>" alt="<?php the_title(); ?>">
									<div class="text clearfix">
										<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										<div class="col-4 string">
											<?php echo ale_trim_excerpt(30); ?>
										</div>
										<div class="col-8">
											<?php $events_meta = get_post_meta($post->ID, 'ale_links_details', true);
											if ( $events_meta ) : ?>
												<ul class="links clearfix">
													<?php foreach ( $events_meta as $field ) {?>
														<li>
															<a href="<?php if ($field['url'] != '') echo esc_url( $field['url'] );  ?>">
																<i class="fa fa-angle-right"></i><?php if($field['text'] != '') echo esc_attr( $field['text'] ); ?>
															</a>
														</li>
													<?php } ?>
												</ul>
											<?php endif; ?>
										</div>
									</div>
								</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php endif; wp_reset_query();?>
				</div>
		<?php } elseif(ale_get_meta('displayhome2slider') == 'simple'){ ?>
			<div class="homeslider flexslider">
				<ul class="slides">
					<?php $slider = ale_sliders_get_slider(ale_get_option('homeslugfull'));  ?>
					<?php if($slider):?>
						<?php foreach ($slider['slides'] as $slide) : ?>
							<li>
								<?php if ($slide['image']) : ?>
									<img src="<?php echo esc_url($slide['image']); ?>" alt="<?php echo $slide['title']; ?>" />
								<?php endif; ?>
								<div class="text wrapper">
									<?php if($slide['title']){ echo '<h2>'.esc_attr($slide['title']).'</h2>'; } ?>
									<h3><?php echo esc_attr($slide['description']); ?></h3>
									<?php if($slide['url']){ ?><a class="button-arrow" href="<?php echo esc_url($slide['url']); ?>"><?php } ?>
										<?php _e('See more','aletheme'); ?>
										<?php if($slide['url']){ ?></a><?php } ?>
								</div>
							</li>
						<?php endforeach; ?>
					<?php endif;?>
				</ul>
			</div>
		<?php } ?>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome2courses')!="off"): ?>
		<section class="home-2-course">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('home2coursestitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('home2coursesdesc')); ?></p>
				<div class="items clearfix">
					<?php
					wp_reset_query();
					$query_course = new WP_Query(
						array(
							'posts_per_page' => 4,
							'post_type' => 'course',
							'ignore_sticky_posts' => 1,
							'post__not_in' => get_option('sticky_posts')
						)
					);
					if ($query_course->have_posts()) : while ($query_course->have_posts()) : $query_course->the_post(); ?>
						<article>
							<a href="<?php the_permalink(); ?>"><?php if(get_the_post_thumbnail($post->ID,'course-home2')){
								echo get_the_post_thumbnail($post->ID,'course-home2');
							} else{
								echo '<img src="http://placehold.it/256x167/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?></a>
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						</article>
					<?php endwhile; endif; wp_reset_query();?>
				</div>
				<hr>
				<p><?php echo esc_attr(ale_get_meta('home2coursestext')); ?></p>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome2librarycat')!="off"): ?>
		<section class="home-2-library-category clearfix">
			<div class="image">
				<?php if(ale_get_meta('home2librarycatimage')){
					echo '<img src="'.esc_url(ale_get_meta('home2librarycatimage')).'" alt>';
				} else{
					echo '<img src="http://placehold.it/1098x606/ece6d9/8d7a65" alt>';
				} ?>
			</div>

			<div class="text">
				<hr>
				<h2><?php echo esc_attr(ale_get_meta('home2librarycattitle')); ?></h2>
				<?php $args = array(
					'type'                     => 'library',
					'child_of'                 => 0,
					'parent'                   => 0,
					'orderby'                  => 'name',
					'order'                    => 'ASC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => 7,
					'taxonomy'                 => 'library-category',
					'pad_counts'               => false );

				$categories = get_categories( $args );
				if(isset($categories) && !empty($categories)){
					echo '<ul class="categories">';
					foreach($categories as $cat){ ?>
						<li><a href="<?php echo esc_url(get_term_link($cat)); ?>"><?php echo esc_attr($cat->name); ?></a></li>
					<?php }
					echo '</ul>';
				}?>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome2library')!="off"): ?>
		<section class="home-2-library">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('home2librarytitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('home2librarydesc')); ?></p>
				<?php
				wp_reset_query();
				$query_library = new WP_Query(
					array(
						'posts_per_page' => 2,
						'post_type' => 'library',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_library->have_posts()) : ?>
					<div class="items clearfix">
						<?php while ($query_library->have_posts()) : $query_library->the_post(); ?>
						<article>
							<?php if(get_the_post_thumbnail($post->ID,'library-home2')){
								echo get_the_post_thumbnail($post->ID,'library-home2');
							} else{
								echo '<img src="http://placehold.it/529x216/ece6d9/8d7a65&amp;text=No+image" alt>';
							} ?>
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						</article>
						<?php endwhile; ?>
					</div>
				<?php  endif; wp_reset_query(); ?>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome2blockquote')!="off"): ?>
		<section class="home-2-blockqoute brown-bg">
			<?php if(ale_get_meta('home2blockquotebg')){
				echo '<div class="background-image" style="background-image: url('.esc_url(ale_get_meta('home2blockquotebg')).');"></div>';
			} ?>

			<div class="wrapper">
				<blockquote>
					<i class="fa fa-quote-right"></i>
					<h2><?php echo esc_attr(ale_get_meta('home2blockquotetitle')); ?></h2>
					<hr>
					<p><?php echo esc_attr(ale_get_meta('home2blockquotetext')); ?></p>
				</blockquote>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome2news')!="off"): ?>
		<div class="home-2-news wrapper clearfix">
			<?php
			wp_reset_query();
			$query_news = new WP_Query(
				array(
					'posts_per_page' => 6,
					'post_type' => 'news',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts')
				)
			);
			$count = 1;
			if ($query_news->have_posts()) : ?>
				<section class="news-block col-6">
					<h2><?php echo esc_attr(ale_get_meta('home2newstitle')); ?></h2>
					<div class="items">
						<?php while ($query_news->have_posts()) : $query_news->the_post(); $count++;
							if($count%2==0){echo '<div class="two-in-one clearfix">';}
						?>
							<article>
								<h3><a href="<?php the_permalink(); ?>" class="brown-color"><?php the_title(); ?></a></h3>
								<div class="string">
									<?php echo ale_trim_excerpt(20); ?>
								</div>

								<span class="date">
									<?php the_time('j F Y'); ?>
								</span>

								<span class="comments">
									<?php _e('Comments', 'aletheme');
									$comments_count = wp_count_comments($post->ID);
									echo ': ' . $comments_count->total_comments; ?>
								</span>
							</article>
						<?php if($count%2==1){echo '</div>';}
						endwhile; ?>
					</div>
				</section>
			<?php endif; wp_reset_query();?>

			<section class="video-block col-6">
				<h2><?php echo esc_attr(ale_get_meta('home2videoabouttitle')); ?></h2>
				<div class="image">
					<?php if(ale_get_meta('home2videoaboutimage')){
						echo '<img src="'.esc_url(ale_get_meta('home2videoaboutimage')).'" alt>';
					} else{
						echo '<img src="http://placehold.it/525x317/ece6d9/8d7a65" alt>';
					} ?>
					<div class="overlay">
						<span>
							<i class="fa fa-play"></i>
						</span>
					</div>
				</div>

				<div class="pop-up video-show">
					<div class="video-inner">
						<div class="exit">x</div>
						<?php echo wp_oembed_get(esc_url(ale_get_meta('home2videoaboutvideo')),array('width'=>'100%','height'=>'600px')); ?>
					</div>
				</div>

				<?php if(shortcode_exists('sbscrbr_form')): ?>
					<div class="subscribe">
						<p><?php _e('Subscribe to our newsletters', 'aletheme'); ?>:</p>
						<?php echo strip_tags(do_shortcode('[sbscrbr_form]'), '<form><input>'); ?>
					</div>
				<?php endif; ?>
			</section>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome2blog')!="off"): ?>
		<div class="home-2-blog clearfix">
			<?php
			wp_reset_query();
			$query_blog = new WP_Query(
				array(
					'posts_per_page' => 6,
					'post_type' => 'post',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts')
				)
			);
			if ($query_blog->have_posts()) : while ($query_blog->have_posts()) : $query_blog->the_post(); ?>
				<div class="article col-2">
					<?php if(get_the_post_thumbnail($post->ID,'post-home2')){
						echo get_the_post_thumbnail($post->ID,'post-home2');
					} else{
						echo '<img src="http://placehold.it/320x168/ece6d9/8d7a65&amp;text=No+image" alt>';
					} ?>
					<a href="<?php the_permalink(); ?>"><i class="fa fa-plus"></i></a>
				</div>
			<?php endwhile; endif; wp_reset_query();?>
		</div>
	<?php endif; ?>
<?php get_footer(); ?>