<?php 
/**
 * Template Name: Template Home 1
 */
get_header(); ?>
	<?php if(ale_get_meta('displayhome1library')!="off"): ?>
		<section class="home-1-library-filter" <?php if(ale_get_meta('home1librarybg')){ echo 'style="background-image: url('.esc_url(ale_get_meta('home1librarybg')).');"';} ?>>
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('home1librarytitle1')); ?></h2>
				<h3><?php echo esc_attr(ale_get_meta('home1librarytitle2')); ?></h3>
				<p><?php echo esc_attr(ale_get_meta('home1librarydesc')); ?></p>
				<div class="filter">
					<form method="post" action="<?php echo home_url(); ?>/library">
						<input type="search" placeholder="Title of the book" id="library_title" name="library_title">

						<select class="dropdown" id="library_genre" name="library_genre">
							<option value="<?php _e('Genre', 'aletheme'); ?>" class="label"><?php _e('Genre', 'aletheme'); ?></option>
							<?php ale_advance_hierarchical_options('library-category'); ?>
						</select>

						<select class="dropdown" id="library_year" name="library_year">
							<option value="<?php _e('Years', 'aletheme'); ?>" class="label"><?php _e('Years', 'aletheme'); ?></option>
							<?php
							wp_reset_query();
							$args = array(
								'post_type' => 'library',
								'posts_per_page' => -1,
								'sortby' => 'name',
								'meta_key' => 'ale_libraryyear',
								'orderby' => 'meta_value',
								'order' => 'DESC'
							);

							$library_years = new WP_Query($args);
							$temp_year = array();

							if($library_years->have_posts()) : while($library_years->have_posts()) : $library_years->the_post();

								$id= $library_years->post->ID;
								$lab_year = get_post_meta($id, 'ale_libraryyear', true);

								if(!in_array($lab_year, $temp_year)){
									array_push($temp_year, $lab_year); ?>
										<option value="<?php echo esc_attr($lab_year); ?>"><?php echo esc_attr($lab_year); ?></option>
								<?php }

								?>

							<?php endwhile; endif; wp_reset_query(); ?>
						</select>
						
						<div class="form-button">
							<input type="submit" value="<?php _e('Search', 'aletheme'); ?>">
						</div>
					</form>
				</div>
			</div>
		</section>
	<?php endif; ?>
	
	<?php if(ale_get_meta('displayhome1information')=="below"): ?>
		<div class="home-1-below-info">
			<div class="info">
				<div class="wrapper clearfix">
					<div class="col-3 city">
						<span class="fa fa-map-marker"></span>
						<a id="GeoAPI" class="city__selectedCity"></a>
					</div>
					<div class="col-9 data clearfix">
						<?php global $user_ID, $user_identity; get_currentuserinfo();
						if(get_option('users_can_register')){ ?>
							<div class="registration">
								<?php if (!$user_ID) { ?>
									<span><?php _e('Login', 'aletheme'); ?></span>
									<span>/</span>
									<?php if(isset($_GET['register']) and $_GET['register']=="true"){ ?>
										<span><?php _e('Check Email', 'aletheme'); ?></span>
									<?php } else { ?>
										<span><?php _e('Register', 'aletheme'); ?></span>
									<?php } ?>
								<?php } else{ ?>
									<a href="<?php echo wp_logout_url('index.php'); ?>"><?php _e('Logout', 'aletheme'); ?></a>
									<span>/</span>
									<?php if (current_user_can('manage_options')) { ?>
										<a class="profile" href="<?php admin_url(); ?>"><?php _e('Admin', 'aletheme'); ?></a>
									<?php } else { ?>
										<a class="profile" href="<?php admin_url(); ?>/profile.php"><?php _e('Profile', 'aletheme'); ?></a>
									<?php } ?>
								<?php } ?>
							</div>
							<?php ale_part('login-form'); ?>
						<?php } ?>
						<div class="email"><i class="fa fa-envelope"></i><span><?php echo esc_attr(ale_get_option('headeremail')); ?></span></div>
						<div class="phone"><i class="fa fa-phone"></i><span><?php echo esc_attr(ale_get_option('headernum')); ?></span></div>
					</div>
				</div>
			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome1about')!="off"): ?>
		<div class="home-1-blog">
			<div class="wrapper">
				<article>
					<div class="article clearfix">
						<div class="my-col-5">
							<img src="<?php if(ale_get_meta('home1aboutimage1')){
								echo esc_url(ale_get_meta('home1aboutimage1'));
							} else{
								echo 'http://placehold.it/429x271/ece6d9/8d7a65';
							} ?>" alt>
							<img src="<?php if(ale_get_meta('home1aboutimage2')){
								echo esc_url(ale_get_meta('home1aboutimage2'));
							} else{
								echo 'http://placehold.it/429x271/ece6d9/8d7a65';
							} ?>" alt>
						</div>
						<div class="my-col-3">
							<img src="<?php if(ale_get_meta('home1aboutimage3')){
								echo esc_url(ale_get_meta('home1aboutimage3'));
							} else{
								echo 'http://placehold.it/271x541/ece6d9/8d7a65';
							} ?>" alt>
							</div>
						<div class="my-col-4">
							<h2><?php echo esc_attr(ale_get_meta('home1abouttitle')); ?></h2>
							<blockquote>
								<?php echo esc_attr(ale_get_meta('home1aboutblockquote')); ?>
							</blockquote>
							<p class="brown-color"><?php echo esc_attr(ale_get_meta('home1abouttext')); ?></p>
							<a href="<?php echo esc_url(ale_get_meta('home1aboutlink')); ?>" class="button-grey"><?php _e('Read More', 'aletheme'); ?></a>
						</div>
					</div>
					<div class="shadow"></div>
				</article>
			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome1information')!="off"): ?>
		<div class="home-1-info">
			<div class="wrapper clearfix">
				<article class="col-2">
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('home1informationicon1')); ?> yellow-color"></i>
					<h3><?php echo esc_attr(ale_get_meta('home1informationtitle1')); ?></h3>
					<p class="brown-color"><?php echo esc_attr(ale_get_meta('home1informationtext1')); ?></p>
				</article>

				<article class="col-2">
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('home1informationicon2')); ?> yellow-color"></i>
					<h3><?php echo esc_attr(ale_get_meta('home1informationtitle2')); ?></h3>
					<p class="brown-color"><?php echo esc_attr(ale_get_meta('home1informationtext2')); ?></p>
				</article>

				<article class="col-2">
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('home1informationicon3')); ?> yellow-color"></i>
					<h3><?php echo esc_attr(ale_get_meta('home1informationtitle3')); ?></h3>
					<p class="brown-color"><?php echo esc_attr(ale_get_meta('home1informationtext3')); ?></p>
				</article>

				<article class="col-2">
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('home1informationicon4')); ?> yellow-color"></i>
					<h3><?php echo esc_attr(ale_get_meta('home1informationtitle4')); ?></h3>
					<p class="brown-color"><?php echo esc_attr(ale_get_meta('home1informationtext4')); ?></p>
				</article>
			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome1description')!="off"): ?>
		<section class="home-1-description" <?php if(ale_get_meta('home1descriptionbg')){
			echo ' style="background-image: url('.esc_url(ale_get_meta('home1descriptionbg')).');"';
		} ?>>
			<div class="wrapper clearfix">
				<div class="col-5">
					<h2><?php echo esc_attr(ale_get_meta('home1descriptiontitle')); ?></h2>
					<hr class="yellow-bg">
					<blockquote class="yellow-color">
						<?php echo esc_attr(ale_get_meta('home1descriptionblockquote')); ?>
					</blockquote>
				</div>
				<div class="col-7 story">
					<?php if (have_posts()) : while (have_posts()) : the_post();
						the_content();
					endwhile; endif; wp_reset_query();?>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayhome1people')!="off"):
		wp_reset_query();
		$count = esc_attr(ale_get_meta('home1peoplecount'));
		$query_members = new WP_Query(
			array(
				'posts_per_page' => $count,
				'post_type' => 'members',
				'ignore_sticky_posts' => 1,
				'post__not_in' => get_option('sticky_posts')
			)
		);
		$members_count = 0;
		if ($query_members->have_posts()) :?>
		<section class="home-1-people">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('home1peopletitle')); ?></h2>
				<div class="slider">
					<ul class="slides">
						<?php while ($query_members->have_posts()) : $query_members->the_post(); $members_count++;
						if($members_count%3==1){echo '<li class="clearfix">';}?>
							<article>
								<div class="image">
									<?php if(get_the_post_thumbnail($post->ID,'members-home1')){
										echo get_the_post_thumbnail($post->ID,'members-home1');
									} else{
										echo '<img src="http://placehold.it/65x65/ece6d9/8d7a65&amp;text=No+image" alt>';
									}?>
								</div>

								<div class="text">
									<h3 class="brown-color"><?php the_title(); ?></h3>
									<span class="post brown-color"><?php echo esc_attr(ale_get_meta('memberspost')); ?></span>
								</div>

								<div class="overlay">
									<div class="vert-align">
										<?php if(ale_get_meta('memberssocialtwi')): ?>
											<a href="<?php echo esc_url(ale_get_meta('memberssocialtwi')); ?>" class="yellow-color">
												<i class="fa fa-twitter"></i>
											</a>
										<?php endif; ?>

										<?php if(ale_get_meta('memberssocialfb')): ?>
											<a href="<?php echo esc_url(ale_get_meta('memberssocialfb')); ?>" class="yellow-color">
												<i class="fa fa-facebook"></i>
											</a>
										<?php endif; ?>

										<?php if(ale_get_meta('memberssocialin')): ?>
											<a href="<?php echo esc_url(ale_get_meta('memberssocialin')); ?>" class="yellow-color">
												<i class="fa fa-linkedin"></i>
											</a>
										<?php endif; ?>
									</div>
									<a href="<?php the_permalink(); ?>"></a>
								</div>
							</article>
						<?php if($members_count%3==0){echo '</li>';} endwhile; ?>
					</ul>
				</div>
			</div>
		</section>
		<?php endif;
	endif; wp_reset_query(); ?>

	<?php if(ale_get_meta('displayhome1catalogue')!="off"): ?>
		<section class="home-1-catalogue yellow-bg">
			<?php if(ale_get_meta('home1cataloguebg')){
				echo '<div class="background-image" style="background-image: url('.esc_url(ale_get_meta('home1cataloguebg')).');"></div>';
			} ?>
			<div class="wrapper clearfix">
				<div class="my-col-5">
					<h2><?php echo esc_attr(ale_get_meta('home1cataloguetitle')); ?></h2>
					<?php
					$args = array(
						'type'                     => 'library',
						'child_of'                 => 0,
						'parent'                   => '',
						'orderby'                  => 'name',
						'order'                    => 'ASC',
						'hide_empty'               => 0,
						'hierarchical'             => 1,
						'exclude'                  => '',
						'include'                  => '',
						'number'                   => '',
						'title_li'           	   => 0	,
						'taxonomy'                 => 'library-category',
						'pad_counts'               => false );
					echo '<ul class="library-category-list">';
					wp_list_categories($args);
					echo '</ul>';
					?>
				</div>
				<div class="my-col-7">
					<div class="books">
						<div class="items scroll-pane">
							<?php
							wp_reset_query();
							$query_library = new WP_Query(
								array(
									'posts_per_page' => -1,
									'post_type' => 'library',
									'ignore_sticky_posts' => 1,
									'post__not_in' => get_option('sticky_posts'),
									'taxonomy' => 'library-category'
								)
							);
							if ($query_library->have_posts()) : while ($query_library->have_posts()) : $query_library->the_post(); ?>
								<a href="<?php the_permalink(); ?>" class="item clearfix"><span class="title"><?php the_title(); ?></span><span class="author"><?php echo esc_attr(ale_get_meta('libraryauthor')); ?></span></a>
							<?php endwhile; endif; wp_reset_query();?>
						</div>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<section class="home-1-sundries">
		<div class="wrapper clearfix">
			<div class="my-col-3">
				<h2><?php echo esc_attr(ale_get_meta('home1sundriestitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('home1sundriestext')); ?></p>
				<div class="quicklinks">
					<ul class="clearfix">
						<?php if(ale_get_option('quicklinkstext1')){ ?>
							<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink1')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext1')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext2')){ ?>
						<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink2')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext2')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext3')){ ?>
						<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink3')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext3')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext4')){ ?>
						<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink4')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext4')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext5')){ ?>
						<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink5')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext5')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext6')){ ?>
						<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink6')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext6')); ?></a></li>
						<?php } ?>
					</ul>
				</div>
			</div>
			<div class="my-col-5">
				<?php if(ale_get_meta('home1sundriesimage')){
					echo '<img src="'.esc_url(ale_get_meta('home1sundriesimage')).'" alt>';
				} else{
					echo '<img src="http://placehold.it/431x552/ece6d9/8d7a65" alt>';
				} ?>
			</div>
			<div class="my-col-4">
				<div class="image">
					<?php if(ale_get_meta('home1sundriespersonphoto')){
						echo '<img src="'.esc_url(ale_get_meta('home1sundriespersonphoto')).'" alt>';
					} else{
						echo '<img src="http://placehold.it/148x216/ece6d9/8d7a65" alt>';
					} ?>
					<div class="text">
						<h3><?php echo esc_attr(ale_get_meta('home1sundriespersonname')); ?></h3>
						<span><?php echo esc_attr(ale_get_meta('home1sundriespersonpost')); ?></span>
					</div>
				</div>

				<blockquote>
					<?php echo esc_attr(ale_get_meta('home1sundriespersondescription')); ?>
				</blockquote>

				<?php if(ale_get_meta('home1sundriespersonsign')){
					echo '<img src="'.esc_url(ale_get_meta('home1sundriespersonsign')).'" alt>';
				} else{
					echo '<img src="http://placehold.it/92x30/ece6d9/8d7a65" alt>';
				} ?>
			</div>
		</div>
	</section>
<?php get_footer(); ?>