<?php
/**
 * Template Name: Template Gallery 2
 */
get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageblog')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageblog')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<div class="page-content template-gallery-2">
			<?php get_breadcrumbs(); ?>

			<h1 class="page-title"><?php wp_title("", true); ?></h1>
			<div class="clearfix">
				<?php
				wp_reset_query();
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count = esc_attr(ale_get_meta('gallery2count'));
				$query_gallery = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'gallery',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				$count_gallery = 0;
				if ($query_gallery->have_posts()) : while ($query_gallery->have_posts()) : $query_gallery->the_post(); $count_gallery++; ?>
					<div class="article col-4">
						<?php if(get_the_post_thumbnail($post->ID,'gallery-two1')){
							echo get_the_post_thumbnail($post->ID,'gallery-two1');
						} else{
							echo '<img src="http://placehold.it/411x516/ece6d9/8d7a65&amp;text=No+picture" alt>';
						} ?>
						<div class="overlay">
							<h2><?php the_title(); ?></h2>
							<div class="string">
								<?php echo ale_trim_excerpt(2); ?>
							</div>
						</div>
						<div class="gradient"></div>
						<a href="<?php the_permalink() ?>"></a>
					</div>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
			<div class="pagination no-border">
				<?php ale_custom_page_links($query_gallery); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>