<?php
/**
 * Template Name: Template Gallery 1
 */
get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageblog')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageblog')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<div class="page-content template-gallery-1">
			<?php get_breadcrumbs(); ?>

			<h1 class="page-title"><?php wp_title("", true); ?></h1>
			<div class="clearfix grid-system">
				<?php
				wp_reset_query();
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count = esc_attr(ale_get_meta('gallery1count'));
				$query_gallery = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'gallery',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				$count_gallery = 0;
				if ($query_gallery->have_posts()) : while ($query_gallery->have_posts()) : $query_gallery->the_post(); $count_gallery++; ?>
					<div class="article grid-item <?php if($count_gallery == 1||$count_gallery == 6||$count_gallery == 9||$count_gallery == 12){
						echo 'big';
					}?>">
						<a href="<?php the_permalink() ?>">
							<?php if(($count_gallery == 1)||($count_gallery == 9)||($count_gallery == 12)){
								if(get_the_post_thumbnail($post->ID,'gallery-one2')){
									echo get_the_post_thumbnail($post->ID,'gallery-one2');
								} else{
									echo '<img src="http://placehold.it/432x234/ece6d9/8d7a65&amp;text=No+image" alt>';
								}
							} elseif($count_gallery == 6){
								if(get_the_post_thumbnail($post->ID,'gallery-one3')){
									echo get_the_post_thumbnail($post->ID,'gallery-one3');
								} else{
									echo '<img src="http://placehold.it/432x468/ece6d9/8d7a65&amp;text=No+image" alt>';
								}
							} else{
								if(get_the_post_thumbnail($post->ID,'gallery-one1')){
									echo get_the_post_thumbnail($post->ID,'gallery-one1');
								} else{
									echo '<img src="http://placehold.it/216x234/ece6d9/8d7a65&amp;text=No+image" alt>';
								}
							} ?>
							<span class="overlay">
								<i class="fa fa-plus"></i>
							</span>
						</a>
					</div>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
			<div class="pagination no-border">
				<?php ale_custom_page_links($query_gallery); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>