<?php 
/**
 * Template Name: Template Contact
 */
// send contact
if (isset($_POST['contact'])) {
	$error = ale_send_contact($_POST['contact']);
}
get_header();
?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagecontact')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagecontact')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>

	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8 contact-page">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>
			<div class="col-12">
				<div class="col-6">
					<ul>
						<li class="address"><?php echo esc_attr(ale_get_meta('contactaddress')); ?></li>
						<li class="telephone"><span><?php _e('Telephone', 'aletheme'); ?>:</span> <?php echo esc_attr(ale_get_meta('contacttelephone')); ?></li>
						<li class="fax"><span><?php _e('Fax', 'aletheme'); ?>:</span> <?php echo esc_attr(ale_get_meta('contactfax')); ?></li>
						<li class="email"><span><?php _e('Email', 'aletheme'); ?>:</span> <i><?php echo esc_attr(ale_get_meta('contactemail')); ?></i></li>
					</ul>
				</div>

				<div class="col-6">
					<h2><?php echo esc_attr(ale_get_meta('contacblock2title')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('contacblock2text')); ?></p>
					<a href="<?php echo esc_url(ale_get_meta('contacblock2link')); ?>"><?php echo esc_attr(ale_get_meta('contacblock2linktext')); ?></a>
				</div>
			</div>

			<div class="col-12 block2 clearfix">
				<div class="col-6">
					<h2><?php echo esc_attr(ale_get_meta('contacblock3title')); ?></h2>
					<ul>
						<li class="address"><?php echo esc_attr(ale_get_meta('contacblock3address')); ?></li>
						<li class="telephone"><span><?php _e('Telephone', 'aletheme'); ?>:</span> <?php echo esc_attr(ale_get_meta('contacblock3telephone')); ?></li>
						<li class="fax"><span><?php _e('Fax', 'aletheme'); ?>:</span> <?php echo esc_attr(ale_get_meta('contacblock3fax')); ?></li>
						<li class="email"><span><?php _e('Email', 'aletheme'); ?>:</span> <i><?php echo esc_attr(ale_get_meta('contacblock3email')); ?></i></li>
					</ul>
				</div>

				<div class="col-6">
					<h2><?php echo esc_attr(ale_get_meta('contacblock4title')); ?></h2>
					<ul>
						<li class="address"><?php echo esc_attr(ale_get_meta('contacblock4address')); ?></li>
						<li class="telephone"><span><?php _e('Telephone', 'aletheme'); ?>:</span> <?php echo esc_attr(ale_get_meta('contacblock4telephone')); ?></li>
						<li class="fax"><span><?php _e('Fax', 'aletheme'); ?>:</span> <?php echo esc_attr(ale_get_meta('contacblock4fax')); ?></li>
						<li class="email"><span><?php _e('Email', 'aletheme'); ?>:</span> <i><?php echo esc_attr(ale_get_meta('contacblock4email')); ?></i></li>
					</ul>
				</div>
			</div>

			<div class="col-12">
				<form method="post" action="<?php the_permalink();?>" class="form">
					<?php if (isset($error) && isset($error['msg'])) : ?>
						<p class="error"><?php echo esc_attr($error['msg']); ?></p>
					<?php endif; ?>
					<label><?php _e('Name', 'aletheme'); ?> *:
						<input name="contact[name]" type="text" placeholder="Your Name" value="<?php echo isset($_POST['contact']['name']) ? $_POST['contact']['name'] : ''?>" required="required" id="contact-form-name" />
					</label>
					<label><?php _e('Email', 'aletheme'); ?> *:
						<input name="contact[email]" type="email" placeholder="Email" value="<?php echo isset($_POST['contact']['email']) ? $_POST['contact']['email'] : ''?>" required="required" id="contact-form-email" />
					</label>
					<label><?php _e('Message', 'aletheme'); ?> *:</label>
						<textarea name="contact[message]"  placeholder="Your Message" id="contact-form-message" required="required"><?php echo isset($_POST['contact']['message']) ? $_POST['contact']['message'] : ''?></textarea>
						<input type="submit" class="submit" value="<?php _e('Submit', 'aletheme')?>"/>
					<?php wp_nonce_field() ?>
					<?php if (isset($_GET['success'])) : ?>
						<p class="success"><?php _e('Thank you for your message!', 'aletheme')?></p>
					<?php endif; ?>
				</form>
			</div>
		</div>
	</div>
	<?php $adre = esc_attr(ale_get_meta('contactaddress')); echo do_shortcode('[ale_map address="'.$adre.'" width="100%" height="269px"]'); ?>
<?php get_footer(); ?>