<?php
/**
 * Template Name: Template Blog 2
 */
get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageblog')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageblog')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>
			<div class="template-blog-2">
				<?php
				wp_reset_query();
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count = esc_attr(ale_get_meta('blog2count'));
				$query_blog = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'post',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				$count_blog = 0;
				if ($query_blog->have_posts()) : while ($query_blog->have_posts()) : $query_blog->the_post(); $count_blog++; ?>
					<article>
						<a href="<?php the_permalink() ?>">
							<?php if(get_the_post_thumbnail($post->ID,'news-home4')){
								echo get_the_post_thumbnail($post->ID,'news-home4');
							} else{
								echo '<img src="http://placehold.it/343x172/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?>
							<span class="overlay">
								<i class="fa fa-arrow-right"></i>
							</span>
						</a>
						<span class="date">
							<?php the_time('j'); ?>
							<span><?php the_time('M Y'); ?></span>
						</span>
						<h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
						<div class="string">
							<?php echo ale_trim_excerpt(14); ?>
						</div>
						<span class="comments"><?php _e('Comments', 'aletheme1'); $comments_count = wp_count_comments($post->ID);
						echo ': ' . $comments_count->total_comments; ?></span>
					</article>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
			<div class="pagination no-border">
				<?php ale_custom_page_links($query_blog); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>