<?php
/**
 * Template Name: Template Blog 1
 */
get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageblog')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageblog')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>
			<div class="template-blog-1">
				<?php
				wp_reset_query();
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count = esc_attr(ale_get_meta('blog1count'));
				$query_blog = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'post',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				$count_blog = 0;
				if ($query_blog->have_posts()) : while ($query_blog->have_posts()) : $query_blog->the_post(); $count_blog++; ?>
					<?php if($count_blog%2==1){echo '<div class="section">'; } ?>
						<div class="article">
							<div class="image">
								<?php if(get_the_post_thumbnail($post->ID,'post-archive1')){
									echo get_the_post_thumbnail($post->ID,'post-archive1');
								} else{
									echo '<img src="http://placehold.it/323x318/ece6d9/8d7a65&amp;text=No+image" alt>';
								}?>

								<a href="<?php the_permalink(); ?>" class="link">
									<span><?php _e('plus', 'aletheme');?></span>
								</a>
								<div>
									<ul class="share">
										<li class="googleplus"><a href="<?php echo ale_get_share('goglp'); ?>" onclick="window.open(this.href, 'Share on Google plus', 'width=600,height=300'); return false"></a></li>
										<li class="tweeter"><a href="<?php echo ale_get_share('tweet'); ?>" onclick="window.open(this.href, 'Share on Tweeter', 'width=600,height=300'); return false"></a></li>
										<li class="facebook"><a href="<?php echo ale_get_share('fb'); ?>" onclick="window.open(this.href, 'Share on Facebook', 'width=600,height=300'); return false"></a></li>
									</ul>

									<ul class="data">
										<li class="admin"><?php echo get_the_author(); ?></li>
										<li class="comments"><?php $comments_count = wp_count_comments($post->ID); echo $comments_count->total_comments. ' com.'; ?></li>
										<li class="tags"><?php the_tags(''); ?></li>
									</ul>
								</div>
							</div>
							<h2><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h2>
							<span class="time"><?php the_time('j F Y'); ?></span>
							<span class="comments"> / <?php $comments_count = wp_count_comments($post->ID); echo 'Comments: ' . $comments_count->total_comments; ?></span>
							<div class="string">
								<?php echo ale_trim_excerpt(40); ?>
							</div>
						</div>
					<?php if($count_blog%2==0){echo '</div>'; } ?>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
			<div class="pagination no-border">
				<?php ale_custom_page_links($query_blog); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>