<?php
/**
 * Template Name: Template Admission
 */
get_header(); ?>
    <div class="featured-image">
        <?php
        if(ale_get_option('featuredimageadmission')){
            echo '<img src="'.esc_url(ale_get_option('featuredimageadmission')).'" alt>';
        } else{
            echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
        }?>
    </div>
    <div class="page-block wrapper clearfix">
        <?php get_sidebar(); ?>

        <div class="page-content col-8 admission-page">
            <?php get_breadcrumbs(); ?>

            <h1><?php wp_title("", true); ?></h1>

            <div class="story">
                <img src="<?php if(ale_get_meta('admissionimage')){
                    echo esc_url(ale_get_meta('admissionimage'));
                } else{
                    echo 'http://placehold.it/677x308/ece6d9/8d7a65';
                }?>" alt class="admission-image">

                <p><?php echo esc_attr(ale_get_meta('admissiontext')); ?></p>

                <?php if(ale_get_meta('displayadmissionlist') !="off"): ?>
                    <ul>
                        <li><?php echo esc_attr(ale_get_meta('admissionlist1')); ?></li>
                        <li><?php echo esc_attr(ale_get_meta('admissionlist2')); ?></li>
                        <li><?php echo esc_attr(ale_get_meta('admissionlist3')); ?></li>
                    </ul>
                <?php endif; ?>

                <?php if(ale_get_meta('displayadmissionaccordion') !="off"): ?>
                    <h2><?php echo esc_attr(ale_get_meta('admissionaccordiontitle')); ?></h2>

                    <div class="accordion">
                        <h3><?php echo esc_attr(ale_get_meta('admissionaccordiontitle1')); ?></h3>
                        <div class="text">
                            <p><?php echo esc_attr(ale_get_meta('admissionaccordiontext1')); ?></p>
                        </div>

                        <h3><?php echo esc_attr(ale_get_meta('admissionaccordiontitle2')); ?></h3>
                        <div class="text">
                            <p><?php echo esc_attr(ale_get_meta('admissionaccordiontext2')); ?></p>
                        </div>

                        <h3><?php echo esc_attr(ale_get_meta('admissionaccordiontitle3')); ?></h3>
                        <div class="text">
                            <p><?php echo esc_attr(ale_get_meta('admissionaccordiontext3')); ?></p>
                        </div>

                        <h3><?php echo esc_attr(ale_get_meta('admissionaccordiontitle4')); ?></h3>
                        <div class="text">
                            <p><?php echo esc_attr(ale_get_meta('admissionaccordiontext4')); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(ale_get_meta('displayadmissioncomments') !="off"): ?>
                    <hr>

                    <?php comments_template(); ?>
                <?php endif; ?>

                <?php if(ale_get_meta('displayadmissiontabs') !="off"): ?>
                    <hr>

                    <div class="tabs">
                        <ul>
                            <?php if(ale_get_meta('admissiontabstitle1')): ?><li><a href="#tabs-1"><?php echo esc_attr(ale_get_meta('admissiontabstitle1'));?></a></li><?php endif; ?>
                            <?php if(ale_get_meta('admissiontabstitle2')): ?><li><a href="#tabs-2"><?php echo esc_attr(ale_get_meta('admissiontabstitle2'));?></a></li><?php endif; ?>
                            <?php if(ale_get_meta('admissiontabstitle3')): ?><li><a href="#tabs-3"><?php echo esc_attr(ale_get_meta('admissiontabstitle3'));?></a></li><?php endif; ?>
                        </ul>

                        <?php if(ale_get_meta('admissiontabstitle1')): ?>
                            <div id="tabs-1">
                                <p><?php echo esc_attr(ale_get_meta('admissiontabstext1'));?></p>
                            </div>
                        <?php endif; ?>

                        <?php if(ale_get_meta('admissiontabstitle2')): ?>
                            <div id="tabs-2">
                                <p><?php echo esc_attr(ale_get_meta('admissiontabstext2'));?></p>
                            </div>
                        <?php endif; ?>

                        <?php if(ale_get_meta('admissiontabstitle3')): ?>
                            <div id="tabs-3">
                                <p><?php echo esc_attr(ale_get_meta('admissiontabstext3'));?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php get_footer(); ?>