<?php
/**
 * Template Name: Template About
 */
get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageabout')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageabout')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>

	<?php if(ale_get_meta('displayaboutcontent') !="off"): ?>
		<div class="page-block wrapper clearfix">
			<div class="our-college-sidebar col-4">
				<article>
					<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle1')); ?></h3>
					<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext1')); ?></p>
					<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink1')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext1')); ?><span></span></a>
				</article>

				<article>
					<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle2')); ?></h3>
					<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext2')); ?></p>
					<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink2')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext2')); ?><span></span></a>
				</article>

				<article>
					<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle3')); ?></h3>
					<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext3')); ?></p>
					<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink3')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext3')); ?><span></span></a>
				</article>
			</div>

			<div class="page-content col-8 about-page">
				<?php get_breadcrumbs(); ?>
				<section>
					<h1><?php echo esc_attr(ale_get_meta('aboutpagetitle')); ?></h1>
					<p><b><?php echo esc_attr(ale_get_meta('aboutpagetext')); ?></b></p>
					<p><?php echo esc_attr(ale_get_meta('aboutpagetext2')); ?></p>
					<div class="video">
						<div class="item">
							<?php if(ale_get_meta('aboutpagevideoimage')){
								echo '<img src="'.esc_url(ale_get_meta('aboutpagevideoimage')).'" alt>';
							} else{
								echo '<img src="http://placehold.it/588x320/ece6d9/8d7a65&amp;text=No+image" alt>';
							} ?>
							<div class="overlay"></div>
						</div>

						<?php if(ale_get_meta('aboutpagevideourl')): ?>
							<div class="popup">
								<div class="slider-wrapper">
									<div class="container">
										<?php echo wp_oembed_get(esc_url(ale_get_meta('aboutpagevideourl'))); ?>
										<div class="close"><i class="fa fa-times"></i></div>
									</div>
								</div>
							</div>
						<?php endif; ?>

						<div class="aside">
							<ul>
								<?php if(ale_get_meta('aboutpagevideogog')){ echo '<li class="googleplus"><a href="'.esc_url(ale_get_meta('aboutpagevideogog')).'" rel="external"></a></li>'; } ?>
								<?php if(ale_get_meta('aboutpagevideotwi')){ echo '<li class="twitter"><a href="'.esc_url(ale_get_meta('aboutpagevideotwi')).'" rel="external"></a></li>'; } ?>
								<?php if(ale_get_meta('aboutpagevideofb')){ echo '<li class="facebook"><a href="'.esc_url(ale_get_meta('aboutpagevideofb')).'" rel="external"></a></li>'; } ?>
							</ul>
						</div>
					</div>
				</section>

			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayabouthistorymission') !="off"): ?>
		<div class="page-block history-mission">
			<div class="wrapper clearfix">
				<section class="history-block col-6">
					<h2><?php echo esc_attr(ale_get_meta('abouthistorytitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('abouthistorytext')); ?></p>

					<div class="images clearfix">
						<div class="item col-4">
							<a href="<?php echo esc_url(ale_get_meta('abouthistorylink1')); ?>">
								<img src="<?php if(ale_get_meta('abouthistoryimage1')){
									echo esc_url(ale_get_meta('abouthistoryimage1'));
								} else{
									echo 'http://placehold.it/164x108/ece6d9/8d7a65&amp;text=No+image';
								} ?>" alt>
							</a>
						</div>

						<div class="item col-4">
							<a href="<?php echo esc_url(ale_get_meta('abouthistorylink2')); ?>">
								<img src="<?php if(ale_get_meta('abouthistoryimage2')){
									echo esc_url(ale_get_meta('abouthistoryimage2'));
								} else{
									echo 'http://placehold.it/164x108/ece6d9/8d7a65&amp;text=No+image';
								} ?>" alt>
							</a>
						</div>

						<div class="item col-4">
							<a href="<?php echo esc_url(ale_get_meta('abouthistorylink3')); ?>">
								<img src="<?php if(ale_get_meta('abouthistoryimage3')){
									echo esc_url(ale_get_meta('abouthistoryimage3'));
								} else{
									echo 'http://placehold.it/164x108/ece6d9/8d7a65&amp;text=No+image';
								} ?>" alt>
							</a>
						</div>
					</div>
				</section>

				<section class="mission-block col-6">
					<h2><?php echo esc_attr(ale_get_meta('aboutmissiontitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('aboutmissiontext')); ?></p>

					<div class="quicklinks">
						<ul class="clearfix">
							<?php if(ale_get_option('quicklinkstext1')){ ?>
								<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink1')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext1')); ?></a></li>
							<?php } ?>

							<?php if(ale_get_option('quicklinkstext2')){ ?>
								<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink2')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext2')); ?></a></li>
							<?php } ?>

							<?php if(ale_get_option('quicklinkstext3')){ ?>
								<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink3')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext3')); ?></a></li>
							<?php } ?>

							<?php if(ale_get_option('quicklinkstext4')){ ?>
								<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink4')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext4')); ?></a></li>
							<?php } ?>

							<?php if(ale_get_option('quicklinkstext5')){ ?>
								<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink5')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext5')); ?></a></li>
							<?php } ?>

							<?php if(ale_get_option('quicklinkstext6')){ ?>
								<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink6')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext6')); ?></a></li>
							<?php } ?>
						</ul>
					</div>
				</section>
			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayaboutfeaturedprofessor')!="off"): ?>
		<section class="featured-professor-box wrapper">
			<h2><?php echo esc_attr(ale_get_meta('aboutfeaturedprofessortitle')); ?></h2>
			<?php
			$count = esc_attr(ale_get_meta('aboutfeaturedprofessorcount'));
			$query_academics = new WP_Query(
				array(
					'posts_per_page' => $count,
					'post_type' => 'academics',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts'),
					'orderby' => 'comment_count'
				)
			);
			if ($query_academics->have_posts()) : while ($query_academics->have_posts()) : $query_academics->the_post(); ?>
				<article class="clearfix">
					<div class="image">
						<?php if(get_the_post_thumbnail($post->ID,'academics-thumba')){
							echo get_the_post_thumbnail($post->ID,'academics-thumba');
						} else{
							echo '<img src="http://placehold.it/244x214/ece6d9/8d7a65&amp;text=No+image" alt>';
						}?>
						<div class="social">
							<?php if(ale_get_meta('academicssocialinst')){ ?>
								<a href="<?php echo esc_url(ale_get_meta('academicssocialinst')); ?>" class="instagram"><i class="fa fa-instagram"></i></a>
							<?php } ?>

							<?php if(ale_get_meta('academicssocialtwi')){ ?>
							<a href="<?php echo esc_url(ale_get_meta('academicssocialtwi')); ?>" class="twitter"><i class="fa fa-twitter"></i></a>
							<?php } ?>

							<?php if(ale_get_meta('academicssocialfb')){ ?>
							<a href="<?php echo esc_url(ale_get_meta('academicssocialfb')); ?>" class="facebook"><i class="fa fa-facebook"></i></a>
							<?php } ?>
						</div>
					</div>

					<div class="text">
						<h3><?php the_title(); ?></h3>
						<div class="string">
							<?php echo ale_trim_excerpt(20); ?>
						</div>
						<a href="<?php the_permalink(); ?>" class="button"><?php _e('Enroll in a lecture', 'aletheme'); ?></a>
					</div>

					<?php $table_meta = get_post_meta($post->ID, 'ale_academic_table_details', true);
					if ( $table_meta ) : ?>
						<div class="table">
							<table>
								<tr>
									<td>
										<?php _e('Years', 'aletheme'); ?>
									</td>
									<?php foreach ( $table_meta as $field ) { ?>
										<td>
											<?php if ($field['year'] != '') echo esc_attr( $field['year'] );  ?>
										</td>
									<?php } ?>
								</tr>
								<tr>
									<td>
										<?php _e('Monday', 'aletheme'); ?>
									</td>
									<?php foreach ( $table_meta as $field ) { ?>
										<td>
											<?php if ($field['monday'] != '') echo esc_attr( $field['monday'] );  ?>
										</td>
									<?php } ?>
								</tr>
								<tr>
									<td>
										<?php _e('Tuesday', 'aletheme'); ?>
									</td>
									<?php foreach ( $table_meta as $field ) { ?>
										<td>
											<?php if ($field['tuesday'] != '') echo esc_attr( $field['tuesday'] );  ?>
										</td>
									<?php } ?>
								</tr>
								<tr>
									<td>
										<?php _e('Wednesday', 'aletheme'); ?>
									</td>
									<?php foreach ( $table_meta as $field ) { ?>
										<td>
											<?php if ($field['wednesday'] != '') echo esc_attr( $field['wednesday'] );  ?>
										</td>
									<?php } ?>
								</tr>
								<tr>
									<td>
										<?php _e('Thursday', 'aletheme'); ?>
									</td>
									<?php foreach ( $table_meta as $field ) { ?>
										<td>
											<?php if ($field['thursday'] != '') echo esc_attr( $field['thursday'] );  ?>
										</td>
									<?php } ?>
								</tr>
								<tr>
									<td>
										<?php _e('Friday', 'aletheme'); ?>
									</td>
									<?php foreach ( $table_meta as $field ) { ?>
										<td>
											<?php if ($field['friday'] != '') echo esc_attr( $field['friday'] );  ?>
										</td>
									<?php } ?>
								</tr>
							</table>
						</div>
					<?php endif; ?>
				</article>
			<?php endwhile; endif; wp_reset_query();?>
		</section>
	<?php endif; ?>
<?php get_footer(); ?>