<?php
/**
 * Template Name: Template About 1
 */
get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageabout')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageabout')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>

	<div class="page-block wrapper about-box-1">
		<?php get_breadcrumbs(); ?>
		<h1><?php wp_title("", true); ?></h1>
	</div>

	<?php if(ale_get_meta('displayabout1info')!="off"): ?>
		<div class="about-1-info">
			<?php if(ale_get_meta('about1infobg')){ ?>
				<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_meta('about1infobg')); ?>');"></div>
			<?php } ?>
			<div class="wrapper clearfix">
				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('about1infoicon1')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('about1infotitle1')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('about1infotext1')); ?></p>
				</article>

				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('about1infoicon2')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('about1infotitle2')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('about1infotext2')); ?></p>
				</article>

				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('about1infoicon3')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('about1infotitle3')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('about1infotext3')); ?></p>
				</article>

				<article>
					<i class="fa fa-<?php echo esc_attr(ale_get_meta('about1infoicon4')); ?> yellow-color"></i>
					<h2><?php echo esc_attr(ale_get_meta('about1infotitle4')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('about1infotext4')); ?></p>
				</article>
			</div>
		</div>
	<?php endif; ?>

	<?php if(ale_get_meta('displayabout1about')!="off"): ?>
		<section class="about-1-about">
			<div class="wrapper clearfix">
				<div class="col-4">
					<?php if(ale_get_meta('about1aboutimage')){
						echo '<img src="' . esc_url(ale_get_meta('about1aboutimage')) . '" alt>';
					} else {
						echo '<img src="http://placehold.it/389x193/ece6d9/8d7a65" alt>';
					} ?>
				</div>
				<div class="col-8">
					<h2><?php echo esc_attr(ale_get_meta('about1abouttitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('about1aboutdesc')); ?></p>
					<?php $tabs_meta = get_post_meta($post->ID, 'ale_tabs_details', true);
					if ( $tabs_meta ) : ?>
						<div class="about-accordion">
							<?php foreach ( $tabs_meta as $field ) {?>
								<h3><i class="fa fa-caret-right yellow-color"></i><?php if ($field['title_tabs'] != '') echo esc_attr( $field['title_tabs'] );  ?></h3>
								<div class="text">
									<p><?php if($field['text_tabs'] != '') echo esc_attr( $field['text_tabs'] ); ?></p>
								</div>
							<?php } ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayabout1courses')!="off"): ?>
		<section class="about-1-course">
			<div class="wrapper">
				<h2><?php echo esc_attr(ale_get_meta('about1coursestitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('about1coursesdesc')); ?></p>
				<div class="items clearfix">
					<?php
					wp_reset_query();
					$query_course = new WP_Query(
						array(
							'posts_per_page' => 4,
							'post_type' => 'course',
							'ignore_sticky_posts' => 1,
							'post__not_in' => get_option('sticky_posts')
						)
					);
					if ($query_course->have_posts()) : while ($query_course->have_posts()) : $query_course->the_post(); ?>
						<article>
							<?php if(get_the_post_thumbnail($post->ID,'course-home2')){
								echo get_the_post_thumbnail($post->ID,'course-home2');
							} else{
								echo '<img src="http://placehold.it/256x167/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?>
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						</article>
					<?php endwhile; endif; wp_reset_query();?>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayabout1professors') !="off"): ?>
		<section class="about-1-professor">
			<?php if(ale_get_meta('about1featuredprofessorbg')){ ?>
				<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_meta('about1featuredprofessorbg')); ?>');"></div>
			<?php } ?>

			<div class="wrapper flexslider clearfix">
				<h2><?php echo esc_attr(ale_get_meta('about1featuredprofessortitle')); ?></h2>

				<ul class="slides">
					<?php
					wp_reset_query();
					$query_academics = new WP_Query(
						array(
							'posts_per_page' => 8,
							'post_type' => 'academics',
							'ignore_sticky_posts' => 1,
							'post__not_in' => get_option('sticky_posts')
						)
					);
					$count = 1;
					if ($query_academics->have_posts()) : while ($query_academics->have_posts()) : $query_academics->the_post();
						if($count%4==1){echo '<li>';}
						?>
						<article>
							<div class="item">
								<div class="social">
									<ul>
										<li><a href="<?php echo esc_url(ale_get_meta('academicssocialinstagram')); ?>" class="instagram"></a></li>
										<li><a href="<?php echo esc_url(ale_get_meta('academicssocialtwitter')); ?>" class="twitter"></a></li>
										<li><a href="<?php echo esc_url(ale_get_meta('academicssocialfacebook')); ?>" class="facebook"></a></li>
									</ul>
								</div>
								<a href="<?php the_permalink(); ?>">
									<?php
									if(get_the_post_thumbnail($post->ID,'academics-thumba')){
										echo get_the_post_thumbnail($post->ID,'academics-thumba');
									} else{
										echo '<img src="http://placehold.it/244x214/ece6d9/8d7a65&amp;text=No+image" alt>';
									}
									?>
								</a>
							</div>
							<h3><?php the_title();?></h3>
							<?php echo ale_trim_excerpt(14); ?>
						</article>
						<?php if($count%4==0){echo '</li>';} $count++;
					endwhile;  endif; wp_reset_query();?>
				</ul>
			</div>
		</section>
	<?php endif; ?>

	<?php if(ale_get_meta('displayabout1partners')!="off"):
		if(ale_get_meta('about1partnersimage1')||ale_get_meta('about1partnersimage2')||ale_get_meta('about1partnersimage3')||ale_get_meta('about1partnersimage4')||ale_get_meta('about1partnersimage5')||ale_get_meta('about1partnersimage6')): ?>
			<div class="about-1-partners">
				<h2><?php echo esc_attr(ale_get_meta('about1partnerstitle')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('about1partnerstext')); ?></p>
				<hr>
				<div class="wrapper">
					<?php if(ale_get_meta('about1partnersimage1')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('about1partnerslink1')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('about1partnersimage1')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('about1partnersimage2')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('about1partnerslink2')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('about1partnersimage2')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('about1partnersimage3')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('about1partnerslink3')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('about1partnersimage3')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('about1partnersimage4')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('about1partnerslink4')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('about1partnersimage4')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('about1partnersimage5')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('about1partnerslink5')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('about1partnersimage5')); ?>" alt>
						</a>
					<?php } ?>

					<?php if(ale_get_meta('about1partnersimage6')){ ?>
						<a href="<?php echo esc_url(ale_get_meta('about1partnerslink6')); ?>">
							<img src="<?php echo esc_url(ale_get_meta('about1partnersimage6')); ?>" alt>
						</a>
					<?php } ?>
				</div>
			</div>
		<?php endif;
	endif; ?>
<?php get_footer(); ?>