<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageblog')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageblog')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8 blog">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>
			<?php
			wp_reset_query();
			if (have_posts()) : while (have_posts()) : the_post(); ?>
				<div class="article">
					<div class="image">
						<?php if(get_the_post_thumbnail($post->ID,'post-single')){
							echo get_the_post_thumbnail($post->ID,'post-single');
						} else{
							echo '<img src="http://placehold.it/678x316/ece6d9/8d7a65&amp;text=No+image" alt>';
						}?>

						<a href="<?php the_permalink(); ?>" class="link">
							<span><?php _e('plus', 'aletheme');?></span>
						</a>
						<div>
							<ul class="share">
								<li class="googleplus"><a href="<?php echo ale_get_share('goglp'); ?>" onclick="window.open(this.href, 'Share on Google plus', 'width=600,height=300'); return false"></a></li>
								<li class="tweeter"><a href="<?php echo ale_get_share('tweet'); ?>" onclick="window.open(this.href, 'Share on Tweeter', 'width=600,height=300'); return false"></a></li>
								<li class="facebook"><a href="<?php echo ale_get_share('fb'); ?>" onclick="window.open(this.href, 'Share on Facebook', 'width=600,height=300'); return false"></a></li>
							</ul>

							<ul class="data">
								<li class="admin"><?php echo get_the_author(); ?></li>
								<li class="comments"><?php $comments_count = wp_count_comments($post->ID); echo $comments_count->total_comments. ' com.'; ?></li>
								<li class="tags"><?php the_tags(''); ?></li>
							</ul>
						</div>
					</div>
					<span class="date"><?php the_time('j'); ?><span><?php the_time('D Y'); ?></span></span>
					<h2><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h2>
					<?php echo ale_trim_excerpt(40); ?>
				</div>
			<?php endwhile;  endif; wp_reset_query();?>
			<div class="pagination">
				<?php ale_page_links(); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>