<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagemembers')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagemembers')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8 single story single-members-box">
			<?php get_breadcrumbs(); ?>

			<h1><?php _e('Members Details', 'aletheme'); ?></h1>

			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				<div class="article">
					<div class="clearfix">
						<div class="image">
							<?php if(get_the_post_thumbnail($post->ID,'members-single')){
								echo get_the_post_thumbnail($post->ID,'members-single');
							} else{
								echo '<img src="http://placehold.it/280x265/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?>
						</div>

						<div class="text">
							<h2><?php the_title(); ?></h2>
							<span class="post"><?php echo esc_attr(ale_get_meta('memberspost')); ?></span>
							<p class="description"><?php echo esc_attr(ale_get_meta('membersdesc')); ?></p>
							<div class="social">
								<?php if(ale_get_meta('memberssocialinst')){ ?>
									<a href="<?php echo esc_url(ale_get_meta('memberssocialinst')); ?>" class="instagram"><i class="fa fa-instagram"></i></a>
								<?php } ?>

								<?php if(ale_get_meta('memberssocialtwi')){ ?>
								<a href="<?php echo esc_url(ale_get_meta('memberssocialtwi')); ?>" class="twitter"><i class="fa fa-twitter"></i></a>
								<?php } ?>

								<?php if(ale_get_meta('memberssocialfb')){ ?>
								<a href="<?php echo esc_url(ale_get_meta('memberssocialfb')); ?>" class="facebook"><i class="fa fa-facebook"></i></a>
								<?php } ?>
							</div>
						</div>
					</div>

					<?php the_content();?>
					<?php wp_link_pages(); ?>

					<?php $table_meta = get_post_meta($post->ID, 'ale_table_details', true);
					if ( $table_meta ) : ?>
						<h3 class="table-title"><?php _e('Timetable', 'aletheme'); ?></h3>
						<div class="scroll-pane">
							<table>
								<tr>
									<td>
										<?php _e('Time', 'aletheme'); ?>
										<i class="fa fa-caret-down"></i>
									</td>

									<td>
										<?php _e('Monday', 'aletheme'); ?>
									</td>
									
									<td>
										<?php _e('Tuesday', 'aletheme'); ?>
									</td>
									
									<td>
										<?php _e('Wednesday', 'aletheme'); ?>
									</td>
									
									<td>
										<?php _e('Thursday', 'aletheme'); ?>
									</td>
									
									<td>
										<?php _e('Friday', 'aletheme'); ?>
									</td>
								</tr>
								<?php foreach ( $table_meta as $field ) {?>
									<tr>
										<td>
											<?php if ($field['time'] != '') echo esc_attr( $field['time'] );  ?>
										</td>

										<td>
											<?php if ($field['monday'] != '') echo esc_attr( $field['monday'] );  ?>
										</td>
										
										<td>
											<?php if ($field['tuesday'] != '') echo esc_attr( $field['tuesday'] );  ?>
										</td>
										
										<td>
											<?php if ($field['wednesday'] != '') echo esc_attr( $field['wednesday'] );  ?>
										</td>
										
										<td>
											<?php if ($field['thursday'] != '') echo esc_attr( $field['thursday'] );  ?>
										</td>
										
										<td>
											<?php if ($field['friday'] != '') echo esc_attr( $field['friday'] );  ?>
										</td>
									</tr>
								<?php } ?>
							</table>
						</div>
					<?php endif; ?>
				</div>
			<?php endwhile;  endif; wp_reset_query();?>

			<?php
			wp_reset_query();
			$query_course = new WP_Query(
				array(
					'posts_per_page' => -1,
					'post_type' => 'course',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts'),
					'paged' => $paged,
					'meta_query' => array(
						array(
							'key' => 'ale_coursemember',
							'value' => get_the_ID()
						)
					),
				)
			);
			if ($query_course->have_posts()) : ?>
				<div class="selected-course">
					<h3><?php _e('Courses', 'aletheme'); ?></h3>
					<div class="items">
						<?php while ($query_course->have_posts()) : $query_course->the_post(); ?>
							<article>
								<?php if(get_the_post_thumbnail($post->ID,'course-selected')){
									echo get_the_post_thumbnail($post->ID,'course-selected');
								} else{
									echo '<img src="http://placehold.it/308x177/ece6d9/8d7a65&amp;text=No+image" alt>';
								}?>
								<div class="course-text">
									<span class="duration">
										<?php echo esc_attr(ale_get_meta('courseadditionalduration')); ?>
									</span>
									<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
									<ul class="fields-list">
										<?php if(ale_get_meta('courseadditionalfield1')){ ?>
											<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield1')); ?></li>
										<?php } ?>

										<?php if(ale_get_meta('courseadditionalfield2')){ ?>
											<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield2')); ?></li>
										<?php } ?>

										<?php if(ale_get_meta('courseadditionalfield3')){ ?>
											<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield3')); ?></li>
										<?php } ?>

										<?php if(ale_get_meta('courseadditionalfield4')){ ?>
											<li><i class="fa fa-check"></i><?php echo esc_attr(ale_get_meta('courseadditionalfield4')); ?></li>
										<?php } ?>
									</ul>
									<span class="price">
										<?php echo esc_attr(ale_get_meta('courseadditionalprice')); ?>
										<span>/ <?php echo esc_attr(ale_get_meta('courseadditionaldate')); ?></span>
									</span>
								</div>
							</article>
						<?php endwhile; ?>
					</div>
				</div>
			<?php endif; wp_reset_query();?>
		</div>
	</div>
<?php get_footer(); ?>