<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagelibrary')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagelibrary')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8 single story">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>

			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				<?php $args = array(
					'post_type' => 'attachment',
					'numberposts' => -1,
					'post_status' => null,
					'order'				=> 'ASC',
					'orderby'			=> 'menu_order ID',
					'meta_query'		=> array(
						array(
							'key'		=> '_ale_hide_from_gallery',
							'value'		=> 0,
							'type'		=> 'DECIMAL',
						),
					),
					'post_parent' => $post->ID
				);
				$attachments = get_posts( $args ); ?>
				<div class="article">
					<div class="image">
						<?php if(get_the_post_thumbnail($post->ID,'library-single')){
							echo get_the_post_thumbnail($post->ID,'library-single');
						} else{
							echo '<img src="http://placehold.it/678x316/ece6d9/8d7a65&amp;text=No+image" alt>';
						}?>

						<?php if ( $attachments ) { ?>
							<span><?php _e('plus', 'aletheme');?></span>
						<?php } ?>
					</div>

					<div class="book-data">
						<span class="author"><i class="fa fa-user"></i> <?php _e('Author:','aletheme'); ?> <strong><?php echo ale_get_meta('libraryauthor'); ?></strong></span>
						<span class="year"><i class="fa fa-calendar"></i> <?php _e('Year:','aletheme'); ?> <strong><?php echo ale_get_meta('libraryyear'); ?></strong></span>
					</div>

					<div class="popup-slider">
						<div class="slider-wrapper">
							<div class="container">
								<div class="slider">
									<ul class="slides">
										<?php if ( $attachments ) {
											foreach ( $attachments as $attachment ) { ?>
												<li data-thumb="<?php echo $attachment->guid; ?>">
													<?php echo wp_get_attachment_image( $attachment->ID, 'library-big' ); ?>
												</li>
											<?php }
										} ?>
									</ul>
								</div>
								<div class="close"><i class="fa fa-times"></i></div>
							</div>
						</div>
					</div>
					<?php the_content();?>
					<?php wp_link_pages(); ?>
				</div>
			<?php endwhile;  endif; wp_reset_query();?>

			<?php comments_template(); ?>
		</div>
	</div>
<?php get_footer(); ?>                                                                                                                                                                                                                                                                                                                                 