<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageevents')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageevents')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<div class="page-content single story events-single-box">
			<?php get_breadcrumbs(); ?>

			<h1><?php the_title();?></h1>

			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				<div class="article">
					<div class="image">
						<?php $args = array(
							'post_type' => 'attachment',
							'numberposts' => -1,
							'post_status' => null,
							'order'             => 'ASC',
							'orderby'           => 'menu_order ID',
							'meta_query'        => array(
								array(
									'key'       => '_ale_hide_from_gallery',
									'value'     => 0,
									'type'      => 'DECIMAL',
								),
							),
							'post_parent' => $post->ID
						);
						$attachments = get_posts( $args );
						if ( $attachments ) { ?>
							<div class="slider">
								<ul class="slides">
									<?php foreach ( $attachments as $attachment ) { ?>
										<li data-thumb="<?php echo $attachment->guid; ?>">
											<?php echo wp_get_attachment_image( $attachment->ID, 'events-single' ); ?>
										</li>
									<?php } ?>
								</ul>
							</div>
						<?php } else{
							if(get_the_post_thumbnail($post->ID,'events-single')){
								echo get_the_post_thumbnail($post->ID,'events-single');
							} else{
								echo '<img src="http://placehold.it/1080x304/ece6d9/8d7a65&amp;text=No+image" alt>';
							}
						}?>
					</div>
					<div class="book-data cf">
						<div class="col-6">
							<span class="event-date"><i class="fa fa-calendar"></i> <?php _e('Event Date:','aletheme'); ?> <?php echo esc_attr(ale_get_meta('eventsdate')); ?></span><br /><br />
							<?php if(ale_get_meta('eventstime1')){ ?>
								<span class="time"><i class="fa fa-clock-o"></i> <?php _e('Time','aletheme'); ?> <?php echo esc_attr(ale_get_meta('eventstime1')) . ' - ' . esc_attr(ale_get_meta('eventstime2')); ?></span>
							<?php } ?><br /><br />
							<span class="event-adress"><i class="fa fa-map-marker"></i> <?php _e('Address:','aletheme'); ?> <?php echo esc_attr(ale_get_meta('eventsaddress')); ?></span>
						</div>
						<div class="col-6">
							<?php $events_meta = get_post_meta($post->ID, 'ale_links_details', true);
							if ( $events_meta ) : ?>

								<?php $i=0; foreach ( $events_meta as $field ) { $i++;?>
										<span><i class="fa fa-link"></i> <?php _e('Partner link:','aletheme'); ?> <a href="<?php if ($field['url'] != '') echo esc_url( $field['url'] );  ?>">
												<?php if($field['text'] != '') echo esc_attr( $field['text'] ); ?>
										</a></span>
										<?php if($i<count($events_meta)){ echo "<br /><br />";} ?>
								<?php } ?>

							<?php endif; ?>
						</div>
					</div>

					<?php if(ale_get_meta('departmensdesc')){ ?>
						<p class="description"><?php echo esc_attr(ale_get_meta('departmensdesc')); ?></p>
					<?php } ?>

					<?php the_content();?>
					<?php wp_link_pages(); ?>
					<?php $adre = esc_attr(ale_get_meta('eventsaddress')); echo do_shortcode('[ale_map address="'.$adre.'" width="100%" height="302px"]'); ?>
				</div>
			<?php endwhile;  endif; wp_reset_query();?>
			
			<?php comments_template(); ?>
		</div>
	</div>
<?php get_footer(); ?>