<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagedepartmens')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagedepartmens')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<div class="page-content single story departmens-single-box">
			<?php get_breadcrumbs(); ?>

			<h1><?php _e('Departmens', 'aletheme'); ?></h1>

			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				<div class="article">
					<div class="image">
						<?php $args = array(
							'post_type' => 'attachment',
							'numberposts' => -1,
							'post_status' => null,
							'order'				=> 'ASC',
							'orderby'			=> 'menu_order ID',
							'meta_query'		=> array(
								array(
									'key'		=> '_ale_hide_from_gallery',
									'value'		=> 0,
									'type'		=> 'DECIMAL',
								),
							),
							'post_parent' => $post->ID
						);
						$attachments = get_posts( $args );
						if ( $attachments ) { ?>
							<div class="slider">
								<ul class="slides">
									<?php foreach ( $attachments as $attachment ) { ?>
										<li data-thumb="<?php echo $attachment->guid; ?>">
											<?php echo wp_get_attachment_image( $attachment->ID, 'departmens-thumba' ); ?>
										</li>
									<?php } ?>
								</ul>
							</div>
						<?php } else{
							if(get_the_post_thumbnail($post->ID,'departmens-thumba')){
								echo get_the_post_thumbnail($post->ID,'departmens-thumba');
							} else{
								echo '<img src="http://placehold.it/1064x448/ece6d9/8d7a65&amp;text=No+image" alt>';
							}
						}?>
					</div>
					<h2><?php the_title(); ?></h2>

					<?php if(ale_get_meta('departmensdesc')){ ?>
						<p class="description"><?php echo esc_attr(ale_get_meta('departmensdesc')); ?></p>
					<?php } ?>

					<?php the_content();?>
					<?php wp_link_pages(); ?>
				</div>
			<?php endwhile;  endif; wp_reset_query();?>

			<div class="feauturedprofessor-box departmens-color">
				<section class="wrapper flexslider clearfix cf">
					<h3><?php _e('Featured professor', 'aletheme'); ?></h3>

					<ul class="slides cf">
						<?php
						wp_reset_query();
						$query_academics = new WP_Query(
							array(
								'posts_per_page' => -1,
								'post_type' => 'academics',
								'ignore_sticky_posts' => 1,
								'post__not_in' => get_option('sticky_posts'),
								'meta_query' => array(
									array(
										'key' => 'ale_academicsslider',
										'value' => 'on'
									)
								),
							)
						);
						$count = 1;
						if ($query_academics->have_posts()) : while ($query_academics->have_posts()) : $query_academics->the_post();
							if($count%4==1){echo '<li class="cf feat-slider">';}
							?>
							<article>
								<div class="item">
									<div class="social">
										<ul>
											<li><a href="<?php echo esc_url(ale_get_meta('academicssocialinstagram')); ?>" class="instagram"></a></li>
											<li><a href="<?php echo esc_url(ale_get_meta('academicssocialtwitter')); ?>" class="twitter"></a></li>
											<li><a href="<?php echo esc_url(ale_get_meta('academicssocialfacebook')); ?>" class="facebook"></a></li>
										</ul>
									</div>
									<a href="<?php the_permalink(); ?>">
										<?php
										if(get_the_post_thumbnail($post->ID,'academics-thumba')){
											echo get_the_post_thumbnail($post->ID,'academics-thumba');
										} else{
											echo '<img src="http://placehold.it/244x214/ece6d9/8d7a65&amp;text=No+image" alt>';
										}
										?>
									</a>
									<a href="<?php the_permalink(); ?>" class="button-figure">
										<?php _e('See more', 'aletheme'); ?>
										<span></span>
									</a>
								</div>
								<h4><?php the_title();?></h4>
								<?php echo ale_trim_excerpt(14); ?>
							</article>
							<?php if($count%4==0){echo '</li>';} $count++;
						endwhile;  endif; wp_reset_query();?>
					</ul>
				</section>
			</div>
		</div>
	</div>
<?php get_footer(); ?>