<?php get_header(); ?>
    <div class="featured-image">
        <?php
        if(ale_get_option('featuredimagecourse')){
            echo '<img src="'.esc_url(ale_get_option('featuredimagecourse')).'" alt>';
        } else{
            echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
        }?>
    </div>
    <div class="page-block wrapper clearfix">
        <?php get_sidebar(); ?>

        <div class="page-content col-8 single story">
            <?php get_breadcrumbs(); ?>

            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                <div class="article">
                    <div class="image">
                        <?php if(get_the_post_thumbnail($post->ID,'course-single')){
                            echo get_the_post_thumbnail($post->ID,'course-single');
                        } else{
                            echo '<img src="http://placehold.it/678x316/ece6d9/8d7a65&amp;text=No+image" alt>';
                        }?>
                    </div>
                    <div class="course-info-box cf">
                        <div class="date-section">
                            <?php echo esc_attr(ale_get_meta('courseadditionalprice')); ?>
                        </div>
                        <div class="content-section">
                            <h2><?php the_title(); ?></h2>
                            <?php if(ale_get_meta('coursestudentscount')){ ?><span class="students"><i class="fa fa-users"></i> <?php echo esc_attr(ale_get_meta('coursestudentscount')); ?></span><?php } ?>
                            <?php if(ale_get_meta('courselessonscount')){ ?><span class="lessons"><i class="fa fa-book"></i> <?php echo esc_attr(ale_get_meta('courselessonscount')); ?></span><?php } ?>
                            <?php if(ale_get_meta('courseadditionalduration')){ ?><span class="timehours"><i class="fa fa-clock-o"></i> <?php echo esc_attr(ale_get_meta('courseadditionalduration')); ?></span><?php } ?>
                        </div>
                        <div class="cf"></div><br /><br />
                        <p><?php echo esc_attr(ale_get_meta('coursepaymentdescription')); ?></p>

                        <?php

                        //PayPal Data
                        $payments_enabled = ale_get_option('enable_paypal');
                        $paypal_merchant_id = ale_get_option('merchant_email');
                        $enable_sandbox = ale_get_option('enable_sandbox');
                        $currency_code = ale_get_option('paypal_currency');

                        if (($payments_enabled == "1") && (!empty($paypal_merchant_id))) {
                            $payment_status = ale_get_meta('payment_status', true, $post->ID);
                            if ($payment_status == "Completed") {
                                echo '<div class="completed">'.__('Completed Payment', 'aletheme').'</div>';
                            } else {
                                ?>
                                <script
                                    src="<?php echo get_template_directory_uri() . "/js/libs/paypal-button.min.js?merchant=$paypal_merchant_id"; ?>"
                                    <?php
                                    if ($enable_sandbox == "1"){
                                    ?>data-env="sandbox"<?php
                                }
                                ?>
                                    data-callback="<?php echo get_template_directory_uri() . "/aletheme/paypal/ipn.php"; ?>"
                                    data-tax="0"
                                    data-shipping="0"
                                    data-currency="<?php echo $currency_code; ?>"
                                    data-amount="<?php echo preg_replace("/[^0-9,.]/", "", ale_get_meta('courseadditionalprice')); ?>"
                                    data-quantity="1"
                                    data-name="<?php the_title(); ?>"
                                    data-number="<?php echo $post->ID; ?>"
                                    data-button="paynow"
                                    ></script>
                            <?php
                            }
                        }
                        ?>

                    </div>
                    <?php the_content();?>
                    <?php wp_link_pages(); ?>
                    <div class="course-info-box paid-area cf">

                        <?php if(isset($_POST['paid-button'])){
                            if($_POST['paid-password']!=='' && $_POST['paid-password'] == ale_get_meta('courseprotectedpassword')){
                                echo ale_get_meta('protectedcontent');
                            } else {?>
                                <h3><?php _e('Paid Area','aletheme'); ?></h3>
                                <form method="post" action="<?php the_permalink(); ?>">
                                    <input type="text" name="paid-password" value="" />
                                    <input type="submit" name="paid-button" value="Unlock the content" /><br/><br/>
                                </form>
                                <?php echo _e('The password is wrong. Pay with PayPal and get the password via Email.','aletheme');
                            }
                        } else { ?>
                            <h3><?php _e('Paid Area','aletheme'); ?></h3>
                            <form method="post" action="<?php the_permalink(); ?>">
                                <input type="text" name="paid-password" value="" />
                                <input type="submit" name="paid-button" value="Unlock the content" /><br/><br/>
                            </form>
                        <?php } ?>
                    </div>
                </div>
            <?php endwhile;  endif; wp_reset_query();?>

            <?php if(ale_get_meta('gallerysectionshow') !="off"): ?>
                        <div class="searchcourse singlestaffs">
                            <section class="result">
                                <h2><?php _e('Course Gallery', 'aletheme'); ?></h2>
                                <div class="gallery-course cf">
                                    <?php $args = array(
                                        'post_type' => 'attachment',
                                        'numberposts' => -1,
                                        'post_status' => null,
                                        'order'             => 'ASC',
                                        'orderby'           => 'menu_order ID',
                                        'meta_query'        => array(
                                            array(
                                                'key'       => '_ale_hide_from_gallery',
                                                'value'     => 0,
                                                'type'      => 'DECIMAL',
                                            ),
                                        ),
                                        'post_parent' => $post->ID
                                    );
                                    $attachments = get_posts( $args ); ?>
                                    <?php if ( $attachments ) {
                                        foreach ( $attachments as $attachment ) { ?>
                                            <a rel="example_group" href="<?php echo esc_url($attachment->guid); ?>" title="<?php echo esc_attr($attachment->post_content); ?>"><?php echo wp_get_attachment_image( $attachment->ID, 'course-home2' ); ?></a>
                                        <?php }
                                    } ?>
                                </div>
                            </section>
                        </div>
            <?php endif; ?>

            <?php if(ale_get_meta('courcestaf')){ ?>
                <div class="searchcourse singlestaffs">
                    <section class="result">
                        <h2><?php _e('Staffs', 'aletheme'); ?></h2>
                        <div class="assigned-academics cf">
                        <?php $course_academics = get_post_meta($post->ID, 'ale_courcestaf');

                        if($course_academics){
                            foreach($course_academics as $academic) {
                                $academic_post = get_post($academic); ?>
                                <div class="article">
                                    <div class="item">
                                        <div class="social">
                                            <ul>
                                                <li><a href="<?php echo esc_url(ale_get_meta('academicssocialinst',true,$academic_post->ID)); ?>" class="instagram" target="_blank"></a></li>
                                                <li><a href="<?php echo esc_url(ale_get_meta('academicssocialtwi',true,$academic_post->ID)); ?>" class="twitter" target="_blank"></a></li>
                                                <li><a href="<?php echo esc_url(ale_get_meta('academicssocialfb',true,$academic_post->ID)); ?>" class="facebook" target="_blank"></a></li>
                                            </ul>
                                        </div>
                                        <a href="<?php echo get_post_permalink($academic_post->ID); ?>">
                                            <?php
                                            if(get_the_post_thumbnail($academic_post->ID,'academics-thumba')){
                                                echo get_the_post_thumbnail($academic_post->ID,'academics-thumba');
                                            } else{
                                                echo '<img src="http://placehold.it/244x214/ece6d9/8d7a65&amp;text=No+image" alt>';
                                            }
                                            ?>
                                        </a>

                                    </div>
                                    <h4><a href="<?php echo get_post_permalink($academic_post->ID); ?>"><?php echo get_the_title($academic_post->ID);?></a></h4>
                                    <p><?php echo esc_attr(ale_get_meta('academicsdesc',true,$academic_post->ID)); ?></p>
                                </div>
                            <?php }
                        }?>
                        </div>
                    </section>
                </div>
            <?php } ?>

            <?php comments_template(); ?>
        </div>
    </div>
<?php get_footer(); ?>