<?php get_header(); ?>
    <div class="featured-image">
        <?php
        if(ale_get_option('featuredimageacademics')){
            echo '<img src="'.esc_url(ale_get_option('featuredimageacademics')).'" alt>';
        } else{
            echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
        }?>
    </div>
    <div class="page-block wrapper clearfix">
        <?php get_sidebar(); ?>

        <div class="page-content col-8 single story">
            <?php get_breadcrumbs(); ?>

            <h1><?php wp_title("", true); ?></h1>

            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                <div class="article cf">
                    <div class="image">
                        <?php if(get_the_post_thumbnail($post->ID,'academics-single')){
                            echo get_the_post_thumbnail($post->ID,'academics-single');
                        } else{
                            echo '<img src="http://placehold.it/678x316/ece6d9/8d7a65&amp;text=No+image" alt>';
                        }?>
                    </div>
                    <div class="course-info-box cf">
                        <span class="graduation"><i class="fa fa-graduation-cap"></i> <?php _e('Graduation','aletheme'); ?>: <strong><?php echo esc_attr(ale_get_meta('academicsspost')); ?></strong></span>
                        <div class="social">
                            <a href="#"><i class="fa fa-twitter"></i></a> &nbsp;
                            <a href="#"><i class="fa fa-facebook-square"></i></a> &nbsp;
                            <a href="#"><i class="fa fa-linkedin"></i></a> &nbsp;
                            <a href="#"><i class="fa fa-instagram"></i></a>
                        </div>
                    </div>
                    <?php the_content();?>
                    <?php wp_link_pages(); ?>

                    <div class="featured-box single-time-academic cf">
                        <div class="item cf">
                            <?php $table_meta = get_post_meta($post->ID, 'ale_academic_table_details', true);
                            if ( $table_meta ) : ?>
                                <div class="col-12 story cf">
                                    <table>
                                        <tr>
                                            <td>
                                                <?php _e('Years', 'aletheme'); ?>
                                            </td>
                                            <?php foreach ( $table_meta as $field ) { ?>
                                                <td>
                                                    <?php if ($field['year'] != '') echo esc_attr( $field['year'] );  ?>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <tr>
                                            <td>
                                                <?php _e('Monday', 'aletheme'); ?>
                                            </td>
                                            <?php foreach ( $table_meta as $field ) { ?>
                                                <td>
                                                    <?php if ($field['monday'] != '') echo esc_attr( $field['monday'] );  ?>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <tr>
                                            <td>
                                                <?php _e('Tuesday', 'aletheme'); ?>
                                            </td>
                                            <?php foreach ( $table_meta as $field ) { ?>
                                                <td>
                                                    <?php if ($field['tuesday'] != '') echo esc_attr( $field['tuesday'] );  ?>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <tr>
                                            <td>
                                                <?php _e('Wednesday', 'aletheme'); ?>
                                            </td>
                                            <?php foreach ( $table_meta as $field ) { ?>
                                                <td>
                                                    <?php if ($field['wednesday'] != '') echo esc_attr( $field['wednesday'] );  ?>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <tr>
                                            <td>
                                                <?php _e('Thursday', 'aletheme'); ?>
                                            </td>
                                            <?php foreach ( $table_meta as $field ) { ?>
                                                <td>
                                                    <?php if ($field['thursday'] != '') echo esc_attr( $field['thursday'] );  ?>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <tr>
                                            <td>
                                                <?php _e('Friday', 'aletheme'); ?>
                                            </td>
                                            <?php foreach ( $table_meta as $field ) { ?>
                                                <td>
                                                    <?php if ($field['friday'] != '') echo esc_attr( $field['friday'] );  ?>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            <?php endwhile;  endif; wp_reset_query();?>

            <?php comments_template(); ?>
        </div>
    </div>
<?php get_footer(); ?>