<?php
/*
  * Template name: Home
  * */
get_header(); ?>
<?php if(ale_get_meta('displayhomeslider') != "off"): ?>
	<?php
	if(ale_get_meta('displayhomeslider') == 'on'){
		wp_reset_query();
		$count = esc_attr(ale_get_meta('homeslidercount'));
		$query_gallery = new WP_Query(
			array(
				'posts_per_page' => $count,
				'post_type' => 'gallery',
				'ignore_sticky_posts' => 1,
				'post__not_in' => get_option('sticky_posts'),
				'meta_query' => array(
					array(
						'key' => 'ale_galleryslider',
						'value' => 'on'
					)
				),
			)
		);
		if ($query_gallery->have_posts()) : ?>
			<div class="homeslider flexslider">
				<ul class="slides">
					<?php while ($query_gallery->have_posts()) : $query_gallery->the_post(); ?>
						<?php if(ale_get_meta('gallerysliderpreview')){ ?>
						<li>
							<img src="<?php echo esc_url(ale_get_meta('gallerysliderpreview')); ?>" alt="<?php the_title(); ?>" />
							<div class="text wrapper">
								<h2><?php the_title(); ?></h2>
								<h3><?php echo strip_tags(ale_trim_excerpt(6)); ?></h3>
								<a class="button-arrow" href="<?php the_permalink(); ?>"><?php _e('See more','aletheme'); ?></a>
							</div>
						</li>
						<?php } ?>
					<?php endwhile; ?>
				</ul>
			</div>
		<?php endif; wp_reset_query();
	} elseif(ale_get_meta('displayhomeslider')=='simple'){ ?>
		<div class="homeslider flexslider">
			<ul class="slides">
				<?php $slider = ale_sliders_get_slider(ale_get_option('homeslugfull'));  ?>
				<?php if($slider):?>
					<?php foreach ($slider['slides'] as $slide) : ?>
						<li>
							<?php if ($slide['image']) : ?>
								<img src="<?php echo esc_url($slide['image']); ?>" alt="<?php echo $slide['title']; ?>" />
							<?php endif; ?>
							<div class="text wrapper">
								<?php if($slide['title']){ echo '<h2>'.esc_attr($slide['title']).'</h2>'; } ?>
								<h3><?php echo esc_attr($slide['description']); ?></h3>
								<?php if($slide['url']){ ?><a class="button-arrow" href="<?php echo esc_url($slide['url']); ?>"><?php } ?>
									<?php _e('See more','aletheme'); ?>
								<?php if($slide['url']){ ?></a><?php } ?>
							</div>
						</li>
					<?php endforeach; ?>
				<?php endif;?>
			</ul>
		</div>
	<?php } ?>
<?php endif;?>

<?php if(ale_get_meta('displayhomeinfo') != "off"): ?>
	<div class="info-box">
		<div class="wrapper">
			<article class="ib-col-3">
				<h2><?php echo esc_attr(ale_get_meta('homeinformationtitle1')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('homeinformationtext1')); ?></p>
				<a href="<?php echo esc_url(ale_get_meta('homeinformationurl1')); ?>" class="button-figure">
					<?php echo esc_attr(ale_get_meta('homeinformationurltext1')); ?>
					<span></span>
				</a>
				<span class="shadow"></span>
			</article>

			<article class="ib-col-3">
				<h2><?php echo esc_attr(ale_get_meta('homeinformationtitle2')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('homeinformationtext2')); ?></p>
				<a href="<?php echo esc_url(ale_get_meta('homeinformationurl2')); ?>" class="button-figure">
					<?php echo esc_attr(ale_get_meta('homeinformationurltext2')); ?>
					<span></span>
				</a>
				<span class="shadow"></span>
			</article>

			<article class="ib-col-3">
				<h2><?php echo esc_attr(ale_get_meta('homeinformationtitle3')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('homeinformationtext3')); ?></p>
				<a href="<?php echo esc_url(ale_get_meta('homeinformationurl3')); ?>" class="button-figure">
					<?php echo esc_attr(ale_get_meta('homeinformationurltext3')); ?>
					<span></span>
				</a>
				<span class="shadow"></span>
			</article>

			<article class="ib-col-3">
				<h2><?php echo esc_attr(ale_get_meta('homeinformationtitle4')); ?></h2>
				<p><?php echo esc_attr(ale_get_meta('homeinformationtext4')); ?></p>
				<a href="<?php echo esc_url(ale_get_meta('homeinformationurl4')); ?>" class="button-figure">
					<?php echo esc_attr(ale_get_meta('homeinformationurltext4')); ?>
					<span></span>
				</a>
				<span class="shadow"></span>
			</article>
		</div>
	</div>
<?php endif;?>

<div class="college-box">
	<?php if(ale_get_meta('displayhomeourcollege') != "off"): ?>
		<div class="our-college">
			<section class="wrapper clearfix">
				<div class="text col-8">
					<h2><?php echo esc_attr(ale_get_meta('homeourcollegetitle')); ?></h2>
					<p><?php echo esc_attr(ale_get_meta('homeourcollegetext')); ?></p>
				</div>

				<div class="video col-4">
					<div class="image">
						<img src="<?php
						if(ale_get_meta('homeourcollegeimage')){
							echo esc_url(ale_get_meta('homeourcollegeimage'));
						} else{
							echo "http://placehold.it/255x135/ece6d9/8d7a65&amp;text=No+image";
						} ?>" alt>
					</div>
					<div class="popup">
						<div class="slider-wrapper">
							<div class="container">
								<?php echo wp_oembed_get(esc_url(ale_get_meta('homeourcollegevideo'))); ?>
								<div class="close"><i class="fa fa-times"></i></div>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
	<?php endif;?>

	<?php if(ale_get_meta('displayhomeourcollegeall') != "off"): ?>
		<div class="course-events">
			<div class="wrapper clearfix">
				<div class="our-college-sidebar col-4">
					<article>
						<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle1')); ?></h3>
						<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext1')); ?></p>
						<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink1')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext1')); ?><span></span></a>
					</article>

					<article>
						<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle2')); ?></h3>
						<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext2')); ?></p>
						<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink2')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext2')); ?><span></span></a>
					</article>

					<article>
						<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle3')); ?></h3>
						<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext3')); ?></p>
						<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink3')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext3')); ?><span></span></a>
					</article>
				</div>

				<div class="col-8">
					<section class="course">
						<h3><?php echo esc_attr(ale_get_meta('homeourcollegesearchtitle')); ?></h3>
						<div class="filter">
							<form class="filters clearfix" method="post" action="<?php echo home_url('/course');  ?>">
								<div class="col-5">
									<label for="coursecat2"><?php _e('Search By Speciality','aletheme'); ?></label>
									<select name="coursecat" id="coursecat2" class="dropdown">
										<?php $args = array(
											'type'                     => 'course',
											'child_of'                 => 0,
											'parent'                   => '',
											'orderby'                  => 'name',
											'order'                    => 'ASC',
											'hide_empty'               => 1,
											'hierarchical'             => 1,
											'exclude'                  => '',
											'include'                  => '',
											'number'                   => '',
											'taxonomy'                 => 'course-category',
											'pad_counts'               => false );

										$categories = get_categories( $args );
										foreach($categories as $cat){
											echo '<option value="'.esc_url($cat->term_id).'">'.esc_attr($cat->name).'</option>';
										}?>
									</select>
								</div>
								<!-- END: FILTERS__ROW -->

								<div class="col-7">
									<label for="keywords2"><?php _e('Fill Your Keywords','aletheme'); ?></label>
									<input type="text" name="keywords" id="keywords2" placeholder="<?php _e('Type your keywords...', 'aletheme');?>">
									<input type="submit" name="submit" value="<?php _e('Search','aletheme'); ?>">
								</div>
								<!-- END: FILTERS__ROW -->
							</form>
						</div>
						<p><?php echo esc_attr(ale_get_meta('homeourcollegesearchtext')); ?></p>
					</section>

					<section class="events flexslider">
						<h3><?php echo esc_attr(ale_get_meta('homeourcollegeeventstitle')); ?></h3>
						<ul class="slides">
							<?php
							wp_reset_query();
							$query_events = new WP_Query(
								array(
									'posts_per_page' => 9,
									'post_type' => 'events',
									'ignore_sticky_posts' => 1,
									'post__not_in' => get_option('sticky_posts')
								)
							);
							$count = 1;
							if ($query_events->have_posts()) : while ($query_events->have_posts()) : $query_events->the_post();
								if($count%3==1){echo '<li>';}
								?>
								<article>
									<span class="date"><?php the_time('j'); ?><span><?php the_time('D Y'); ?></span></span>
									<h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
									<?php echo ale_trim_excerpt(25); ?>
								</article>
								<?php if($count%3==0){echo '</li>';} $count++;
							endwhile;  endif; wp_reset_query();?>
						</ul>
					</section>
				</div>
			</div>
		</div>
	<?php endif;?>
</div>

<?php if(ale_get_meta('displayhomenews') != "off"): ?>
	<div class="news-box" <?php if(ale_get_meta('homenewsbackground')){
	echo 'style="background: url('.esc_url(ale_get_meta('homenewsbackground')).') 50% 50% no-repeat; background-size: cover;"';
	}?>>
		<div class="wrapper clearfix">
			<div class="col-4">
				<section class="quicklinks">
					<h3><?php echo esc_attr(ale_get_option('quicklinkstitle')); ?></h3>
					<ul class="clearfix">
						<?php if(ale_get_option('quicklinkstext1')){ ?>
							<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink1')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext1')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext2')){ ?>
							<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink2')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext2')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext3')){ ?>
							<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink3')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext3')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext4')){ ?>
							<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink4')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext4')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext5')){ ?>
							<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink5')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext5')); ?></a></li>
						<?php } ?>

						<?php if(ale_get_option('quicklinkstext6')){ ?>
							<li class="col-6"><a href="<?php echo esc_url(ale_get_option('quicklinkslink6')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext6')); ?></a></li>
						<?php } ?>
					</ul>
				</section>

				<section class="summercourses">
					<h3><?php echo esc_attr(ale_get_option('homesummercoursestitle')); ?></h3>
					<p><?php echo esc_attr(ale_get_option('homesummercoursestext')); ?></p>
					<a href="<?php echo esc_url(ale_get_option('homesummercourseslink')); ?>" class="button"><?php echo esc_attr(ale_get_option('homesummercourseslinktext')); ?></a>
				</section>

			</div>

			<div class="col-8 news flexslider">
				<h2><?php echo esc_attr(ale_get_meta('homenewstitle')); ?></h2>

				<ul class="slides">
					<?php
					wp_reset_query();
					$query_news = new WP_Query(
						array(
							'posts_per_page' => 12,
							'post_type' => 'news',
							'ignore_sticky_posts' => 1,
							'post__not_in' => get_option('sticky_posts')
						)
					);
					$count = 1;
					if ($query_news->have_posts()) : while ($query_news->have_posts()) : $query_news->the_post();
						if($count%4==1){echo '<li>';}
						?>
						<article>
							<?php
							if(get_the_post_thumbnail($post->ID,'news-thumba')){
								echo get_the_post_thumbnail($post->ID,'news-thumba');
							} else{
								echo '<img src="http://placehold.it/145x134/ece6d9/8d7a65&amp;text=No+image" alt>';
							}
							?>
							<span class="date"><?php the_time('j D Y'); ?></span>
							<h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
							<?php echo ale_trim_excerpt(14); ?>
						</article>
						<?php if($count%4==0){echo '</li>';} $count++;
					endwhile;  endif; wp_reset_query();?>
				</ul>
			</div>
		</div>
	</div>
<?php endif;?>

<?php if(ale_get_meta('displayhomephotogallery') !="off"): ?>
	<div class="gallery-box">
		<section class="wrapper">
			<h2><?php echo esc_attr(ale_get_meta('homephotogallerytitle')); ?></h2>
			<p><?php echo esc_attr(ale_get_meta('homephotogallerytext')); ?></p>
			<a href="<?php echo get_post_type_archive_link('gallery');?>" class="button-arrow"><?php echo esc_attr(ale_get_meta('homephotogallerylink')); ?></a>
			<div class="images">
				<?php
				wp_reset_query();
				$query_gallery = new WP_Query(
					array(
						'posts_per_page' => 12,
						'post_type' => 'gallery',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				$count = 1;
				if ($query_gallery->have_posts()) : while ($query_gallery->have_posts()) : $query_gallery->the_post(); ?>
					<a href="<?php the_permalink();?>">
						<?php if($count%2 == 0){
							if(get_the_post_thumbnail($post->ID,'gallery-thumbathree')){
								echo get_the_post_thumbnail($post->ID,'gallery-thumbathree');
							} else{
								echo '<img src="http://placehold.it/170x198/ece6d9/8d7a65&amp;text=No+image" alt>';
							}
						} elseif($count%3 == 1){
							if(get_the_post_thumbnail($post->ID,'gallery-thumbaone')){
								echo get_the_post_thumbnail($post->ID,'gallery-thumbaone');
							} else{
								echo '<img src="http://placehold.it/170x92/ece6d9/8d7a65&amp;text=No+image" alt>';
							}
						} else{
							if(get_the_post_thumbnail($post->ID,'gallery-thumbafour')){
								echo get_the_post_thumbnail($post->ID,'gallery-thumbafour');
							} else{
								echo '<img src="http://placehold.it/170x240/ece6d9/8d7a65&amp;text=No+image" alt>';
							}
						} ?>
						<span><?php _e('See more', 'aletheme'); ?></span>
					</a>
					<?php $count++;
				endwhile; endif; wp_reset_query();?>
			</div>
		</section>
	</div>
<?php endif; ?>

<?php if(ale_get_meta('displayhomefeaturedprofessor') !="off"): ?>
	<div class="feauturedprofessor-box">
		<section class="wrapper flexslider clearfix">
			<h3><?php echo esc_attr(ale_get_meta('homefeaturedprofessortitle')); ?></h3>

			<ul class="slides cf">
				<?php
				wp_reset_query();
				$query_academics = new WP_Query(
					array(
						'posts_per_page' => 8,
						'post_type' => 'academics',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				$count = 1;
				if ($query_academics->have_posts()) : while ($query_academics->have_posts()) : $query_academics->the_post();
					if($count%4==1){echo '<li class="cf feat-slider">';}
					?>
					<article class="cf">
						<div class="item">
							<div class="social">
								<ul>
									<li><a href="<?php echo esc_url(ale_get_meta('academicssocialinst')); ?>" class="instagram"></a></li>
									<li><a href="<?php echo esc_url(ale_get_meta('academicssocialtwi')); ?>" class="twitter"></a></li>
									<li><a href="<?php echo esc_url(ale_get_meta('academicssocialfb')); ?>" class="facebook"></a></li>
								</ul>
							</div>
							<a href="<?php the_permalink(); ?>">
								<?php
								if(get_the_post_thumbnail($post->ID,'academics-thumba')){
									echo get_the_post_thumbnail($post->ID,'academics-thumba');
								} else{
									echo '<img src="http://placehold.it/244x214/ece6d9/8d7a65&amp;text=No+image" alt>';
								}
								?>
							</a>

						</div>
						<h4><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h4>
						<?php echo ale_trim_excerpt(14); ?>
					</article>
					<?php if($count%4==0){echo '</li>';} $count++;
				endwhile;  endif; wp_reset_query();?>
			</ul>
		</section>
	</div>
<?php endif; ?>

<?php get_footer(); ?>