<!DOCTYPE html>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" <?php language_attributes(); ?>> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php wp_title('|', true, 'right'); bloginfo('name'); ?></title>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?> >

<?php if(ale_get_option('preloader')==1){ ale_part('preloader'); } ?>

<div <?php if(ale_get_option('preloader')==1){ ?>class="body"<?php } ?>>
	<header>
		<?php if(ale_get_meta('displayhome1information')!="below"): ?>
			<div class="info">
				<div class="wrapper clearfix">
					<div class="col-4 city">
						<?php if(ale_get_option('geoip')=='1'){ ?>
							<span class="fa fa-map-marker"></span>
							<a id="GeoAPI" class="city__selectedCity"></a>
						<?php } ?>
					</div>
					<div class="col-8 data">
						<?php if(ale_get_option('headernum')){ ?><div class="phone"><span class="fa fa-phone"></span><?php echo esc_attr(ale_get_option('headernum')); ?></div><?php } ?>
						<?php if(ale_get_option('headeremail')){ ?><div class="email"><span class="fa fa-envelope"></span><a href="mailto:<?php echo esc_attr(ale_get_option('headeremail')); ?>"><?php echo esc_attr(ale_get_option('headeremail')); ?></a></div><?php } ?>
						<?php global $user_ID, $user_identity; get_currentuserinfo();
						if(get_option('users_can_register')){ ?>
							<div class="registration">
								<?php if (!$user_ID) { ?>
									<span><?php _e('Login', 'aletheme'); ?></span>
									<span>/</span>
									<?php if(isset($_GET['register']) and $_GET['register']=="true"){ ?>
										<span><?php _e('Check Email', 'aletheme'); ?></span>
									<?php } else { ?>
										<span><?php _e('Register', 'aletheme'); ?></span>
									<?php } ?>
								<?php } else{ ?>
									<a href="<?php echo wp_logout_url('index.php'); ?>"><?php _e('Logout', 'aletheme'); ?></a>
									<span>/</span>
									<?php if (current_user_can('manage_options')) { ?>
										<a class="profile" href="<?php admin_url(); ?>"><?php _e('Admin', 'aletheme'); ?></a>
									<?php } else { ?>
										<a class="profile" href="<?php admin_url(); ?>/profile.php"><?php _e('Profile', 'aletheme'); ?></a>
									<?php } ?>
								<?php } ?>
							</div>
							<?php ale_part('login-form'); ?>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
		
		<div class="wrapper logo-menu clearfix">
			<div class="col-3 logo">
				<?php if(ale_get_option('headerlogo')){ ?>
					<a href="<?php echo home_url(); ?>/" class="customlogo"><img src="<?php echo esc_url(ale_get_option('headerlogo')); ?>" alt></a>
				<?php } else { ?>
					<a href="<?php echo home_url(); ?>/" class="alelogo"><?php echo esc_attr(bloginfo('name')); ?></a>
				<?php } ?>
			</div>
			<nav class="col-9">
				<div class="menu-icon"><i class="fa fa-bars"></i></div>
				<?php
				if ( has_nav_menu( 'header_right_menu' ) ) {
					wp_nav_menu(array(
						'theme_location'=> 'header_right_menu',
						'menu'			=> 'Header Right Menu',
						'menu_class'	=> 'menu cf',
						'walker'		=> new Aletheme_Nav_Walker(),
						'container'		=> '',
					));
				}
				?>
			</nav>
		</div>
	</header>

	<?php //ale_part('login-form'); ?>

	<?php if(ale_get_option('colorselector')==1) { ale_part('colorselector'); } ?>