<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagetestimonials')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagetestimonials')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix testimoials-box">
		<?php get_breadcrumbs(); ?>
		<h1 class="page-title"><?php wp_title("", true); ?></h1>
	</div>

	<div class="testimoials-box">
		<div class="testimonials-archive-blockqoute">
			<?php if(ale_get_option('testimonialsarchivebg')){ ?>
				<div class="bg-image" style="background-image: url('<?php echo esc_url(ale_get_option('testimonialsarchivebg')); ?>');"></div>
			<?php } ?>
			<i class="fa fa-quote-right"></i>
			<h2><?php echo esc_attr(ale_get_option('testimonialsarchivetitle')); ?></h2>
			<hr>
			<p><?php echo esc_attr(ale_get_option('testimonialsarchivedesc')); ?></p>
		</div>
	</div>
	<div class="testimoials-box">
		<div class="wrapper">
			<div class="items">
				<?php
				wp_reset_query();
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count = esc_attr(ale_get_option('paginationtestimonials'));
				$query_testimonials = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'testimonials',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				if ($query_testimonials->have_posts()) : while ($query_testimonials->have_posts()) : $query_testimonials->the_post(); ?>
					<article>
						<div class="image">
							<?php if(get_the_post_thumbnail($post->ID,'testimonials-home3')){
								echo get_the_post_thumbnail($post->ID,'testimonials-home3');
							} else{
								echo '<img src="http://placehold.it/78x78/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?>
						</div>
						<div class="text">
							<h3><?php the_title(); ?></h3>
							<?php if(ale_get_meta('testimonialscourse')){ ?>
								<span><?php _e('Course', 'aletheme'); echo ': "' . esc_attr(ale_get_meta('testimonialscourse')); ?>"</span>
							<?php } ?>
						</div>
						<hr>
						<blockquote><i class="fa fa-quote-left"></i><?php echo ale_trim_excerpt(20); ?></blockquote>
						<p><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' ago'; ?></p>
						<a href="<?php the_permalink(); ?>"></a>
					</article>
				<?php endwhile; endif; wp_reset_query();?>
			</div>

			<div class="pagination">
				<?php ale_custom_page_links($query_testimonials); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>