<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagemembers')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagemembers')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<div class="page-content members-box">
			<div class="top">
				<?php get_breadcrumbs(); ?>
				<h1><?php wp_title("", true); ?></h1>
			</div>
			<div class="items">
				<?php
				wp_reset_query();
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count_members = esc_attr(ale_get_option('paginationmembers'));
				$query_members = new WP_Query(
					array(
						'posts_per_page' => $count_members,
						'post_type' => 'members',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				if ($query_members->have_posts()) : while ($query_members->have_posts()) : $query_members->the_post(); ?>
					<article>
						<div class="image">
							<?php if(ale_get_meta('memberssocialinst')||ale_get_meta('memberssocialtwi')||ale_get_meta('memberssocialfb')): ?>
								<div class="social">
									<?php if(ale_get_meta('memberssocialinst')){ ?>
										<a href="<?php echo esc_url(ale_get_meta('memberssocialinst')); ?>" class="instagram"><i class="fa fa-instagram"></i></a>
									<?php } ?>

									<?php if(ale_get_meta('memberssocialtwi')){ ?>
									<a href="<?php echo esc_url(ale_get_meta('memberssocialtwi')); ?>" class="twitter"><i class="fa fa-twitter"></i></a>
									<?php } ?>

									<?php if(ale_get_meta('memberssocialfb')){ ?>
									<a href="<?php echo esc_url(ale_get_meta('memberssocialfb')); ?>" class="facebook"><i class="fa fa-facebook"></i></a>
									<?php } ?>
								</div>
							<?php endif; ?>

							<?php if(get_the_post_thumbnail($post->ID,'members-archive')){
								echo get_the_post_thumbnail($post->ID,'members-archive');
							} else{
								echo '<img src="http://placehold.it/243x215/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?>
						</div>

						<div class="text">
							<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
							<span class="post"><?php echo esc_attr(ale_get_meta('memberspost')); ?></span>
							<div class="string">
								<?php echo ale_trim_excerpt(24); ?>
							</div>
						</div>
					</article>
				<?php endwhile;  endif; wp_reset_query();?>
			</div>
			<div class="pagination">
				<?php ale_custom_page_links($query_members); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>