<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagegallery')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagegallery')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8 gallery">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>
			<?php
			wp_reset_query();
			if ( get_query_var('paged') ) $paged = get_query_var('paged');
			if ( get_query_var('page') ) $paged = get_query_var('page');
			$count = esc_attr(ale_get_option('paginationgallery'));
			$query_gallery = new WP_Query(
				array(
					'posts_per_page' => $count,
					'post_type' => 'gallery',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts'),
					'paged' => $paged
				)
			);
			if ($query_gallery->have_posts()) : while ($query_gallery->have_posts()) : $query_gallery->the_post(); ?>
				<div class="article">
					<a href="<?php the_permalink(); ?>">
						<?php if(get_the_post_thumbnail($post->ID,'gallery-thumba')){
							echo get_the_post_thumbnail($post->ID,'gallery-thumba');
						} else{
							echo '<img src="http://placehold.it/220x194/ece6d9/8d7a65&amp;text=No+image" alt>';
						}?>
						<span><?php _e('plus', 'aletheme');?></span>
					</a>
					<h2><?php the_title(); ?></h2>
					<span class="time"><?php the_time('F j, Y'); ?></span>
				</div>
			<?php endwhile;  endif; wp_reset_query();?>
			<div class="pagination">
				<?php ale_custom_page_links($query_gallery); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>