<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageevents')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageevents')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<div class="page-content events-box">
			<div class="top">
				<?php get_breadcrumbs(); ?>
				<h1><?php wp_title("", true); ?></h1>
			</div>
			<?php
			wp_reset_query();
			if ( get_query_var('paged') ) $paged = get_query_var('paged');
			if ( get_query_var('page') ) $paged = get_query_var('page');
			$count = esc_attr(ale_get_option('paginationevents'));
			$query_events = new WP_Query(
				array(
					'posts_per_page' => $count,
					'post_type' => 'events',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts'),
					'paged' => $paged
				)
			);
			if ($query_events->have_posts()) : while ($query_events->have_posts()) : $query_events->the_post(); ?>
				<div class="article clearfix">
					<div class="col-6 image">
						<?php if(get_the_post_thumbnail($post->ID,'events-archive')){
							echo get_the_post_thumbnail($post->ID,'events-archive');
						} else{
							echo '<img src="http://placehold.it/509x304/ece6d9/8d7a65&amp;text=No+image" alt>';
						}?>
					</div>

					<div class="col-6 text">
						<div class="header clearfix">
							<div class="date"><?php the_time('j'); ?><span><?php the_time('D Y'); ?></span></div>
							<div class="title">
								<h2><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h2>
								<?php if(ale_get_meta('eventstime1')){ ?>
									<span class="time"><i class="fa fa-clock-o"></i><?php echo esc_attr(ale_get_meta('eventstime1')) . ' - ' . esc_attr(ale_get_meta('eventstime2')); ?></span>
								<?php } ?>
							</div>
						</div>
						<div class="string">
							<?php echo ale_trim_excerpt(50); ?>
						</div>
						<hr>
						<div class="share">
							<a href="<?php echo ale_get_share('goglp'); ?>" onclick="window.open(this.href, 'Share on Google+', 'width=600,height=300'); return false"><i class="fa fa-google-plus"></i></a>
							<a href="<?php echo ale_get_share('twi'); ?>" onclick="window.open(this.href, 'Share on Twitter', 'width=600,height=300'); return false"><i class="fa fa-twitter"></i></a>
							<a href="<?php echo ale_get_share('fb'); ?>" onclick="window.open(this.href, 'Share on Facebook', 'width=600,height=300'); return false"><i class="fa fa-facebook"></i></a>
						</div>
						<a href="<?php the_permalink(); ?>" class="button"><?php _e('Register', 'aletheme'); ?></a>
					</div>
				</div>
			<?php endwhile;  endif; wp_reset_query();?>
			<div class="pagination">
				<?php ale_custom_page_links($query_events); ?>
			</div>
		</div>
	</div>
<?php get_footer(); ?>