<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagedepartmens')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagedepartmens')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix departmens-box">
		<?php get_breadcrumbs(); ?>
		<h1 class="page-title"><?php wp_title("", true); ?></h1>
		<div class="items">
			<?php
			wp_reset_query();
			if ( get_query_var('paged') ){
				$paged = get_query_var('paged');
			} elseif ( get_query_var('page') ){
				$paged = get_query_var('page');
			} else{
				$paged = 'paged';
			}
			$count = esc_attr(ale_get_option('paginationdepartmens'));
			$query_departmens = new WP_Query(
				array(
					'posts_per_page' => $count,
					'post_type' => 'departmens',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts'),
					'paged' => $paged
				)
			);
			if ($query_departmens->have_posts()) : while ($query_departmens->have_posts()) : $query_departmens->the_post(); ?>
				<article>
					<?php if(get_the_post_thumbnail($post->ID,'departmens-archive')){
						echo get_the_post_thumbnail($post->ID,'departmens-archive');
					} else{
						echo '<img src="http://placehold.it/341x244/ece6d9/8d7a65&amp;text=No+image" alt>';
					}?>
					<div class="text">
						<h3><i class="fa fa-<?php echo esc_attr(ale_get_meta('departmensicon')); ?>"></i><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						<div class="string">
							<?php echo ale_trim_excerpt(20); ?>
						</div>
					</div>
				</article>
			<?php endwhile; endif; wp_reset_query();?>
		</div>

		<div class="pagination">
			<?php ale_custom_page_links($query_departmens); ?>
		</div>
	</div>
<?php get_footer(); ?>