<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimagecourse')){
			echo '<img src="'.esc_url(ale_get_option('featuredimagecourse')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<?php get_sidebar(); ?>

		<div class="page-content col-8">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>

			<?php $args = array(
				'type'                     => 'course',
				'child_of'                 => 0,
				'parent'                   => '',
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 1,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => 4,
				'taxonomy'                 => 'course-category',
				'pad_counts'               => false );

			$categories = get_categories( $args ); ?>
			<div class="category">
				<?php foreach($categories as $cat){
					echo '<article><h2>'.esc_attr($cat->name).'</h2><p>'.esc_attr($cat->description).'</p><a href="'.home_url().'/course-category/'.esc_attr($cat->slug).'">'.__('Read more', 'aletheme').'</a></article>';
				}?>
			</div>

			<div class="searchcourse">
				<section class="filter">
					<h2><?php _e('Search Course', 'aletheme'); ?></h2>
					<form class="filters clearfix" method="post" action="<?php echo home_url('/course');  ?>">
						<div class="col-5">
							<label for="coursecat2"><?php _e('Search By Speciality','aletheme'); ?></label>
							<select name="coursecat" id="coursecat2" class="dropdown">
								<?php $args = array(
									'type'                     => 'course',
									'child_of'                 => 0,
									'parent'                   => '',
									'orderby'                  => 'name',
									'order'                    => 'ASC',
									'hide_empty'               => 1,
									'hierarchical'             => 1,
									'exclude'                  => '',
									'include'                  => '',
									'number'                   => '',
									'taxonomy'                 => 'course-category',
									'pad_counts'               => false );

								$categories = get_categories( $args );
								foreach($categories as $cat){
									echo '<option value="'.esc_attr($cat->term_id).'">'.esc_attr($cat->name).'</option>';
								}?>
							</select>
						</div>
						<!-- END: FILTERS__ROW -->

						<div class="col-7">
							<label for="keywords2"><?php _e('Fill Your Keywords','aletheme'); ?></label>
							<input type="text" name="keywords" id="keywords2" placeholder="<?php _e('Type your keywords...', 'aletheme');?>">
							<input type="submit" name="submit" value="<?php _e('Search','aletheme'); ?>">
						</div>
						<!-- END: FILTERS__ROW -->
					</form>
					<p><?php echo esc_attr(ale_get_option('filtertext')); ?></p>
				</section>

				<section class="result">
					<h2><?php _e('Found', 'aletheme'); ?></h2>
					<?php ale_filter($_POST); ?>
				</section>
			</div>

			<?php if(ale_get_option('coursetablebox') !="off"): ?>
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_option('coursetablecount'));
				$query_course = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'course',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'orderby' => 'comment_count',
						'meta_query' => array(
							array(
								'key' => 'ale_coursearchive',
								'value' => 'on'
							)
						)
					)
				);
				if ($query_course->have_posts()) : ?>
					<div class="story">
						<table>
							<thead>
								<tr>
									<th><?php _e('Course ID', 'aletheme'); ?></th>
									<th><?php _e('Course Name', 'aletheme'); ?></th>
									<th><?php _e('Instructor', 'aletheme'); ?></th>
									<th><?php _e('Room Number', 'aletheme'); ?></th>
									<th><?php _e('Time', 'aletheme'); ?></th>
								</tr>
							</thead>

							<tbody>
								<?php while ($query_course->have_posts()) : $query_course->the_post(); ?>
									<tr>
										<td><?php echo esc_attr(ale_get_meta('courseid')); ?></td>
										<td><?php the_title(); ?></td>
										<td><?php echo esc_attr(ale_get_meta('courseinstructor')); ?></td>
										<td><?php echo esc_attr(ale_get_meta('courseroom')); ?></td>
										<td><?php echo esc_attr(ale_get_meta('coursetime')); ?></td>
									</tr>
								<?php endwhile; ?>
							</tbody>
						</table>
					</div>
				<?php endif; wp_reset_query();?>
			<?php endif; ?>
		</div>
	</div>
<?php get_footer(); ?>