<?php get_header(); ?>
	<div class="featured-image">
		<?php
		if(ale_get_option('featuredimageacademics')){
			echo '<img src="'.esc_url(ale_get_option('featuredimageacademics')).'" alt>';
		} else{
			echo '<img src="http://placehold.it/1920x125/ece6d9/8d7a65&amp;text=No+image" alt>';
		}?>
	</div>
	<div class="page-block wrapper clearfix">
		<div class="our-college-sidebar col-4">
			<article>
				<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle1')); ?></h3>
				<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext1')); ?></p>
				<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink1')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext1')); ?><span></span></a>
			</article>

			<article>
				<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle2')); ?></h3>
				<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext2')); ?></p>
				<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink2')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext2')); ?><span></span></a>
			</article>

			<article>
				<h3><?php echo esc_attr(ale_get_option('ourcollegesidebartitle3')); ?></h3>
				<p><?php echo esc_attr(ale_get_option('ourcollegesidebartext3')); ?></p>
				<a href="<?php echo esc_url(ale_get_option('ourcollegesidebarlink3')); ?>"><?php echo esc_attr(ale_get_option('ourcollegesidebarlinktext3')); ?><span></span></a>
			</article>
		</div>

		<div class="page-content col-8 academics-page">
			<?php get_breadcrumbs(); ?>

			<h1><?php wp_title("", true); ?></h1>
			<div class="items">
				<?php
				$count = esc_attr(ale_get_option('paginationacademics'));
				$query_academics = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'academics',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_academics->have_posts()) : while ($query_academics->have_posts()) : $query_academics->the_post(); ?>
					<article>
						<div class="image">
							<?php if(get_the_post_thumbnail($post->ID,'academics-mini')){
								echo get_the_post_thumbnail($post->ID,'academics-mini');
							} else{
								echo '<img src="http://placehold.it/150x152/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?>

							<a href="<?php the_permalink(); ?>" class="link">
								<span><?php _e('plus', 'aletheme');?></span>
							</a>
						</div>
						<h2><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h2>
						<?php echo ale_trim_excerpt(5); ?>
					</article>
				<?php endwhile;  endif; wp_reset_query();?>
			</div>

			<div class="quicklinks col-9">
				<ul class="clearfix">
					<?php if(ale_get_option('quicklinkstext1')){ ?>
						<li class="col-4"><a href="<?php echo esc_url(ale_get_option('quicklinkslink1')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext1')); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext2')){ ?>
						<li class="col-4"><a href="<?php echo esc_url(ale_get_option('quicklinkslink2')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext2')); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext3')){ ?>
						<li class="col-4"><a href="<?php echo esc_url(ale_get_option('quicklinkslink3')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext3')); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext4')){ ?>
						<li class="col-4"><a href="<?php echo esc_url(ale_get_option('quicklinkslink4')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext4')); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext5')){ ?>
						<li class="col-4"><a href="<?php echo esc_url(ale_get_option('quicklinkslink5')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext5')); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext6')){ ?>
						<li class="col-4"><a href="<?php echo esc_url(ale_get_option('quicklinkslink6')); ?>"><?php echo esc_attr(ale_get_option('quicklinkstext6')); ?></a></li>
					<?php } ?>
				</ul>
			</div>
		</div>

		<?php if(ale_get_option('academicspagebox') !="off"): ?>
			<div class="featured-box">
				<hr>
				<h2><?php echo esc_attr(ale_get_option('academicspagetitle')); ?></h2>
				<?php
				wp_reset_query();
				$count = esc_attr(ale_get_option('academicspagecount'));
				$query_academics = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'academics',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'orderby' => 'comment_count'
					)
				);
				if ($query_academics->have_posts()) : while ($query_academics->have_posts()) : $query_academics->the_post(); ?>
					<div class="item clearfix">
						<div class="col-3">
							<?php if(get_the_post_thumbnail($post->ID,'academics-thumba')){
								echo get_the_post_thumbnail($post->ID,'academics-thumba');
							} else{
								echo '<img src="http://placehold.it/244x214/ece6d9/8d7a65&amp;text=No+image" alt>';
							}?>
						</div>

						<div class="col-9">
							<h3><?php the_title(); ?></h3>
							<h4><?php echo esc_attr(ale_get_meta('academicsdesc')); ?></h4>
							<div class="string">
								<?php echo ale_trim_excerpt(38); ?>
							</div>
							<hr>
							<div class="social">
								<?php if(ale_get_meta('academicssocialinst')){ ?>
									<a href="<?php echo esc_url(ale_get_meta('academicssocialinst')); ?>" class="instagram"><i class="fa fa-instagram"></i></a>
								<?php } ?>

								<?php if(ale_get_meta('academicssocialtwi')){ ?>
								<a href="<?php echo esc_url(ale_get_meta('academicssocialtwi')); ?>" class="twitter"><i class="fa fa-twitter"></i></a>
								<?php } ?>

								<?php if(ale_get_meta('academicssocialfb')){ ?>
								<a href="<?php echo esc_url(ale_get_meta('academicssocialfb')); ?>" class="facebook"><i class="fa fa-facebook"></i></a>
								<?php } ?>
							</div>
							<a href="<?php the_permalink(); ?>" class="button"><?php _e('Enroll in a lecture', 'aletheme'); ?></a>
						</div>
						<div class="col-12 clearfix">
							<div class="string">
								<?php echo ale_trim_excerpt(80); ?>
							</div>
							<?php $table_meta = get_post_meta($post->ID, 'ale_academic_table_details', true);
							if ( $table_meta ) : ?>
								<div class="col-12 story">
									<table>
										<tr>
											<td>
												<?php _e('Years', 'aletheme'); ?>
											</td>
											<?php foreach ( $table_meta as $field ) { ?>
												<td>
													<?php if ($field['year'] != '') echo esc_attr( $field['year'] );  ?>
												</td>
											<?php } ?>
										</tr>
										<tr>
											<td>
												<?php _e('Monday', 'aletheme'); ?>
											</td>
											<?php foreach ( $table_meta as $field ) { ?>
												<td>
													<?php if ($field['monday'] != '') echo esc_attr( $field['monday'] );  ?>
												</td>
											<?php } ?>
										</tr>
										<tr>
											<td>
												<?php _e('Tuesday', 'aletheme'); ?>
											</td>
											<?php foreach ( $table_meta as $field ) { ?>
												<td>
													<?php if ($field['tuesday'] != '') echo esc_attr( $field['tuesday'] );  ?>
												</td>
											<?php } ?>
										</tr>
										<tr>
											<td>
												<?php _e('Wednesday', 'aletheme'); ?>
											</td>
											<?php foreach ( $table_meta as $field ) { ?>
												<td>
													<?php if ($field['wednesday'] != '') echo esc_attr( $field['wednesday'] );  ?>
												</td>
											<?php } ?>
										</tr>
										<tr>
											<td>
												<?php _e('Thursday', 'aletheme'); ?>
											</td>
											<?php foreach ( $table_meta as $field ) { ?>
												<td>
													<?php if ($field['thursday'] != '') echo esc_attr( $field['thursday'] );  ?>
												</td>
											<?php } ?>
										</tr>
										<tr>
											<td>
												<?php _e('Friday', 'aletheme'); ?>
											</td>
											<?php foreach ( $table_meta as $field ) { ?>
												<td>
													<?php if ($field['friday'] != '') echo esc_attr( $field['friday'] );  ?>
												</td>
											<?php } ?>
										</tr>
									</table>
								</div>
							<?php endif; ?>
						</div>
					</div>
				<?php endwhile; endif; wp_reset_query();?>
			</div>
		<?php endif;?>
	</div>
<?php get_footer(); ?>