<?php
// Creating the widget
class Aletheme_Quick_Links_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		// Base ID of your widget
			'Aletheme_Quick_Links_Widget',

			// Widget name will appear in UI
			__('Aletheme Quick Links Widget', 'aletheme'),

			// Widget description
			array( 'description' => __( 'A widget that displays the quick links', 'aletheme' ), )
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		?>
		<div class="aletheme-quicklinks-widget">
			<?php
			if ( ! empty( $title ) )
				echo $args['before_title'] . $title . $args['after_title'];
			?>
			<div class="quicklinks">
				<ul>
					<?php if(ale_get_option('quicklinkstext1')){ ?>
						<li class="ib-col-6"><a href="<?php echo ale_get_option('quicklinkslink1'); ?>"><?php echo ale_get_option('quicklinkstext1'); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext2')){ ?>
					<li class="ib-col-6"><a href="<?php echo ale_get_option('quicklinkslink2'); ?>"><?php echo ale_get_option('quicklinkstext2'); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext3')){ ?>
					<li class="ib-col-6"><a href="<?php echo ale_get_option('quicklinkslink3'); ?>"><?php echo ale_get_option('quicklinkstext3'); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext4')){ ?>
					<li class="ib-col-6"><a href="<?php echo ale_get_option('quicklinkslink4'); ?>"><?php echo ale_get_option('quicklinkstext4'); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext5')){ ?>
					<li class="ib-col-6"><a href="<?php echo ale_get_option('quicklinkslink5'); ?>"><?php echo ale_get_option('quicklinkstext5'); ?></a></li>
					<?php } ?>

					<?php if(ale_get_option('quicklinkstext6')){ ?>
					<li class="ib-col-6"><a href="<?php echo ale_get_option('quicklinkslink6'); ?>"><?php echo ale_get_option('quicklinkstext6'); ?></a></li>
					<?php } ?>
				</ul>
			</div>

		</div><!--blog_widget-->


		<?php
		echo $args['after_widget'];
	}

	// Widget Backend
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Quick Links', 'aletheme' );
		}
		// Widget admin form
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
	<?php
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		return $instance;
	}
} // Class wpb_widget ends here

// Register and load the widget
function aletheme_load_link_widget() {
	register_widget( 'Aletheme_Quick_Links_Widget' );
}
add_action( 'widgets_init', 'aletheme_load_link_widget' );