<?php
// Creating the widget
class Aletheme_News_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		// Base ID of your widget
			'Aletheme_news_Widget',

			// Widget name will appear in UI
			__('Aletheme News Widget', 'aletheme'),

			// Widget description
			array( 'description' => __( 'A widget that displays the recent news', 'aletheme' ), )
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget( $args, $instance ) {
		$number = $instance['number'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		if ( ! empty( $title ) )
			echo $args['before_title'] . $title . '<a href="'.get_post_type_archive_link('news').'">'.__('View all news', 'aletheme').'</a>' . $args['after_title'];
		?>
		<div class="aletheme-news-widget">

			<?php wp_reset_query(); query_posts(
				array(
					'post__not_in' => get_option('sticky_posts'),
					'order' => 'DESC',
					'posts_per_page' => $number,
					'post_type' => 'news'
				)
			);
			wp_reset_query();
			$query_widget_news = new WP_Query(
				array(
					'posts_per_page' => $number,
					'post_type' => 'news',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts')
				)
			);
			if ($query_widget_news->have_posts()) : while ($query_widget_news->have_posts()) : $query_widget_news->the_post(); ?>
				<article>
					<span class="date"><?php the_time('j'); ?><span><?php the_time('D Y'); ?></span></span>
					<h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
					<?php echo ale_trim_excerpt(18); ?>
				</article>
			<?php endwhile; endif; wp_reset_query();?>

		</div><!--blog_widget-->


		<?php
		echo $args['after_widget'];
	}

	// Widget Backend
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'News', 'aletheme' );
		}
		if ( isset( $instance[ 'number' ] ) ) {
			$number = $instance[ 'number' ];
		}
		else {
			$number = __( '2', 'aletheme' );
		}
		// Widget admin form
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'News to show:' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
		</p>
	<?php
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['number'] = ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : '';
		return $instance;
	}
} // Class wpb_widget ends here

// Register and load the widget
function aletheme_load_widget() {
	register_widget( 'Aletheme_News_Widget' );
}
add_action( 'widgets_init', 'aletheme_load_widget' );