<?php
// Creating the widget
class Aletheme_Course_Filter_Widget extends WP_Widget {

    function __construct() {
        parent::__construct(
        // Base ID of your widget
            'Aletheme_Course_Filter_Widget',

            // Widget name will appear in UI
            __('Aletheme Course Filter Widget', 'aletheme'),

            // Widget description
            array( 'description' => __( 'A widget that searches for courses.', 'aletheme' ), )
        );
    }

    // Creating widget front-end
    // This is where the action happens
    public function widget( $args, $instance ) {
        $title = apply_filters( 'widget_title', $instance['title'] );
        // before and after widget arguments are defined by themes
        echo $args['before_widget'];
        if ( ! empty( $title ) )
            echo $args['before_title'] . $title . $args['after_title'];
        ?>
        <div class="aletheme-course-filter-widget">
            <form class="filters" method="post" action="<?php echo home_url('/course');  ?>">
                <label for="coursecat"><?php _e('Search By Speciality','aletheme'); ?></label>
                <select name="coursecat" id="coursecat" class="dropdown">
                    <?php $args = array(
                        'type'                     => 'course',
                        'child_of'                 => 0,
                        'parent'                   => '',
                        'orderby'                  => 'name',
                        'order'                    => 'ASC',
                        'hide_empty'               => 1,
                        'hierarchical'             => 1,
                        'exclude'                  => '',
                        'include'                  => '',
                        'number'                   => '',
                        'taxonomy'                 => 'course-category',
                        'pad_counts'               => false );

                    $categories = get_categories( $args );
                    foreach($categories as $cat){
                        echo '<option value="'.$cat->term_id.'">'.$cat->name.'</option>';
                    }?>
                </select>
                <label for="keywords"><?php _e('Fill Your Keywords','aletheme'); ?></label>
                <input type="text" name="keywords" id="keywords" placeholder="<?php _e('Type your keywords...', 'aletheme');?>">
                <input type="submit" name="submit" value="<?php _e('Search','aletheme'); ?>">
            </form>
        </div>
        <?php
        echo '</div>';
    }

    // Widget Backend
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'Search course', 'aletheme' );
        }
        // Widget admin form
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
    <?php
    }

    // Updating widget replacing old instances with new
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        return $instance;
    }
} // Class wpb_widget ends here

// Register and load the widget
function aletheme_load_filter_widget() {
    register_widget( 'Aletheme_Course_Filter_Widget' );
}
add_action( 'widgets_init', 'aletheme_load_filter_widget' );