<?php
// Creating the widget
class Aletheme_Courses_Widget extends WP_Widget {

    function __construct() {
        parent::__construct(
        // Base ID of your widget
            'Aletheme_Courses_Widget',

            // Widget name will appear in UI
            __('Aletheme Summer courses Widget', 'aletheme'),

            // Widget description
            array( 'description' => __( 'A widget that displays the Summer courses', 'aletheme' ), )
        );
    }

    // Creating widget front-end
    // This is where the action happens
    public function widget( $args, $instance ) {
        $title = apply_filters( 'widget_title', $instance['title'] );
        // before and after widget arguments are defined by themes
        echo $args['before_widget'];
        ?>
        <div class="aletheme-summercourses-widget">
            <?php
            if ( ! empty( $title ) )
                echo $args['before_title'] . $title . $args['after_title'];
            ?>
            <div class="summercourses">
                <p><?php echo ale_get_option('homesummercoursestext'); ?></p>
                <a href="<?php echo ale_get_option('homesummercourseslink'); ?>" class="button"><?php echo ale_get_option('homesummercourseslinktext'); ?></a>
            </div>

        </div><!--blog_widget-->


        <?php
        echo $args['after_widget'];
    }

    // Widget Backend
    public function form( $instance ) {
        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'Summer courses', 'aletheme' );
        }
        // Widget admin form
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
    <?php
    }

    // Updating widget replacing old instances with new
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        return $instance;
    }
} // Class wpb_widget ends here

// Register and load the widget
function aletheme_load_courses_widget() {
    register_widget( 'Aletheme_Courses_Widget' );
}
add_action( 'widgets_init', 'aletheme_load_courses_widget' );