<?php
/**
 * Blog Widget 
 */
class Aletheme_Blog_Widget extends WP_Widget 
{
	/**
	 * General Setup 
	 */
	public function __construct() {
	
		/* Widget settings. */
		$widget_ops = array(
			'classname' => 'ale_blog_widget', 
			'description' => __('A widget that displays your latest posts with image.', 'aletheme')
		);

		/* Widget control settings. */
		$control_ops = array(
			'width'		=> 300, 
			'height'	=> 350, 
			'id_base'	=> 'ale_blog_widget' 
		);

		/* Create the widget. */
		parent::__construct( 'ale_blog_widget', __('Aletheme Recent Posts', 'aletheme'), $widget_ops, $control_ops );
	}

	/**
	 * Display Widget
	 * @param array $args
	 * @param array $instance 
	 */
	public function widget( $args, $instance ) 
	{
		extract( $args );
		
		$title = apply_filters('widget_title', $instance['title'] );

		/* Our variables from the widget settings. */
		$number = $instance['number'];

		/* Before widget (defined by themes). */
		echo $before_widget;

		// Display Widget
		?> 
		<?php /* Display the widget title if one was input (before and after defined by themes). */
				$posts_page_url = get_page_uri(get_option( 'page_for_posts'));
				if ( $title )
					echo $before_title . $title . '<a href="'.home_url().'/' .$posts_page_url.'">'.__('View all posts', 'aletheme').'</a>' . $after_title ;
				?>
			<div class="aletheme-blog-widget">

				<?php 
				wp_reset_query();
				$query_widget_blog = new WP_Query(
					array(
						'posts_per_page' => $number,
						'post_type' => 'post',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts')
					)
				);
				if ($query_widget_blog->have_posts()) : while ($query_widget_blog->have_posts()) : $query_widget_blog->the_post(); ?>
					<article>
						<span class="date"><?php the_time('j'); ?><span> <?php the_time('D Y'); ?></span></span>
						<h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
						<?php echo ale_trim_excerpt(18); ?>
					</article>
				<?php endwhile;  endif; wp_reset_query();?>
				
			</div><!--blog_widget-->
		
		<?php

		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Update Widget
	 * @param array $new_instance
	 * @param array $old_instance
	 * @return array 
	 */
	public function update( $new_instance, $old_instance ) 
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['number'] = strip_tags( $new_instance['number'] );

		return $instance;
	}
	
	/**
	 * Widget Settings
	 * @param array $instance 
	 */
	public function form( $instance ) 
	{
		//default widget settings.
		$defaults = array(
			'title' => __('Recent Posts', 'aletheme'),
			'number' => 2
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'aletheme') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e('Posts to show:', 'aletheme') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance['number']; ?>" />
		</p>
	<?php
	}
}