<?php
function ale_library_filter($data){
	if ( get_query_var('paged') ){
		$paged = get_query_var('paged');
	} elseif ( get_query_var('page') ){
		$paged = get_query_var('page');
	} else{
		$paged = 'paged';
	}
	
	$args = array(
		'posts_per_page' => -1,
		'post_type' => 'library',
		'ignore_sticky_posts' => 1,
		'post__not_in' => get_option('sticky_posts'),
		'paged' => $paged,
		'tax_query' => array(
			'relation' => 'AND',
		),
		'meta_query' => array(
			'relation' => 'AND',

		)
	);

	if(isset($data['library_title']) && !empty($data['library_title'])){
		$title_value = $data['library_title'];
		array_push($args['meta_query'],array(
			'key' => 'ale_searchtitle',
			'value' => $data['library_title'],
			'compare' => 'LIKE'
		));
	}

	if(isset($data['library_genre']) && !empty($data['library_genre'])){
		array_push($args['tax_query'],array(
			'taxonomy' => 'library-category',
			'terms' => array( $data['library_genre'] )
		));
	}

	if(isset($data['library_year']) && !empty($data['library_year'])){
		array_push($args['meta_query'],array(
			'key' => 'ale_libraryyear',
			'value' => $data['library_year']
		));
	}
	if(empty($_POST)){
		global $post;
		wp_reset_query();
		if ( get_query_var('paged') ) $paged = get_query_var('paged');
		if ( get_query_var('page') ) $paged = get_query_var('page');
		$count = ale_get_option('paginationlibrary');
		$library_query = new WP_Query(
			array(
				'posts_per_page' => $count,
				'post_type' => 'library',
				'ignore_sticky_posts' => 1,
				'post__not_in' => get_option('sticky_posts'),
				'paged' => $paged
			)
		);
		if ($library_query->have_posts()) : while ($library_query->have_posts()) : $library_query->the_post(); ?>
			<div class="article">
				<div class="image">
					<?php if(get_the_post_thumbnail($post->ID,'library-single')){
						echo get_the_post_thumbnail($post->ID,'library-single');
					} else{
						echo '<img src="http://placehold.it/678x316/ece6d9/8d7a65&amp;text=No+image" alt>';
					}?>

					<a href="<?php the_permalink(); ?>" class="link">
						<span><?php _e('plus', 'aletheme');?></span>
					</a>
					<div>
						<ul class="share">
							<li class="googleplus"><a href="<?php echo ale_get_share('goglp'); ?>" onclick="window.open(this.href, 'Share on Google plus', 'width=600,height=300'); return false"></a></li>
							<li class="tweeter"><a href="<?php echo ale_get_share('tweet'); ?>" onclick="window.open(this.href, 'Share on Tweeter', 'width=600,height=300'); return false"></a></li>
							<li class="facebook"><a href="<?php echo ale_get_share('fb'); ?>" onclick="window.open(this.href, 'Share on Facebook', 'width=600,height=300'); return false"></a></li>
						</ul>

						<ul class="data">
							<li class="admin"><?php echo get_the_author(); ?></li>
							<li class="comments"><?php $comments_count = wp_count_comments($post->ID); echo $comments_count->total_comments. ' com.'; ?></li>
							<li class="tags"><?php the_tags(''); ?></li>
						</ul>
					</div>
				</div>
				<span class="date"><?php the_time('j'); ?><span><?php the_time('D Y'); ?></span></span>
				<h2><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h2>
				<?php echo ale_trim_excerpt(40); ?>
			</div>
		<?php endwhile;  endif; wp_reset_query();
	}else{
		global $post;
		wp_reset_query();
		$library_query = new WP_Query( $args );
		if ( $library_query->have_posts() ) { $count='';
			while ( $library_query->have_posts() ) { $library_query->the_post(); $count++; ?>
			<div class="article">
				<div class="image">
					<?php if(get_the_post_thumbnail($post->ID,'library-single')){
						echo get_the_post_thumbnail($post->ID,'library-single');
					} else{
						echo '<img src="http://placehold.it/678x316/ece6d9/8d7a65&amp;text=No+image" alt>';
					}?>

					<a href="<?php the_permalink(); ?>" class="link">
						<span><?php _e('plus', 'aletheme');?></span>
					</a>
					<div>
						<ul class="share">
							<li class="googleplus"><a href="<?php echo ale_get_share('goglp'); ?>" onclick="window.open(this.href, 'Share on Google plus', 'width=600,height=300'); return false"></a></li>
							<li class="tweeter"><a href="<?php echo ale_get_share('tweet'); ?>" onclick="window.open(this.href, 'Share on Tweeter', 'width=600,height=300'); return false"></a></li>
							<li class="facebook"><a href="<?php echo ale_get_share('fb'); ?>" onclick="window.open(this.href, 'Share on Facebook', 'width=600,height=300'); return false"></a></li>
						</ul>

						<ul class="data">
							<li class="admin"><?php echo get_the_author(); ?></li>
							<li class="comments"><?php $comments_count = wp_count_comments($post->ID); echo $comments_count->total_comments. ' com.'; ?></li>
							<li class="tags"><?php the_tags(''); ?></li>
						</ul>
					</div>
				</div>
				<span class="date"><?php the_time('j'); ?><span><?php the_time('D Y'); ?></span></span>
				<h2><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h2>
				<?php echo ale_trim_excerpt(40); ?>
			</div>
			<?php }} else {
			echo '<section class="not-found"><h3>'.__('Not found','aletheme').'</h3></section>';
		}
	}?>
	<div class="pagination">
		<?php ale_custom_page_links($library_query); ?>
	</div>
<?php }
