<?php
function ale_filter($data){
	if ( get_query_var('paged') ){
		$paged = get_query_var('paged');
	} elseif ( get_query_var('page') ){
		$paged = get_query_var('page');
	} else{
		$paged = 'paged';
	}
	
	$args = array(
		'posts_per_page' => -1,
		'post_type' => 'course',
		'ignore_sticky_posts' => 1,
		'post__not_in' => get_option('sticky_posts'),
		'paged' => $paged,
		'tax_query' => array(
			'relation' => 'AND',
		),
		'meta_query' => array(
			'relation' => 'AND',

		)
	);

	if(isset($data['coursecat'])){
		array_push($args['tax_query'],array(
			'taxonomy' => 'course-category',
			'terms' => array( $data['coursecat'] )
		));
	}
	if(isset($data['keywords']) && $data['keywords']){
		array_push($args['tax_query'],array(
			'taxonomy' => 'course-tag',
			'field' => 'slug',
			'terms' => array( $data['keywords'] )
		));
	}
	if(empty($_POST)){
		global $post;
		wp_reset_query();
		$count = ale_get_option('paginationcurse');
		$query_course = new WP_Query(
			array(
				'posts_per_page' => $count,
				'post_type' => 'course',
				'ignore_sticky_posts' => 1,
				'post__not_in' => get_option('sticky_posts'),
				'paged' => $paged
			)
		);
		if ($query_course->have_posts()) : while ($query_course->have_posts()) : $query_course->the_post();

			ale_part('course-archive-box');

		endwhile;  endif; wp_reset_query();
	}else{
		wp_reset_query();
		$query_course = new WP_Query( $args );
		global $post;
		if ( $query_course->have_posts() ) { $count='';
			while ( $query_course->have_posts() ) { $query_course->the_post(); $count++;

				ale_part('course-archive-box');

			}
		} else {
			echo '<section class="not-found"><h3>'.__('Nothing found for your criteria.','aletheme').'</h3></section>';
		}
	}?>
	<div class="pagination">
		<?php ale_custom_page_links($query_course); ?>
	</div>
<?php }
