<?php add_action('admin_init', 'add_tabs_meta_boxes', 2);
function add_tabs_meta_boxes() {
	global $post;
	$post_id = '';
	if(isset($_GET['post'])){
		$post_id = $_GET['post'] ? $_GET['post'] : $_POST['post_ID'] ;
	}
	$template_file = get_post_meta($post_id,'_wp_page_template',TRUE);
	if (($template_file == 'template-home-4.php')||($template_file == 'template-about-1.php')) {
		add_meta_box( 'ale_tabs_details', 'Tabs', 'ale_tabs_details_box_display', 'page', 'normal', 'high');
	}
}

function ale_tabs_details_box_display() {
global $post;

$ale_tabs_details = get_post_meta($post->ID, 'ale_tabs_details', true);


wp_nonce_field( 'ale_tabs_details_box_nonce', 'ale_tabs_details_box_nonce' );
?>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('.tabs-metabox_submit').click(function(e) {
			e.preventDefault();
			$('#publish').click();
		});
		$('#tabs-add-row').on('click', function() {
			var row = $('.tabs-empty-row.tabs-screen-reader-text').clone(true);
			row.removeClass('tabs-empty-row tabs-screen-reader-text');
			row.insertBefore('#tabs-repeatable-fieldset-one tbody>tr:last');
			return false;
		});
		$('.tabs-remove-row').on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});

		$('#tabs-repeatable-fieldset-one tbody').sortable({
			opacity: 0.6,
			revert: true,
			cursor: 'move',
			handle: '.sort'
		});
	});
</script>

<table id="tabs-repeatable-fieldset-one" width="100%">
	<thead>
	<tr>
		<th width="2%"></th>
		<th width="30%"><?php _e('Title', 'aletheme'); ?></th>
		<th width="60%"><?php _e('Text', 'aletheme'); ?></th>
		<th width="2%"></th>
	</tr>
	</thead>
	<tbody>
	<?php

	if ( $ale_tabs_details ) :

		foreach ( $ale_tabs_details as $field ) {
			?>
			<tr>
				<td><a class="button tabs-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
				<td><input type="text" class="widefat" name="title_tabs[]" value="<?php if($field['title_tabs'] != '') echo esc_attr( $field['title_tabs'] ); ?>" /></td>

				<td><input type="text" class="widefat" name="text_tabs[]" value="<?php if ($field['text_tabs'] != '') echo esc_attr( $field['text_tabs'] );  ?>" /></td>
				<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

			</tr>
		<?php
		}
	else :
		// show a blank one
		?>
		<tr>
			<td><a class="button tabs-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
			<td><input type="text" class="widefat" name="title_tabs[]" /></td>


			<td><input type="text" class="widefat" name="text_tabs[]" value="" /></td>
			<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

		</tr>
	<?php endif; ?>

	<!-- empty hidden one for jQuery -->
	<tr class="tabs-empty-row tabs-screen-reader-text">
		<td><a class="button tabs-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
		<td><input type="text" class="widefat" name="title_tabs[]" /></td>


		<td><input type="text" class="widefat" name="text_tabs[]" value="" /></td>
		<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

	</tr>
	</tbody>
</table>

<p><a id="tabs-add-row" class="button" href="#"><span class="dashicons dashicons-plus" style="line-height: 28px; font-size:14px;"></span> Add another</a>
	<input type="submit" class="tabs-metabox_submit" value="Save" />
</p>

<?php
}

add_action('save_post', 'ale_tabs_details_box_save');
function ale_tabs_details_box_save($post_id) {
	if ( ! isset( $_POST['ale_tabs_details_box_nonce'] ) ||
		! wp_verify_nonce( $_POST['ale_tabs_details_box_nonce'], 'ale_tabs_details_box_nonce' ) )
		return;

	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return;

	if (!current_user_can('edit_post', $post_id))
		return;

	$old = get_post_meta($post_id, 'ale_tabs_details', true);
	$new = array();


	$titles_tabs = $_POST['title_tabs'];
	$values_tabs = $_POST['text_tabs'];

	$count = count( $titles_tabs );

	for ( $i = 0; $i < $count; $i++ ) {
		if ( $titles_tabs[$i] != '' ) :
			$new[$i]['title_tabs'] = stripslashes( strip_tags( $titles_tabs[$i] ) );
			$new[$i]['text_tabs'] = stripslashes( $values_tabs[$i] );
		endif;
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'ale_tabs_details', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'ale_tabs_details', $old );
}